/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tickupdate.command;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.command.EditUtils;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.tickupdate.ITickUpdateHandler;
import org.eclipse.nebula.widgets.nattable.tickupdate.TickUpdateConfigAttributes;
import org.eclipse.nebula.widgets.nattable.tickupdate.command.TickUpdateCommand;

public class TickUpdateCommandHandler
extends AbstractLayerCommandHandler<TickUpdateCommand> {
    private static final Log LOG = LogFactory.getLog(TickUpdateCommandHandler.class);
    private SelectionLayer selectionLayer;

    public TickUpdateCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public boolean doCommand(TickUpdateCommand command) {
        PositionCoordinate[] selectedPositions = this.selectionLayer.getSelectedCellPositions();
        IConfigRegistry configRegistry = command.getConfigRegistry();
        if (selectedPositions.length > 1) {
            if (EditUtils.allCellsEditable(this.selectionLayer, configRegistry) && EditUtils.isEditorSame(this.selectionLayer, configRegistry) && EditUtils.isConverterSame(this.selectionLayer, configRegistry)) {
                PositionCoordinate[] positionCoordinateArray = selectedPositions;
                int n = selectedPositions.length;
                int n2 = 0;
                while (n2 < n) {
                    PositionCoordinate position = positionCoordinateArray[n2];
                    this.updateSingleCell(command, position);
                    ++n2;
                }
            }
        } else {
            this.updateSingleCell(command, this.selectionLayer.getLastSelectedCellPosition());
        }
        return true;
    }

    private void updateSingleCell(TickUpdateCommand command, PositionCoordinate selectedPosition) {
        if (selectedPosition != null) {
            ILayerCell cell = this.selectionLayer.getCellByPosition(selectedPosition.columnPosition, selectedPosition.rowPosition);
            IConfigRegistry configRegistry = command.getConfigRegistry();
            IEditableRule editableRule = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, "EDIT", cell.getConfigLabels().getLabels());
            IDataValidator validator = configRegistry.getConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, "EDIT", cell.getConfigLabels().getLabels());
            if (editableRule.isEditable(cell, configRegistry)) {
                Object newValue = this.getNewCellValue(command, cell);
                try {
                    if (validator == null || validator.validate(cell, configRegistry, newValue)) {
                        this.selectionLayer.doCommand(new UpdateDataCommand(this.selectionLayer, selectedPosition.columnPosition, selectedPosition.rowPosition, newValue));
                    } else {
                        LOG.warn((Object)("Tick update failed for cell at " + selectedPosition + " and value " + newValue + ". New value is not valid!"));
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)("Tick update failed for cell at " + selectedPosition + " and value " + newValue + ". " + e.getLocalizedMessage()));
                }
            }
        }
    }

    private Object getNewCellValue(TickUpdateCommand command, ILayerCell cell) {
        ITickUpdateHandler tickUpdateHandler = command.getConfigRegistry().getConfigAttribute(TickUpdateConfigAttributes.UPDATE_HANDLER, "EDIT", cell.getConfigLabels().getLabels());
        Object dataValue = cell.getDataValue();
        if (tickUpdateHandler != null && tickUpdateHandler.isApplicableFor(dataValue)) {
            if (command.isIncrement()) {
                return tickUpdateHandler.getIncrementedValue(dataValue);
            }
            return tickUpdateHandler.getDecrementedValue(dataValue);
        }
        return dataValue;
    }

    @Override
    public Class<TickUpdateCommand> getCommandClass() {
        return TickUpdateCommand.class;
    }
}

