/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.services.BadStateException;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceDescriptor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceMultiException;
import org.eclipse.papyrus.infra.core.services.ServiceNotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceStartKind;
import org.eclipse.papyrus.infra.core.services.ServiceState;
import org.eclipse.papyrus.infra.core.services.internal.LazyStartupEntry;
import org.eclipse.papyrus.infra.core.services.internal.PojoServiceEntry;
import org.eclipse.papyrus.infra.core.services.internal.ServiceAdapterEntry;
import org.eclipse.papyrus.infra.core.services.internal.ServiceEntry;
import org.eclipse.papyrus.infra.core.services.internal.ServiceFactoryEntry;
import org.eclipse.papyrus.infra.core.services.internal.ServiceStartupEntry;
import org.eclipse.papyrus.infra.core.services.internal.ServiceTypeEntry;
import org.eclipse.papyrus.infra.core.services.internal.StartStartupEntry;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;

public class ServicesRegistry {
    @Deprecated
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private Map<String, ServiceStartupEntry> addedServices = new HashMap<String, ServiceStartupEntry>();
    private Map<String, ServiceStartupEntry> namedServices = new HashMap<String, ServiceStartupEntry>();
    private List<ServiceStartupEntry> anonymousServices = new ArrayList<ServiceStartupEntry>();

    public void add(ServiceDescriptor serviceDescriptor) {
        ServiceDescriptor.ServiceTypeKind typeKind;
        ServiceStartupEntry service = this.addedServices.get(serviceDescriptor.getKey());
        if (service != null) {
            if (service.getDescriptor().getPriority() > serviceDescriptor.getPriority()) {
                return;
            }
            if (service.getDescriptor().getPriority() == serviceDescriptor.getPriority()) {
                Activator.log.warn("Two services with same priority (" + serviceDescriptor.getPriority() + ") are declared under key '" + service.getDescriptor().getKey() + "'. Keep the first encountered only. (bundles: " + service.getDescriptor().getClassBundleID() + ", " + serviceDescriptor.getClassBundleID() + ")");
            }
        }
        ServiceTypeEntry serviceTypeEntry = (typeKind = serviceDescriptor.getServiceTypeKind()) == ServiceDescriptor.ServiceTypeKind.service ? new ServiceEntry(serviceDescriptor) : (typeKind == ServiceDescriptor.ServiceTypeKind.serviceFactory ? new ServiceFactoryEntry(serviceDescriptor) : new PojoServiceEntry(serviceDescriptor));
        ServiceStartupEntry serviceEntry = serviceDescriptor.isStartAtStartup() ? new StartStartupEntry(serviceTypeEntry) : new LazyStartupEntry(serviceTypeEntry, this);
        this.addedServices.put(serviceDescriptor.getKey(), serviceEntry);
    }

    public void add(String key, int priority, IService serviceInstance) {
        this.add(key, priority, serviceInstance, ServiceStartKind.STARTUP);
    }

    public void add(Class<?> key, int priority, IService serviceInstance) {
        this.add(key.getName(), priority, serviceInstance, ServiceStartKind.STARTUP);
    }

    public void add(String key, int priority, IService serviceInstance, ServiceStartKind startKind) {
        ServiceStartupEntry service = this.addedServices.get(key);
        if (service != null) {
            if (service.getDescriptor().getPriority() > priority) {
                return;
            }
            if (service.getDescriptor().getPriority() == priority) {
                Activator.log.warn("Two services with same priority (" + priority + ") are declared under key '" + service.getDescriptor().getKey() + "'. Keep the first encountered only.");
            }
        }
        ServiceDescriptor descriptor = new ServiceDescriptor(key, serviceInstance.getClass().getName(), startKind, priority);
        if (startKind == ServiceStartKind.STARTUP) {
            this.addedServices.put(key, new StartStartupEntry(new ServiceEntry(descriptor, serviceInstance)));
        } else {
            this.addedServices.put(key, new LazyStartupEntry(new ServiceEntry(descriptor, serviceInstance), this));
        }
    }

    public void add(Class<?> key, int priority, IService serviceInstance, ServiceStartKind startKind) {
        this.add(key.getName(), priority, serviceInstance, startKind);
    }

    public void add(Class<?> key, int priority, Object serviceInstance) {
        this.add(key, priority, serviceInstance, ServiceStartKind.STARTUP);
    }

    public void add(String key, int priority, Object serviceInstance, ServiceStartKind startKind) {
        ServiceStartupEntry service;
        if (serviceInstance instanceof IService) {
            this.add(key, priority, (IService)serviceInstance, startKind);
        }
        if ((service = this.addedServices.get(key)) != null) {
            if (service.getDescriptor().getPriority() > priority) {
                return;
            }
            if (service.getDescriptor().getPriority() == priority) {
                Activator.log.warn("Two services with same priority (" + priority + ") are declared under key '" + service.getDescriptor().getKey() + "'. Keep the first encountered only.");
            }
        }
        ServiceDescriptor descriptor = new ServiceDescriptor(key, serviceInstance.getClass().getName(), startKind, priority);
        IService serviceAdapter = AdapterUtils.adapt(serviceInstance, IService.class, null);
        PojoServiceEntry type = serviceAdapter != null ? new ServiceAdapterEntry(descriptor, serviceInstance, serviceAdapter) : new PojoServiceEntry(descriptor, serviceInstance);
        this.addedServices.put(key, switch (startKind) {
            case ServiceStartKind.STARTUP -> new StartStartupEntry(type);
            case ServiceStartKind.LAZY -> new LazyStartupEntry(type, this);
            default -> throw new IllegalArgumentException("Unrecognized startKind: " + (Object)((Object)startKind));
        });
    }

    public void add(Class<?> key, int priority, Object serviceInstance, ServiceStartKind startKind) {
        this.add(key.getName(), priority, serviceInstance, startKind);
    }

    public void remove(ServiceDescriptor serviceDescriptor) throws ServiceException {
        this.remove(serviceDescriptor.getKey());
    }

    public void remove(Object key) throws ServiceException {
        ServiceStartupEntry service = this.namedServices.remove(key);
        if (service == null) {
            return;
        }
        service.disposeService();
    }

    public Object getService(Object key) throws ServiceException {
        ServiceStartupEntry service = this.namedServices.get(key);
        if (service == null) {
            service = this.addedServices.get(key);
            if (service != null) {
                throw new BadStateException("Registry should be started before.", service.getState(), service.getDescriptor());
            }
            throw new ServiceNotFoundException("No service registered under '" + key + "'");
        }
        return service.getServiceInstance();
    }

    public <S> S getService(Class<S> key) throws ServiceException {
        String realKey = key.getName();
        ServiceStartupEntry service = this.namedServices.get(realKey);
        if (service == null) {
            service = this.addedServices.get(realKey);
            if (service != null) {
                throw new BadStateException("Registry should be started before.", service.getState(), service.getDescriptor());
            }
            throw new ServiceNotFoundException("No service registered under '" + key + "'");
        }
        return (S)service.getServiceInstance();
    }

    public boolean isStarted(Object key) throws ServiceNotFoundException {
        ServiceStartupEntry service = this.namedServices.get(key);
        if (service == null) {
            throw new ServiceNotFoundException("No service registered under '" + key + "'");
        }
        return service.isStarted();
    }

    public ServiceState serviceState(Object key) throws ServiceNotFoundException {
        ServiceStartupEntry service = this.namedServices.get(key);
        if (service == null) {
            throw new ServiceNotFoundException("No service registered under '" + key + "'");
        }
        return service.getState();
    }

    /*
     * Unable to fully structure code
     */
    public void startRegistry() throws ServiceMultiException {
        block5: {
            errors = new ServiceMultiException();
            map = new LookupMap(this.addedServices, this.namedServices);
            try {
                this.checkDependencies(this.addedServices.values(), map);
                break block5;
            }
            catch (ServiceMultiException ex) {
                ** for (t : ex.getExceptions())
            }
lbl-1000:
            // 1 sources

            {
                errors.addException(t);
                continue;
            }
        }
        roots = this.getServiceRoots(this.addedServices.values(), map);
        this.checkCycle(roots, map);
        roots = this.retainsToStartServices(roots);
        toStart = this.buildTopologicalListOfServicesToStart(roots, map);
        if (Activator.log.isDebugEnabled()) {
            this.showServices(" Services to start:", toStart);
        }
        this.createServices(toStart, errors);
        this.registerServices(this.addedServices.values());
        this.initServices(toStart, errors);
        this.startServices(toStart, errors);
        if (errors.getExceptions().size() > 0) {
            throw errors;
        }
    }

    public void startServices(List<String> serviceKeys) throws ServiceMultiException, ServiceNotFoundException {
        LookupMap map = new LookupMap(this.addedServices, this.namedServices);
        List<ServiceStartupEntry> services = this.keysToServices(serviceKeys, map);
        this.startServices(services, map);
    }

    public void startServices(String ... serviceKeys) throws ServiceMultiException, ServiceNotFoundException {
        List<String> serviceKeysList = Arrays.asList(serviceKeys);
        this.startServices(serviceKeysList);
    }

    public void startServicesByClassKeys(List<Class<?>> serviceKeys) throws ServiceMultiException, ServiceNotFoundException {
        LookupMap map = new LookupMap(this.addedServices, this.namedServices);
        List<ServiceStartupEntry> services = this.classKeysToServices(serviceKeys, map);
        this.startServices(services, map);
    }

    public void startServicesByClassKeys(Class<?> ... serviceKeys) throws ServiceMultiException, ServiceNotFoundException {
        List<Class<?>> serviceKeysList = Arrays.asList(serviceKeys);
        this.startServicesByClassKeys(serviceKeysList);
    }

    /*
     * Unable to fully structure code
     */
    private void startServices(List<ServiceStartupEntry> services, LookupMap map) throws ServiceMultiException {
        block5: {
            errors = new ServiceMultiException();
            try {
                this.checkDependencies(services, map);
                break block5;
            }
            catch (ServiceMultiException ex) {
                ** for (t : ex.getExceptions())
            }
lbl-1000:
            // 1 sources

            {
                errors.addException(t);
                continue;
            }
        }
        roots = this.getServiceRoots(services, map);
        if (Activator.log.isDebugEnabled()) {
            this.showServices(" Roots:", roots);
        }
        this.checkCycle(roots, map);
        roots = this.retainUnstartedServices(roots);
        toStart = this.buildTopologicalListOfServicesToStart(roots, map);
        toStart = this.retainUnstartedServices(toStart);
        this.showServices(" Services to start:", toStart);
        this.createServices(toStart, errors);
        this.registerServices(toStart);
        this.initServices(toStart, errors);
        this.startServices(toStart, errors);
        if (errors.getExceptions().size() > 0) {
            throw errors;
        }
    }

    private List<ServiceStartupEntry> keysToServices(List<String> serviceKeys, LookupMap map) throws ServiceNotFoundException {
        ArrayList<ServiceStartupEntry> result = new ArrayList<ServiceStartupEntry>(serviceKeys.size());
        for (String key : serviceKeys) {
            result.add(map.getChecked(key));
        }
        return result;
    }

    private List<ServiceStartupEntry> classKeysToServices(List<Class<?>> serviceKeys, LookupMap map) throws ServiceNotFoundException {
        ArrayList<ServiceStartupEntry> result = new ArrayList<ServiceStartupEntry>(serviceKeys.size());
        for (Class<?> key : serviceKeys) {
            result.add(map.getChecked(key.getName()));
        }
        return result;
    }

    private void showServices(String message, Collection<ServiceStartupEntry> roots) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("--------------------------\n");
        buffer.append(message);
        buffer.append("\n");
        for (ServiceStartupEntry service : roots) {
            buffer.append("  ");
            buffer.append(service.getDescriptor().toString());
            buffer.append("\n");
        }
        buffer.append("--------- done -----------\n");
        Activator.log.debug(buffer.toString());
    }

    private void checkDependencies(Collection<ServiceStartupEntry> services, LookupMap map) throws ServiceMultiException {
        ServiceMultiException errors = new ServiceMultiException();
        for (ServiceStartupEntry service : services) {
            ServiceDescriptor desc = service.getDescriptor();
            for (String key : desc.getRequiredServiceKeys()) {
                try {
                    map.getChecked(key);
                }
                catch (ServiceNotFoundException e) {
                    errors.addException(desc.getKey(), e);
                }
            }
        }
        if (errors.getExceptions().size() > 0) {
            throw errors;
        }
    }

    private List<ServiceStartupEntry> retainsToStartServices(Collection<ServiceStartupEntry> services) {
        ArrayList<ServiceStartupEntry> result = new ArrayList<ServiceStartupEntry>();
        for (ServiceStartupEntry service : services) {
            ServiceDescriptor desc = service.getDescriptor();
            if (service.getState() != ServiceState.registered || !desc.isStartAtStartup()) continue;
            result.add(service);
        }
        return result;
    }

    private List<ServiceStartupEntry> retainUnstartedServices(Collection<ServiceStartupEntry> services) {
        ArrayList<ServiceStartupEntry> result = new ArrayList<ServiceStartupEntry>(services.size());
        for (ServiceStartupEntry service : services) {
            if (service.getState() != ServiceState.registered) continue;
            result.add(service);
        }
        return result;
    }

    private void checkCycle(Collection<ServiceStartupEntry> roots, LookupMap map) {
    }

    private List<ServiceStartupEntry> buildTopologicalListOfServicesToStart(Collection<ServiceStartupEntry> roots, LookupMap map) {
        ArrayList<ServiceStartupEntry> result = new ArrayList<ServiceStartupEntry>();
        for (ServiceStartupEntry root : roots) {
            this.walkGraphDepthFirst(result, root, map);
        }
        return result;
    }

    private void walkGraphDepthFirst(List<ServiceStartupEntry> result, ServiceStartupEntry node, LookupMap map) {
        if (result.contains(node) || node.isStarted()) {
            return;
        }
        for (String serviceKey : node.getDescriptor().getRequiredServiceKeys()) {
            try {
                ServiceStartupEntry child = map.getChecked(serviceKey);
                this.walkGraphDepthFirst(result, child, map);
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
        }
        result.add(node);
    }

    private Collection<ServiceStartupEntry> getServiceRoots(Collection<ServiceStartupEntry> addedServices, LookupMap keyServiceMap) {
        ArrayList<ServiceStartupEntry> services = new ArrayList<ServiceStartupEntry>(addedServices);
        ArrayList<ServiceStartupEntry> allRequired = new ArrayList<ServiceStartupEntry>();
        for (ServiceStartupEntry service : services) {
            for (String serviceKey : service.getDescriptor().getRequiredServiceKeys()) {
                try {
                    ServiceStartupEntry child = keyServiceMap.getChecked(serviceKey);
                    allRequired.add(child);
                }
                catch (ServiceNotFoundException serviceNotFoundException) {
                    // empty catch block
                }
            }
        }
        services.removeAll(allRequired);
        return services;
    }

    public void disposeRegistry() throws ServiceMultiException {
        ServiceMultiException errors = new ServiceMultiException();
        this.disposeServices(this.namedServices.values(), errors);
        this.disposeServices(this.anonymousServices, errors);
        this.addedServices.clear();
        this.anonymousServices.clear();
        this.namedServices.clear();
        if (errors.getExceptions().size() > 0) {
            throw errors;
        }
    }

    private void createServices(List<ServiceStartupEntry> toStart, ServiceMultiException errors) {
        for (ServiceStartupEntry serviceEntry : toStart) {
            try {
                serviceEntry.createService();
            }
            catch (ServiceException e) {
                errors.addException(serviceEntry.getDescriptor().getKey(), e);
            }
        }
    }

    private void registerServices(Collection<ServiceStartupEntry> toStart) {
        for (ServiceStartupEntry serviceEntry : toStart) {
            ServiceDescriptor desc = serviceEntry.getDescriptor();
            if (desc.isAnonymous()) {
                this.anonymousServices.add(serviceEntry);
                continue;
            }
            this.namedServices.put(desc.getKey(), serviceEntry);
        }
    }

    private void initServices(List<ServiceStartupEntry> toStart, ServiceMultiException errors) {
        for (ServiceStartupEntry serviceEntry : toStart) {
            try {
                serviceEntry.initService(this);
            }
            catch (ServiceException e) {
                errors.addException(serviceEntry.getDescriptor().getKey(), e);
            }
        }
    }

    private void startServices(List<ServiceStartupEntry> toStart, ServiceMultiException errors) {
        for (ServiceStartupEntry serviceEntry : toStart) {
            try {
                serviceEntry.startService();
            }
            catch (ServiceException e) {
                errors.addException(serviceEntry.getDescriptor().getKey(), e);
            }
        }
    }

    private void disposeServices(Collection<ServiceStartupEntry> services, ServiceMultiException errors) {
        for (ServiceStartupEntry serviceEntry : services) {
            try {
                serviceEntry.disposeService();
            }
            catch (Exception ex) {
                errors.addException(serviceEntry.getDescriptor(), ex);
            }
        }
    }

    private class LookupMap {
        Map<String, ServiceStartupEntry> map1;
        Map<String, ServiceStartupEntry> map2;

        public LookupMap(Map<String, ServiceStartupEntry> map1, Map<String, ServiceStartupEntry> map2) {
            this.map1 = map1;
            this.map2 = map2;
        }

        public LookupMap(Map<String, ServiceStartupEntry> map) {
            this(map, null);
        }

        public ServiceStartupEntry get(String key) {
            ServiceStartupEntry res = this.map1.get(key);
            if (res != null) {
                return res;
            }
            if (this.map2 != null) {
                res = this.map2.get(key);
            }
            return res;
        }

        public ServiceStartupEntry getChecked(String key) throws ServiceNotFoundException {
            ServiceStartupEntry res = this.map1.get(key);
            if (res != null) {
                return res;
            }
            if (this.map2 != null) {
                res = this.map2.get(key);
            }
            if (res != null) {
                return res;
            }
            throw new ServiceNotFoundException("No service found under key '" + key.toString() + "'");
        }
    }
}

