/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.actionprovider;

import java.util.EventObject;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.papyrus.views.modelexplorer.actionprovider.AbstractCommonActionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;

public class UndoRedoActionProvider
extends AbstractCommonActionProvider
implements CommandStackListener {
    private UndoActionHandler undoAction = null;
    private RedoActionHandler redoAction = null;
    private CommandStack commandStack;

    private CommandStack getCommandStack() {
        CommonNavigator navigator;
        if (this.commandStack == null && (navigator = this.getCommonNavigator()) instanceof IEditingDomainProvider) {
            EditingDomain editingDomain = ((IEditingDomainProvider)navigator).getEditingDomain();
            this.commandStack = editingDomain.getCommandStack();
        }
        return this.commandStack;
    }

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        ICommonViewerSite viewSite = aSite.getViewSite();
        if (viewSite instanceof ICommonViewerWorkbenchSite) {
            IWorkbenchPartSite partSite = ((ICommonViewerWorkbenchSite)viewSite).getSite();
            this.undoAction = new UndoActionHandler(partSite, this.getUndoContext());
            this.redoAction = new RedoActionHandler(partSite, this.getUndoContext());
        }
        this.getCommandStack().addCommandStackListener((CommandStackListener)this);
    }

    private IUndoContext getUndoContext() {
        IUndoContext context = null;
        CommonNavigator navigator = this.getCommonNavigator();
        if (navigator instanceof IAdaptable) {
            context = (IUndoContext)navigator.getAdapter(IUndoContext.class);
        }
        return context;
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    public void commandStackChanged(EventObject event) {
        if (this.undoAction != null) {
            this.undoAction.update();
        }
        if (this.redoAction != null) {
            this.redoAction.update();
        }
    }

    public void dispose() {
        this.getCommandStack().removeCommandStackListener((CommandStackListener)this);
        this.commandStack = null;
        if (this.undoAction != null) {
            this.undoAction.dispose();
            this.undoAction = null;
        }
        if (this.redoAction != null) {
            this.redoAction.dispose();
            this.redoAction = null;
        }
        super.dispose();
    }
}

