/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.dnd.strategy;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.DropStrategy;

public abstract class AbstractDropStrategy
implements DropStrategy {
    protected EObject getTargetSemanticElement(EditPart targetEditPart) {
        return EMFHelper.getEObject((Object)targetEditPart);
    }

    protected View getTargetView(EditPart targetEditPart) {
        return NotationHelper.findView((Object)targetEditPart);
    }

    protected List<Object> getSourceObjects(Request request) {
        List editParts;
        LinkedList<Object> result = new LinkedList<Object>();
        if (request instanceof DropObjectsRequest) {
            List objects = ((DropObjectsRequest)request).getObjects();
            if (objects != null) {
                result.addAll(objects);
            }
        } else if (request instanceof GroupRequest && (editParts = ((ChangeBoundsRequest)request).getEditParts()) != null) {
            result.addAll(editParts);
        }
        return result;
    }

    protected List<EObject> getSourceEObjects(Request request) {
        LinkedList<EObject> result = new LinkedList<EObject>();
        for (Object object : this.getSourceObjects(request)) {
            EObject eObject = EMFHelper.getEObject((Object)object);
            if (eObject instanceof View) {
                eObject = ((View)eObject).getElement();
            }
            if (eObject == null) continue;
            result.add(eObject);
        }
        return result;
    }

    protected DropObjectsRequest getDropObjectsRequest(Request request) {
        if (request instanceof DropObjectsRequest) {
            return (DropObjectsRequest)request;
        }
        if (request instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
            Iterator<Object> editParts = ToolUtilities.getSelectionWithoutDependants((List)changeBoundsRequest.getEditParts()).stream().filter(EditPart.class::isInstance).map(EditPart.class::cast).toList().iterator();
            LinkedList<EObject> elements = new LinkedList<EObject>();
            while (editParts.hasNext()) {
                EObject element;
                EditPart editPart = (EditPart)editParts.next();
                if (!(editPart instanceof IGraphicalEditPart) || (element = ViewUtil.resolveSemanticElement((View)((View)((IGraphicalEditPart)editPart).getModel()))) == null) continue;
                elements.add(element);
            }
            DropObjectsRequest req = new DropObjectsRequest();
            req.setObjects(elements);
            req.setAllowedDetail(7);
            req.setLocation(changeBoundsRequest.getLocation());
            req.setRequiredDetail(1);
            return req;
        }
        return null;
    }
}

