/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.providers;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.labelprovider.service.IFilteredLabelProvider;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.uml.search.ui.Activator;
import org.eclipse.papyrus.uml.search.ui.Messages;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.views.search.results.AttributeMatch;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class AttributeMatchLabelProvider
implements IFilteredLabelProvider {
    public Image getImage(Object element) {
        if (element instanceof AttributeMatch) {
            LabelProviderServiceImpl service = new LabelProviderServiceImpl();
            try {
                service.startService();
                return service.getLabelProvider().getImage(((AttributeMatch)element).getMetaAttribute());
            }
            catch (ServiceException e) {
                Activator.log.warn(Messages.AttributeMatchLabelProvider_0 + String.valueOf(((AttributeMatch)element).getMetaAttribute()));
            }
        }
        return null;
    }

    private String printResult(String value, int offset, int length, String attributeName) {
        return "\"" + value.substring(offset, offset + length) + "\"" + Messages.AttributeMatchLabelProvider_3 + "\"" + value + "\" [" + (offset + 1) + "," + (offset + length) + "] (" + attributeName + Messages.AttributeMatchLabelProvider_8 + ")";
    }

    public String getText(Object element) {
        AttributeMatch attributeMatch;
        if (element instanceof AttributeMatch && (attributeMatch = (AttributeMatch)element).getSource() instanceof EObject) {
            Property source;
            Class containingClass;
            EObject target = (EObject)attributeMatch.getSource();
            if (attributeMatch.getMetaAttribute() instanceof EAttribute) {
                EAttribute source2 = (EAttribute)attributeMatch.getMetaAttribute();
                if (target.eGet((EStructuralFeature)source2) instanceof String) {
                    String value = (String)target.eGet((EStructuralFeature)source2);
                    return this.printResult(value, attributeMatch.getOffset(), attributeMatch.getLength(), source2.getName());
                }
                String value = String.valueOf(target.eGet((EStructuralFeature)source2));
                return this.printResult(value, attributeMatch.getOffset(), attributeMatch.getLength(), source2.getName());
            }
            if (attributeMatch.getMetaAttribute() instanceof Property && (containingClass = (source = (Property)attributeMatch.getMetaAttribute()).getClass_()) instanceof Stereotype && target instanceof Element) {
                String value = StereotypeUtil.displayPropertyValueOnly((Stereotype)((Stereotype)containingClass), (Property)((Property)attributeMatch.getMetaAttribute()), (Element)((Element)target), (String)"");
                return this.printResult(value, attributeMatch.getOffset(), attributeMatch.getLength(), source.getName());
            }
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public boolean accept(Object element) {
        return element instanceof AttributeMatch;
    }

    private String getStringValueOfProperty(Element element, Stereotype stereotype, Property property) {
        Object value = element.getValue(stereotype, property.getName());
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof EnumerationLiteral) {
            return ((EnumerationLiteral)value).getName();
        }
        return String.valueOf(value);
    }

    private String getStringValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof EnumerationLiteral) {
            return ((EnumerationLiteral)value).getName();
        }
        if (value instanceof NamedElement) {
            return ((NamedElement)value).getName();
        }
        if (value instanceof EObject) {
            Element baseElement = UMLUtil.getBaseElement((EObject)((EObject)value));
            return this.getStringValue(baseElement);
        }
        return String.valueOf(value);
    }

    private EList<String> getStringValuesOfProperty(Element element, Stereotype stereotype, Property property) {
        BasicEList results = new BasicEList();
        Object values = element.getValue(stereotype, property.getName());
        if (values instanceof EList) {
            for (Object val : (EList)values) {
                results.add((Object)this.getStringValue(val));
            }
        } else {
            results.add((Object)this.getStringValue(values));
        }
        return results;
    }
}

