/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.reconciler;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconciler;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.gmfdiag.style.PapyrusDiagramStyle;
import org.eclipse.papyrus.infra.gmfdiag.style.StyleFactory;
import org.eclipse.papyrus.infra.viewpoints.style.PapyrusViewStyle;

public abstract class DiagramReconciler_1_3_0
extends DiagramReconciler {
    @Override
    public ICommand getReconcileCommand(Diagram diagram) {
        PapyrusViewStyle oldStyle = null;
        for (Object obj : new ArrayList(diagram.getStyles())) {
            if (!(obj instanceof PapyrusViewStyle)) continue;
            oldStyle = (PapyrusViewStyle)obj;
        }
        PapyrusDiagram diagramKind = this.getDiagramKind(diagram, oldStyle);
        PapyrusDiagramStyle newStyle = null;
        for (Object obj : new ArrayList(diagram.getStyles())) {
            if (!(obj instanceof PapyrusDiagramStyle)) continue;
            newStyle = (PapyrusDiagramStyle)obj;
        }
        if (newStyle == null && diagramKind != null) {
            newStyle = StyleFactory.eINSTANCE.createPapyrusDiagramStyle();
            if (oldStyle != null) {
                newStyle.setOwner(oldStyle.getOwner());
            } else {
                newStyle.setOwner(diagram.getElement());
            }
            newStyle.setDiagramKindId(diagramKind.getId());
            return new ReplacePapyrusViewStyleCommand(diagram, oldStyle, newStyle);
        }
        return null;
    }

    protected abstract PapyrusDiagram getDiagramKind(Diagram var1, PapyrusViewStyle var2);

    protected class ReplacePapyrusViewStyleCommand
    extends AbstractCommand {
        private Diagram diagram;
        private PapyrusViewStyle oldStyle;
        private PapyrusDiagramStyle newStyle;

        public ReplacePapyrusViewStyleCommand(Diagram diagram, PapyrusViewStyle oldStyle, PapyrusDiagramStyle newStyle) {
            super("Replace the papyrus view style from 1.2.0 to 1.3.0");
            this.diagram = diagram;
            this.oldStyle = oldStyle;
            this.newStyle = newStyle;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            int index = this.diagram.getStyles().indexOf((Object)this.oldStyle);
            if (index > -1) {
                this.diagram.getStyles().remove(index);
                this.diagram.getStyles().add(index, (Object)this.newStyle);
            } else {
                this.diagram.getStyles().add((Object)this.newStyle);
            }
            return CommandResult.newOKCommandResult();
        }

        public boolean canUndo() {
            return false;
        }

        public boolean canRedo() {
            return false;
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canRedo false");
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canUndo false");
        }
    }
}

