/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.presentation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.ETypedElementCase;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.ETypedElementSwitchQuery;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.presentation.EMFUtil;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.presentation.ImageProvider;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetAttribute;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetElement;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetReference;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.ParameterValue;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.query.EObjectLiteralQuery;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.query.FalseLiteralQuery;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.query.FloatLiteralQuery;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.query.IntegerLiteralQuery;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.query.IsOneOfQuery;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.query.NavigationQuery;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.query.NullLiteralQuery;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.query.OperationCallQuery;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.query.StringLiteralQuery;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.query.TrueLiteralQuery;
import org.eclipse.papyrus.emf.facet.query.java.metamodel.v0_2_0.javaquery.JavaQuery;
import org.eclipse.papyrus.emf.facet.query.ocl.metamodel.oclquery.OclQuery;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class CustomViewer {
    private static final int VALUE_COLUMN_WIDTH = 200;
    private static final int TYPE_COLUMN_WIDTH = 200;
    private static final int FEATURE_COLUMN_WIDTH = 200;
    private final TreeViewer treeViewer;
    private static final String TOP_LEFT_OVERLAY_ICON_PATH = "topLeftOverlay";
    private static final String TOP_MIDDLE_OVERLAY_ICON_PATH = "topMiddleOverlay";
    private static final String TOP_RIGHT_OVERLAY_ICON_PATH = "topRightOverlay";
    private static final String MIDDLE_LEFT_OVERLAY_ICON_PATH = "middleLeftOverlay";
    private static final String MIDDLE_RIGHT_OVERLAY_ICON_PATH = "middleRightOverlay";
    private static final String BOTTOM_LEFT_OVERLAY_ICON_PATH = "bottomLeftOverlay";
    private static final String BOTTOM_MIDDLE_OVERLAY_ICON_PATH = "bottomMiddleOverlay";
    private static final String BOTTOM_RIGHT_OVERLAY_ICON_PATH = "bottomRightOverlay";
    private static final String CUSTOMIZATION_LABEL = "label";
    private static final String CUSTOMIZATION_IMAGE = "image";
    private static final String CUSTOMIZATION_FOREGROUND = "foreground";
    private static final String CUSTOMIZATION_BACKGROUND = "background";
    private static final String FONT_NAME = "fontName";
    private static final String FONT_SIZE = "fontSize";
    private static final String FONT_BOLD = "isBold";
    private static final String FONT_ITALIC = "isItalic";
    private static final String FONT_UNDERLINE = "isUnderlined";
    private static final String FONT_STRUKETHROUGH = "isStruckthrough";

    public CustomViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 68356);
        this.treeViewer.getTree().setHeaderVisible(true);
        TreeViewerColumn featureColumn = new TreeViewerColumn(this.treeViewer, 16384);
        featureColumn.getColumn().setText("feature column");
        featureColumn.getColumn().setWidth(200);
        TreeViewerColumn typeColumn = new TreeViewerColumn(this.treeViewer, 16384);
        typeColumn.getColumn().setText("feature type");
        typeColumn.getColumn().setWidth(200);
        TreeViewerColumn valueColumn = new TreeViewerColumn(this.treeViewer, 16384);
        valueColumn.getColumn().setText("feature value");
        valueColumn.getColumn().setWidth(200);
        this.treeViewer.setContentProvider((IContentProvider)new CustomViewerContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new FeatureLabelProvider());
        this.treeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof FacetOperation) {
                    return 0;
                }
                return super.compare(viewer, e1, e2);
            }
        });
        featureColumn.setLabelProvider((CellLabelProvider)new FeatureLabelProvider());
        typeColumn.setLabelProvider((CellLabelProvider)new TypeLabelProvider());
        valueColumn.setLabelProvider((CellLabelProvider)new ValueLabelProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CustomViewer.this.treeViewer.refresh();
            }
        });
    }

    public void setInput(Object input) {
        this.treeViewer.setInput(input);
    }

    public void refresh() {
        if (!this.treeViewer.getTree().isDisposed()) {
            try {
                this.treeViewer.getTree().setRedraw(false);
                this.treeViewer.refresh();
            }
            finally {
                this.treeViewer.getTree().setRedraw(true);
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener selectionChangedListener) {
        this.treeViewer.addSelectionChangedListener(selectionChangedListener);
    }

    public ISelection getSelection() {
        return this.treeViewer.getSelection();
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    protected class CustomViewerContentProvider
    implements ITreeContentProvider {
        protected CustomViewerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Object> facetOperations = new ArrayList<Object>();
            if (inputElement instanceof FacetOperation) {
                FacetOperation facetOperation = (FacetOperation)inputElement;
                facetOperations.add(facetOperation);
            }
            if (inputElement instanceof FacetElement) {
                FacetElement facetElement = (FacetElement)inputElement;
                facetOperations.add(facetElement);
            }
            if (inputElement instanceof List) {
                for (Object object : (List)inputElement) {
                    if (!(object instanceof DerivedTypedElement)) continue;
                    facetOperations.add(object);
                }
            }
            return facetOperations.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof FacetOperation) {
                FacetOperation facetOperation = (FacetOperation)parentElement;
                BasicEList parameters = new BasicEList();
                parameters.addAll((Collection)facetOperation.getEParameters());
                return parameters.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof EParameter) {
                EParameter eParameter = (EParameter)element;
                return eParameter.getEOperation();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof FacetOperation) {
                FacetOperation facetOperation = (FacetOperation)element;
                return !facetOperation.getEParameters().isEmpty();
            }
            return false;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class FeatureLabelProvider
    extends ColumnLabelProvider {
        protected FeatureLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof DerivedTypedElement) {
                DerivedTypedElement facetElement = (DerivedTypedElement)element;
                return facetElement.getName();
            }
            if (element instanceof ParameterValue) {
                ParameterValue parameterValue = (ParameterValue)element;
                return parameterValue.getParameter().getName();
            }
            if (element instanceof EParameter) {
                EParameter parameterValue = (EParameter)element;
                return parameterValue.getName();
            }
            return element.toString();
        }

        public Font getFont(Object element) {
            return null;
        }
    }

    protected class TypeLabelProvider
    extends ColumnLabelProvider {
        protected TypeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof DerivedTypedElement) {
                DerivedTypedElement facetElement = (DerivedTypedElement)element;
                if (facetElement instanceof FacetAttribute || facetElement instanceof FacetReference) {
                    return facetElement.getEType().getName();
                }
                DerivedTypedElement override = facetElement.getOverride();
                if (override != null) {
                    return override.getName();
                }
                return "N/A";
            }
            if (element instanceof EParameter) {
                EParameter eParameter = (EParameter)element;
                return eParameter.getEType().getName();
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            if (element instanceof DerivedTypedElement) {
                DerivedTypedElement facetElement = (DerivedTypedElement)element;
                if (facetElement instanceof FacetAttribute || facetElement instanceof FacetReference) {
                    return ImageProvider.getInstance().getAttributeIcon();
                }
                DerivedTypedElement override = facetElement.getOverride();
                if (override != null) {
                    String overrideName = override.getName();
                    if (CustomViewer.TOP_LEFT_OVERLAY_ICON_PATH.equals(overrideName)) {
                        return ImageProvider.getInstance().getTopLeftOverlayIcon();
                    }
                    if (CustomViewer.TOP_MIDDLE_OVERLAY_ICON_PATH.equals(overrideName)) {
                        return ImageProvider.getInstance().getTopMiddleOverlayIcon();
                    }
                    if (CustomViewer.TOP_RIGHT_OVERLAY_ICON_PATH.equals(overrideName)) {
                        return ImageProvider.getInstance().getTopRightOverlayIcon();
                    }
                    if (CustomViewer.MIDDLE_LEFT_OVERLAY_ICON_PATH.equals(overrideName)) {
                        return ImageProvider.getInstance().getMiddleLeftOverlayIcon();
                    }
                    if (CustomViewer.MIDDLE_RIGHT_OVERLAY_ICON_PATH.equals(overrideName)) {
                        return ImageProvider.getInstance().getMiddleRightOverlayIcon();
                    }
                    if (CustomViewer.BOTTOM_LEFT_OVERLAY_ICON_PATH.equals(overrideName)) {
                        return ImageProvider.getInstance().getBottomLeftOverlayIcon();
                    }
                    if (CustomViewer.BOTTOM_MIDDLE_OVERLAY_ICON_PATH.equals(overrideName)) {
                        return ImageProvider.getInstance().getBottomMiddleOverlayIcon();
                    }
                    if (CustomViewer.BOTTOM_RIGHT_OVERLAY_ICON_PATH.equals(overrideName)) {
                        return ImageProvider.getInstance().getBottomRightOverlayIcon();
                    }
                    if (CustomViewer.CUSTOMIZATION_LABEL.equals(overrideName)) {
                        return ImageProvider.getInstance().getCustomizationLabelIcon();
                    }
                    if (CustomViewer.CUSTOMIZATION_IMAGE.equals(overrideName)) {
                        return ImageProvider.getInstance().getCustomizationImageIcon();
                    }
                    if (CustomViewer.CUSTOMIZATION_FOREGROUND.equals(overrideName)) {
                        return ImageProvider.getInstance().getCustomizationColorIcon();
                    }
                    if (CustomViewer.CUSTOMIZATION_BACKGROUND.equals(overrideName)) {
                        return ImageProvider.getInstance().getCustomizationColorIcon();
                    }
                    if (CustomViewer.FONT_NAME.equals(overrideName)) {
                        return ImageProvider.getInstance().getFontNameIcon();
                    }
                    if (CustomViewer.FONT_SIZE.equals(overrideName)) {
                        return ImageProvider.getInstance().getFontSizeIcon();
                    }
                    if (CustomViewer.FONT_BOLD.equals(overrideName)) {
                        return ImageProvider.getInstance().getIsBoldIcon();
                    }
                    if (CustomViewer.FONT_ITALIC.equals(overrideName)) {
                        return ImageProvider.getInstance().getIsItalicIcon();
                    }
                    if (CustomViewer.FONT_UNDERLINE.equals(overrideName)) {
                        return ImageProvider.getInstance().getIsUnderlinedIcon();
                    }
                    if (CustomViewer.FONT_STRUKETHROUGH.equals(overrideName)) {
                        return ImageProvider.getInstance().getIsStrukethroughIcon();
                    }
                }
            }
            return super.getImage(element);
        }
    }

    protected class ValueLabelProvider
    extends ColumnLabelProvider {
        private final HashMap<String, Image> images = new HashMap();

        public String getText(Object element) {
            if (element instanceof DerivedTypedElement) {
                DerivedTypedElement derivedTypedElement = (DerivedTypedElement)element;
                Query query = derivedTypedElement.getQuery();
                if (query != null) {
                    if (query instanceof StringLiteralQuery) {
                        StringLiteralQuery stringQuery = (StringLiteralQuery)query;
                        return stringQuery.getValue();
                    }
                    if (query instanceof TrueLiteralQuery) {
                        return "true";
                    }
                    if (query instanceof FalseLiteralQuery) {
                        return "false";
                    }
                    if (query instanceof NullLiteralQuery) {
                        return "null";
                    }
                    if (query instanceof OperationCallQuery) {
                        OperationCallQuery operationCallQuery = (OperationCallQuery)query;
                        return operationCallQuery.toString();
                    }
                    if (query instanceof JavaQuery) {
                        JavaQuery javaQuery = (JavaQuery)query;
                        String qualifiedName = javaQuery.getImplementationClassName();
                        String[] path = qualifiedName.split("\\.");
                        return path[path.length - 1];
                    }
                    if (query instanceof OclQuery) {
                        OclQuery oclQuery = (OclQuery)query;
                        return oclQuery.getOclExpression();
                    }
                    if (query instanceof NavigationQuery) {
                        NavigationQuery navigationQuery = (NavigationQuery)query;
                        return navigationQuery.getPath().toString();
                    }
                    if (query instanceof IsOneOfQuery) {
                        IsOneOfQuery isOneOfQuery = (IsOneOfQuery)query;
                        return isOneOfQuery.getExpectedEObjects().toString();
                    }
                    if (query instanceof IntegerLiteralQuery) {
                        IntegerLiteralQuery integerQuery = (IntegerLiteralQuery)query;
                        return String.valueOf(integerQuery.getValue());
                    }
                    if (query instanceof FloatLiteralQuery) {
                        FloatLiteralQuery floatQuery = (FloatLiteralQuery)query;
                        return String.valueOf(floatQuery.getValue());
                    }
                    if (query instanceof EObjectLiteralQuery) {
                        EObjectLiteralQuery eObjectQuery = (EObjectLiteralQuery)query;
                        return eObjectQuery.getElement().eClass().getName();
                    }
                    if (query instanceof ETypedElementSwitchQuery) {
                        ETypedElementSwitchQuery switchQuery = (ETypedElementSwitchQuery)query;
                        EList list = switchQuery.getCases();
                        ArrayList<String> listResult = new ArrayList<String>();
                        for (ETypedElementCase object : list) {
                            if (object.getCase() == null) continue;
                            listResult.add(object.getCase().getName());
                        }
                        return ((Object)listResult).toString();
                    }
                }
            } else if (element instanceof EParameter) {
                EParameter parameterValue = (EParameter)element;
                return "";
            }
            return "N/A";
        }

        public Image getImage(Object element) {
            return null;
        }

        public void dispose() {
            for (Image image : this.images.values()) {
                image.dispose();
            }
            super.dispose();
        }

        public void update(ViewerCell cell) {
            DerivedTypedElement derivedTypedElement;
            Query query;
            Object element = cell.getElement();
            boolean gray = false;
            if (element instanceof FacetOperation) {
                FacetOperation facetOperation = (FacetOperation)element;
            }
            boolean unresolved = false;
            if (element instanceof DerivedTypedElement && ((query = (derivedTypedElement = (DerivedTypedElement)element).getQuery()) == null || !EMFUtil.tryResolve((EObject)query))) {
                unresolved = true;
            }
            if (unresolved) {
                String text = this.getText(element);
                cell.setText(text);
                cell.setImage(ImageProvider.getInstance().getErrorIcon());
                super.update(cell);
            } else {
                cell.setImage(this.getImage(element));
                super.update(cell);
            }
        }
    }
}

