/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.UMLPackage;

public class TemplateableElementEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        boolean result = true;
        if (request instanceof CreateElementRequest) {
            result = this.approveCreateRequest((CreateElementRequest)request);
        } else if (request instanceof MoveRequest) {
            result = this.approveMoveRequest((MoveRequest)request);
        } else if (request instanceof SetRequest) {
            result = this.approveSetRequest((SetRequest)request);
        }
        return result && this.basicApproveRequest(request);
    }

    protected final boolean basicApproveRequest(IEditCommandRequest request) {
        return super.approveRequest(request);
    }

    protected boolean approveCreateRequest(CreateElementRequest request) {
        boolean result = true;
        if (request.getElementType().getEClass() == UMLPackage.Literals.REDEFINABLE_TEMPLATE_SIGNATURE) {
            EObject container = request.getContainer();
            result = container == null || UMLPackage.Literals.CLASSIFIER.isInstance((Object)container);
        }
        return result;
    }

    protected boolean approveMoveRequest(MoveRequest request) {
        boolean result = true;
        if (!(request.getTargetContainer() instanceof Classifier)) {
            for (EObject next : Iterables.filter(request.getElementsToMove().keySet(), EObject.class)) {
                if (!UMLPackage.Literals.REDEFINABLE_TEMPLATE_SIGNATURE.isInstance((Object)next)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    protected boolean approveSetRequest(SetRequest request) {
        boolean result = true;
        if (!(request.getElementToEdit() instanceof Classifier) && request.getFeature() == UMLPackage.Literals.TEMPLATEABLE_ELEMENT__OWNED_TEMPLATE_SIGNATURE) {
            result = request.getValue() == null || !UMLPackage.Literals.REDEFINABLE_TEMPLATE_SIGNATURE.isInstance(request.getValue());
        }
        return result;
    }
}

