/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.handlers;

import java.util.Arrays;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.handlers.AbstractHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnDragHandler;
import org.eclipse.gef.mvc.fx.handlers.SnapToSupport;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.models.SnappingModel;
import org.eclipse.gef.mvc.fx.parts.AbstractSegmentHandlePart;
import org.eclipse.gef.mvc.fx.parts.AbstractVisualPart;
import org.eclipse.gef.mvc.fx.parts.ITransformableContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.ResizePolicy;
import org.eclipse.gef.mvc.fx.policies.TransformPolicy;

public class ResizeTranslateFirstAnchorageOnHandleDragHandler
extends AbstractHandler
implements IOnDragHandler {
    private SnapToSupport snapToSupport;
    private boolean invalidGesture = false;
    private Point initialPointerLocation;
    private int translationIndex;
    private IVisualPart<? extends Node> targetPart;
    private Point initialVertex;

    @Override
    public void abortDrag() {
        if (this.invalidGesture) {
            return;
        }
        if (this.snapToSupport != null) {
            this.snapToSupport.stopSnapping();
        }
        this.restoreRefreshVisuals(this.getTargetPart());
        this.commit(this.getResizePolicy());
        this.commit(this.getTransformPolicy());
    }

    protected IVisualPart<? extends Node> determineTargetPart() {
        return (IVisualPart)((AbstractVisualPart)this.getHost()).getAnchoragesUnmodifiable().keySet().iterator().next();
    }

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        Point newVertex;
        if (this.invalidGesture) {
            return;
        }
        Object visual = this.getTargetPart().getVisual();
        Point newEndScene = new Point(e.getSceneX(), e.getSceneY());
        Point deltaInScene = new Point(newEndScene.x - this.initialPointerLocation.x, newEndScene.y - this.initialPointerLocation.y);
        Point snappedVertex = newVertex = this.initialVertex.getTranslated(deltaInScene);
        if (this.snapToSupport != null) {
            if (!this.isPrecise(e)) {
                snappedVertex.translate(this.snapToSupport.snap(new Dimension(deltaInScene.x, deltaInScene.y)));
            } else {
                this.snapToSupport.clearSnappingFeedback();
            }
        }
        Point2D startLocal = visual.sceneToLocal(this.initialVertex.x, this.initialVertex.y);
        Point2D endLocal = visual.sceneToLocal(snappedVertex.x, snappedVertex.y);
        double deltaX = endLocal.getX() - startLocal.getX();
        double deltaY = endLocal.getY() - startLocal.getY();
        int segment = ((AbstractSegmentHandlePart)this.getHost()).getSegmentIndex();
        double ldw = segment == 1 || segment == 2 ? deltaX : -deltaX;
        double ldh = segment == 2 || segment == 3 ? deltaY : -deltaY;
        this.getResizePolicy().resize(ldw, ldh);
        Dimension applicableDelta = new Dimension(this.getResizePolicy().getDeltaWidth(), this.getResizePolicy().getDeltaHeight());
        if (applicableDelta.width != ldw) {
            deltaX = applicableDelta.width;
            if (segment == 0 || segment == 3) {
                deltaX = -deltaX;
            }
        }
        if (applicableDelta.height != ldh) {
            deltaY = applicableDelta.height;
            if (segment == 0 || segment == 1) {
                deltaY = -deltaY;
            }
        }
        double ldx = segment == 0 || segment == 3 ? deltaX : 0.0;
        double ldy = segment == 0 || segment == 1 ? deltaY : 0.0;
        this.getTransformPolicy().setPreTranslate(this.translationIndex, ldx, ldy);
    }

    @Override
    public void endDrag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            this.invalidGesture = false;
            return;
        }
        if (this.snapToSupport != null) {
            this.snapToSupport.stopSnapping();
        }
        this.restoreRefreshVisuals(this.getTargetPart());
        this.commit(this.getResizePolicy());
        this.commit(this.getTransformPolicy());
    }

    public AbstractSegmentHandlePart<? extends Node> getHost() {
        return (AbstractSegmentHandlePart)super.getHost();
    }

    protected ResizePolicy getResizePolicy() {
        return (ResizePolicy)this.getTargetPart().getAdapter(ResizePolicy.class);
    }

    protected ITransformableContentPart<? extends Node> getTargetPart() {
        return (ITransformableContentPart)this.targetPart;
    }

    protected TransformPolicy getTransformPolicy() {
        return (TransformPolicy)this.getTargetPart().getAdapter(TransformPolicy.class);
    }

    @Override
    public void hideIndicationCursor() {
    }

    private boolean isMultiSelection() {
        return ((SelectionModel)((Object)this.getTargetPart().getRoot().getViewer().getAdapter(SelectionModel.class))).getSelectionUnmodifiable().size() > 1;
    }

    protected boolean isPrecise(MouseEvent e) {
        return e.isShortcutDown();
    }

    protected boolean isResizeTranslate(MouseEvent event) {
        return !event.isControlDown() && !this.isMultiSelection();
    }

    protected void setTargetPart(IVisualPart<? extends Node> determinedTargetPart) {
        this.targetPart = determinedTargetPart;
    }

    @Override
    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    @Override
    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }

    @Override
    public void startDrag(MouseEvent e) {
        this.setTargetPart(this.determineTargetPart());
        boolean bl = this.invalidGesture = !this.isResizeTranslate(e);
        if (this.invalidGesture) {
            return;
        }
        ITransformableContentPart<? extends Node> targetPart = this.getTargetPart();
        this.storeAndDisableRefreshVisuals(targetPart);
        this.initialPointerLocation = new Point(e.getSceneX(), e.getSceneY());
        this.init(this.getResizePolicy());
        this.init(this.getTransformPolicy());
        this.translationIndex = this.getTransformPolicy().createPreTransform();
        Bounds layoutBounds = targetPart.getVisual().getLayoutBounds();
        Bounds initialBoundsInScene = targetPart.getVisual().localToScene(layoutBounds);
        int segment = ((AbstractSegmentHandlePart)this.getHost()).getSegmentIndex();
        if (segment == 0) {
            this.initialVertex = new Point(initialBoundsInScene.getMinX(), initialBoundsInScene.getMinY());
        } else if (segment == 1) {
            this.initialVertex = new Point(initialBoundsInScene.getMaxX(), initialBoundsInScene.getMinY());
        } else if (segment == 2) {
            this.initialVertex = new Point(initialBoundsInScene.getMaxX(), initialBoundsInScene.getMaxY());
        } else if (segment == 3) {
            this.initialVertex = new Point(initialBoundsInScene.getMinX(), initialBoundsInScene.getMaxY());
        }
        this.snapToSupport = (SnapToSupport)((Object)targetPart.getViewer().getAdapter(SnapToSupport.class));
        if (this.snapToSupport != null) {
            SnappingModel.SnappingLocation hssl = new SnappingModel.SnappingLocation(targetPart, Orientation.HORIZONTAL, this.initialVertex.x);
            SnappingModel.SnappingLocation vssl = new SnappingModel.SnappingLocation(targetPart, Orientation.VERTICAL, this.initialVertex.y);
            this.snapToSupport.startSnapping(targetPart, Arrays.asList(hssl, vssl));
        }
    }
}

