/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.serializer.impl;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccessDiff;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionDiffBuilder;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringBasedTextRegionAccessDiffBuilder;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ide.serializer.IEmfResourceChange;
import org.eclipse.xtext.ide.serializer.hooks.IReferenceUpdater;
import org.eclipse.xtext.ide.serializer.hooks.IResourceSnapshot;
import org.eclipse.xtext.ide.serializer.hooks.IUpdatableReference;
import org.eclipse.xtext.ide.serializer.impl.ChangeTreeProvider;
import org.eclipse.xtext.ide.serializer.impl.EObjectDescriptionDeltaProvider;
import org.eclipse.xtext.ide.serializer.impl.EObjectSnapshotProvider;
import org.eclipse.xtext.ide.serializer.impl.PartialSerializer;
import org.eclipse.xtext.ide.serializer.impl.RecordingResourceUpdater;
import org.eclipse.xtext.ide.serializer.impl.ReferenceUpdaterContext;
import org.eclipse.xtext.ide.serializer.impl.RegionDiffFormatter;
import org.eclipse.xtext.ide.serializer.impl.TextDocumentChange;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.IAcceptor;

public class RecordingXtextResourceUpdater
extends RecordingResourceUpdater {
    @Inject
    private ChangeTreeProvider changeTreeProvider;
    private ITextRegionDiffBuilder document;
    @Inject
    private RegionDiffFormatter formatter;
    @Inject
    private PartialSerializer partialSerializer;
    private ChangeRecorder recorder;
    @Inject
    private IReferenceUpdater referenceUpdater;
    private IChangeSerializer serializer;
    private IResourceSnapshot snapshot;
    @Inject
    private EObjectSnapshotProvider snapshotProvider;

    @Override
    public void applyChange(EObjectDescriptionDeltaProvider.Deltas deltas, IAcceptor<IEmfResourceChange> changeAcceptor) {
        ChangeDescription recording;
        Resource resource = this.snapshot.getResource();
        ResourceSet rs = resource.getResourceSet();
        ReferenceUpdaterContext ctx = new ReferenceUpdaterContext(deltas, this.document);
        if (this.serializer.isUpdateCrossReferences()) {
            this.referenceUpdater.update(ctx);
            for (Runnable run : ctx.getModifications()) {
                run.run();
            }
        }
        if ((recording = this.recorder.endRecording()) != null) {
            List<IResourceSnapshot> snapshots = Collections.singletonList(this.snapshot);
            ChangeTreeProvider.ResourceSetRecording tree = this.changeTreeProvider.createChangeTree(rs, snapshots, recording);
            ChangeTreeProvider.ResourceRecording recordedResource = tree.getRecordedResource(resource);
            this.partialSerializer.serializeChanges(recordedResource, this.document);
        }
        this.recorder.dispose();
        List<IUpdatableReference> updatableReferences = ctx.getUpdatableReferences();
        for (IUpdatableReference upd : updatableReferences) {
            this.referenceUpdater.updateReference(this.document, upd);
        }
        ITextRegionAccessDiff rewritten = this.document.create();
        List<ITextReplacement> rep = this.formatter.format((ITextRegionAccess)rewritten);
        URI oldUri = this.snapshot.getURI();
        TextDocumentChange change = new TextDocumentChange(rewritten, oldUri, rep);
        changeAcceptor.accept((Object)change);
    }

    public ITextRegionDiffBuilder beginRecording(IChangeSerializer serializer, XtextResource resource) {
        this.serializer = serializer;
        this.snapshot = this.snapshotProvider.createResourceSnapshot((Resource)resource, serializer.isUpdateCrossReferences());
        this.document = new StringBasedTextRegionAccessDiffBuilder(this.snapshot.getRegions());
        EcoreUtil.resolveAll((Resource)resource);
        this.recorder = this.createChangeRecorder(resource);
        return this.document;
    }

    protected ChangeRecorder createChangeRecorder(XtextResource resource) {
        return new ChangeRecorder((EObject)resource.getContents().get(0));
    }

    public ITextRegionDiffBuilder getDocument() {
        return this.document;
    }

    @Override
    public Resource getResource() {
        return this.snapshot.getResource();
    }

    @Override
    public IResourceSnapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public void unload() {
    }

    public String toString() {
        URI newURI;
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName());
        URI oldURI = this.getSnapshot().getURI();
        if (oldURI.equals(newURI = this.getResource().getURI())) {
            result.append(" " + String.valueOf(oldURI));
        } else {
            result.append(" " + String.valueOf(oldURI) + " -> " + String.valueOf(newURI));
        }
        if (this.document != null) {
            result.append("\n" + String.valueOf(this.document));
        }
        return result.toString();
    }
}

