/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.uml.diagram.menu.actions.AbstractGraphicalParametricAction;

public class ReduceGrowAction
extends AbstractGraphicalParametricAction {
    public static final int DEFAULT_SPEED = 2;

    public ReduceGrowAction(String parameter, List<IGraphicalEditPart> selection) {
        super(parameter, selection);
    }

    @Override
    protected Command getBuildedCommand() {
        CompoundCommand command = new CompoundCommand("Reduce/Grow Command");
        ChangeBoundsRequest request = this.createRequest();
        for (EditPart editPart : this.getSelection()) {
            Command cmd = editPart.getCommand((Request)request);
            if (cmd == null || !cmd.canExecute()) continue;
            command.add(cmd);
        }
        return command.isEmpty() ? null : command;
    }

    protected ChangeBoundsRequest createRequest() {
        ChangeBoundsRequest request = new ChangeBoundsRequest();
        request.setType((Object)"resize");
        switch (this.getParameter()) {
            case "parameter_left": {
                request.setSizeDelta(new Dimension(-4, 0));
                request.setMoveDelta(new Point(2, 0));
                break;
            }
            case "parameter_right": {
                request.setSizeDelta(new Dimension(4, 0));
                request.setMoveDelta(new Point(-2, 0));
                break;
            }
            case "parameter_top": {
                request.setSizeDelta(new Dimension(0, 4));
                request.setMoveDelta(new Point(0, -2));
                break;
            }
            case "parameter_bottom": {
                request.setSizeDelta(new Dimension(0, -4));
                request.setMoveDelta(new Point(0, 2));
                break;
            }
        }
        return request;
    }

    @Override
    public boolean isEnabled() {
        if ("parameter_left".equals(this.getParameter()) || "parameter_right".equals(this.getParameter()) || "parameter_top".equals(this.getParameter()) || "parameter_bottom".equals(this.getParameter())) {
            return true;
        }
        return super.isEnabled();
    }
}

