/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.infra.core.sashwindows.di.util.DiUtils;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlCommand;
import org.eclipse.papyrus.infra.services.controlmode.messages.Messages;

public class CleanSashCommand
extends AbstractControlCommand {
    static final String SASH_CLEAN_COMMAND_LABEL = Messages.getString("CleanSashCommand.command.title");
    static final String MODEL_SET_ERROR_MESSAGE = Messages.getString("CleanSashCommand.resourceset.error");
    static final String OLD_DI_MESSAGE_ERROR = Messages.getString("CleanSashCommand.old.resource.error");

    public CleanSashCommand(List affectedFiles, ControlModeRequest request) {
        super(SASH_CLEAN_COMMAND_LABEL, affectedFiles, request);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ModelSet modelSet = this.getRequest().getModelSet();
        if (modelSet == null) {
            return CommandResult.newErrorCommandResult((String)MODEL_SET_ERROR_MESSAGE);
        }
        Resource oldDiresource = modelSet.getAssociatedResource(this.getRequest().getTargetObject(), "di", true);
        if (oldDiresource == null) {
            return CommandResult.newErrorCommandResult((String)OLD_DI_MESSAGE_ERROR);
        }
        if (DiUtils.lookupSashWindowsMngr((Resource)oldDiresource) != null) {
            oldDiresource.getContents().clear();
        } else {
            SashModel sashModel = SashModelUtils.getSashModel((ModelSet)modelSet);
            sashModel.getResource().setModified(true);
            sashModel.loadModel(oldDiresource.getURI().trimFileExtension());
            SashModelUtils.getSashModel((ModelSet)modelSet).getResource().getContents().clear();
        }
        return CommandResult.newOKCommandResult();
    }
}

