/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.preferences.fields;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public abstract class AbstractDetailsPart
extends FieldEditorPreferencePage {
    protected IPreferenceStore masterPreferenceStore;
    protected PreferenceStore internalStore;
    private List<FieldEditor> internalEditorsList = new ArrayList<FieldEditor>();
    private String preferencePrefix;

    public AbstractDetailsPart(IPreferenceStore masterPreferenceStore) {
        super(1);
        this.masterPreferenceStore = masterPreferenceStore;
        this.internalStore = new PreferenceStore();
    }

    protected final void addField(FieldEditor editor) {
        Object prefix = null;
        prefix = this.getPreferencePrefix() != null ? this.getPreferencePrefix() + "." + editor.getPreferenceName() : editor.getPreferenceName();
        editor.setPreferenceName((String)prefix);
        this.internalEditorsList.add(editor);
        super.addField(editor);
    }

    protected final IPreferenceStore doGetPreferenceStore() {
        return new ChainedPreferenceStore(new IPreferenceStore[]{this.internalStore, this.masterPreferenceStore});
    }

    protected final void load(String preferencePrefix) {
        this.setPreferencePrefix(preferencePrefix);
        this.initialize();
    }

    protected final void loadDefaults(String preferencePrefix) {
        this.setPreferencePrefix(preferencePrefix);
        this.performDefaults();
        for (FieldEditor fe : this.internalEditorsList) {
            if (!fe.presentsDefaultValue()) continue;
            this.internalStore.setValue(fe.getPreferenceName(), this.masterPreferenceStore.getDefaultString(fe.getPreferenceName()));
        }
    }

    public final boolean performOk() {
        int changed = 0;
        String[] stringArray = this.internalStore.preferenceNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String defaultValue;
            String prefKey = stringArray[n2];
            String value = this.internalStore.getString(prefKey);
            if (!value.equals(defaultValue = this.masterPreferenceStore.getDefaultString(prefKey))) {
                this.masterPreferenceStore.putValue(prefKey, value);
                ++changed;
            } else {
                this.masterPreferenceStore.setToDefault(prefKey);
                ++changed;
            }
            ++n2;
        }
        if (changed > 0) {
            this.masterPreferenceStore.firePropertyChangeEvent(this.getPreferencePrefix(), null, null);
        }
        this.resetPreferenceStore();
        return true;
    }

    private void resetPreferenceStore() {
        this.internalStore = new PreferenceStore();
        this.setPreferenceStore(null);
    }

    public final void createControl(Composite parent) {
        this.noDefaultAndApplyButton();
        super.createControl(parent);
    }

    public final void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof FieldEditor) {
            FieldEditor fe = (FieldEditor)event.getSource();
            this.internalStore.setValue(fe.getPreferenceName(), fe.getPreferenceStore().getDefaultString(fe.getPreferenceName()));
            fe.setPreferenceStore((IPreferenceStore)this.internalStore);
            fe.store();
            fe.setPreferenceStore(this.getPreferenceStore());
        }
        super.propertyChange(event);
    }

    protected abstract void createFieldEditors();

    protected final String getPreferencePrefix() {
        return this.preferencePrefix;
    }

    private void setPreferencePrefix(String preferencePrefix) {
        this.preferencePrefix = preferencePrefix;
        for (FieldEditor fe : this.internalEditorsList) {
            String oldPreferenceName = fe.getPreferenceName();
            if (oldPreferenceName.indexOf(46) >= 0) {
                oldPreferenceName = oldPreferenceName.substring(oldPreferenceName.lastIndexOf(46) + 1);
            }
            fe.setPreferenceName(this.getPreferencePrefix() + "." + oldPreferenceName);
        }
    }
}

