/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.columnChooser.gui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractColumnChooserDialog
extends Dialog {
    private IDialogSettings dialogSettings;

    public AbstractColumnChooserDialog(Shell parent) {
        super(parent);
        this.setShellStyle(67696);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.getString("AbstractColumnChooserDialog.doneButton"), true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.getShell().setText(Messages.getString("AbstractColumnChooserDialog.shellTitle"));
        composite.getShell().setImage(GUIHelper.getImage("preferences"));
        this.populateDialogArea(composite);
        Label separator = new Label(composite, 258);
        GridDataFactory.fillDefaults().grab(true, false).span(((GridLayout)composite.getLayout()).numColumns, 1).applyTo((Control)separator);
        return composite;
    }

    protected abstract void populateDialogArea(Composite var1);

    protected void createLabels(Composite parent, String availableStr, String selectedStr) {
        boolean selectedSet;
        boolean availableSet = availableStr != null && availableStr.length() > 0;
        boolean bl = selectedSet = selectedStr != null && selectedStr.length() > 0;
        if (availableSet && selectedSet) {
            if (availableSet) {
                Label availableLabel = new Label(parent, 0);
                availableLabel.setText(availableStr);
                GridDataFactory.swtDefaults().applyTo((Control)availableLabel);
            }
            Label filler = new Label(parent, 0);
            GridDataFactory.swtDefaults().applyTo((Control)filler);
            if (selectedSet) {
                Label selectedLabel = new Label(parent, 0);
                selectedLabel.setText(selectedStr);
                GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)selectedLabel);
            }
        }
    }

    protected Point getInitialSize() {
        int minWidth = GUIHelper.convertHorizontalPixelToDpi(500, true);
        int minHeight = GUIHelper.convertVerticalPixelToDpi(350, true);
        if (this.dialogSettings == null) {
            return new Point(minWidth, minHeight);
        }
        Point initialSize = super.getInitialSize();
        return initialSize.x < minWidth && initialSize.y < minHeight ? new Point(minWidth, minHeight) : initialSize;
    }

    public void setDialogSettings(IDialogSettings dialogSettings) {
        this.dialogSettings = dialogSettings;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.dialogSettings;
    }
}

