/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.iproduct.ILauncherInfo;
import org.eclipse.pde.internal.core.iproduct.IMacBundleUrlType;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.editor.EditorUtilities;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.validation.TextValidator;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.parts.TablePart;
import org.eclipse.pde.internal.ui.util.FileExtensionFilter;
import org.eclipse.pde.internal.ui.util.FileValidator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LauncherSection
extends PDESection {
    private TextValidator[] fMultipleWinIconValidator;
    private TextValidator fSingleWinIconValidator;
    private static final String[] F_WIN_ICON_LABELS = new String[]{PDEUIMessages.LauncherSection_Low16, PDEUIMessages.LauncherSection_High16, PDEUIMessages.LauncherSection_32Low, PDEUIMessages.LauncherSection_32High, PDEUIMessages.LauncherSection_48Low, PDEUIMessages.LauncherSection_48High, PDEUIMessages.LauncherSection_256High};
    public static final int[] F_WIN_ICON_DEPTHS = new int[]{8, 32, 8, 32, 8, 32, 32};
    public static final int[][] F_WIN_ICON_DIMENSIONS = new int[][]{{16, 16}, {16, 16}, {32, 32}, {32, 32}, {48, 48}, {48, 48}, {256, 256}};
    private static final String[] F_WIN_ICON_IDS = new String[]{"winSmallLow", "winSmallHigh", "winMediumLow", "winMediumHigh", "winLargeLow", "winLargeHigh", "winExtraLargeHigh"};
    private FormEntry fNameEntry;
    private final ArrayList<IconEntry> fIcons = new ArrayList();
    private Button fIcoButton;
    private Button fBmpButton;
    private CTabFolder fTabFolder;
    private Composite fNotebook;
    private StackLayout fNotebookLayout;
    private Composite fLinuxSection;
    private Composite fMacSection;
    private Composite fWin32Section;
    private MacBundleUrlTypesComposite fMacBundleUrlTypesComposite;

    public LauncherSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(770);
        section.setLayoutData((Object)data);
        section.setText(PDEUIMessages.LauncherSection_title);
        section.setDescription(PDEUIMessages.LauncherSection_desc);
        Composite container = toolkit.createComposite((Composite)section);
        GridLayout layout = FormLayoutFactory.createSectionClientGridLayout(false, 2);
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(768));
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        this.fNameEntry = new FormEntry(container, toolkit, PDEUIMessages.LauncherSection_launcherName, null, false);
        this.fNameEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                LauncherSection.this.getLauncherInfo().setLauncherName(entry.getValue());
            }
        });
        this.fNameEntry.setEditable(this.isEditable());
        this.createLabel(container, toolkit, PDEUIMessages.LauncherSection_label, 2);
        this.fTabFolder = new CTabFolder(container, 0x800080);
        toolkit.adapt((Control)this.fTabFolder, true, true);
        GridData gd = new GridData(256);
        gd.heightHint = 2;
        gd.horizontalSpan = 2;
        this.fTabFolder.setLayoutData((Object)gd);
        toolkit.getColors().initializeSectionToolBarColors();
        Color selectedColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        this.fTabFolder.setSelectionBackground(new Color[]{selectedColor, toolkit.getColors().getBackground()}, new int[]{100}, true);
        this.fTabFolder.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateTabSelection()));
        this.fTabFolder.setUnselectedImageVisible(false);
        this.fNotebook = toolkit.createComposite(container);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.fNotebook.setLayoutData((Object)gd);
        this.fNotebookLayout = new StackLayout();
        this.fNotebook.setLayout((Layout)this.fNotebookLayout);
        this.fLinuxSection = this.addLinuxSection(this.fNotebook, toolkit);
        this.fMacSection = this.addMacSection(this.fNotebook, toolkit);
        this.fWin32Section = this.addWin32Section(this.fNotebook, toolkit);
        this.createTabs();
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    private void createTabs() {
        this.addTab("linux");
        this.addTab("macosx");
        this.addTab("win32");
        String currentTarget = TargetPlatform.getOS();
        if (currentTarget == null) {
            currentTarget = "linux";
        }
        switch (currentTarget) {
            case "win32": {
                this.fTabFolder.setSelection(3);
                this.fNotebookLayout.topControl = this.fWin32Section;
                break;
            }
            case "macosx": {
                this.fTabFolder.setSelection(1);
                this.fNotebookLayout.topControl = this.fMacSection;
                break;
            }
            default: {
                this.fTabFolder.setSelection(0);
                this.fNotebookLayout.topControl = this.fLinuxSection;
            }
        }
    }

    private void addTab(String label) {
        CTabItem item = new CTabItem(this.fTabFolder, 0);
        item.setText(label);
        item.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_OPERATING_SYSTEM_OBJ));
    }

    private Composite addWin32Section(Composite parent, FormToolkit toolkit) {
        Composite comp = this.createComposite(parent, toolkit);
        this.fBmpButton = toolkit.createButton(comp, PDEUIMessages.LauncherSection_bmpImages, 16);
        TableWrapData td = new TableWrapData();
        td.colspan = 3;
        this.fBmpButton.setLayoutData((Object)td);
        this.fBmpButton.setEnabled(this.isEditable());
        this.fMultipleWinIconValidator = new TextValidator[F_WIN_ICON_LABELS.length];
        int i = 0;
        while (i < F_WIN_ICON_LABELS.length) {
            final IconEntry ientry = new IconEntry(comp, toolkit, F_WIN_ICON_LABELS[i], F_WIN_ICON_IDS[i]);
            BidiUtils.applyBidiProcessing((Text)ientry.getText(), (String)"file");
            final int index = i++;
            this.fMultipleWinIconValidator[index] = new TextValidator(this.getManagedForm(), ientry.getText(), this.getProject(), true){

                @Override
                protected boolean validateControl() {
                    return LauncherSection.this.validateMultipleWinIcon(ientry, index);
                }
            };
            this.fMultipleWinIconValidator[index].setEnabled(false);
            ientry.getText().addModifyListener(e -> {
                boolean bl = this.fMultipleWinIconValidator[index].validate();
            });
            this.fIcons.add(ientry);
        }
        this.fIcoButton = toolkit.createButton(comp, PDEUIMessages.LauncherSection_ico, 16);
        td = new TableWrapData();
        td.colspan = 3;
        this.fIcoButton.setLayoutData((Object)td);
        this.fIcoButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean selected = this.fIcoButton.getSelection();
            this.getLauncherInfo().setUseWinIcoFile(selected);
            this.updateWinEntries(selected);
        }));
        this.fIcoButton.setEnabled(this.isEditable());
        final IconEntry ientry = new IconEntry(comp, toolkit, PDEUIMessages.LauncherSection_file, "icoFile");
        this.fSingleWinIconValidator = new TextValidator(this.getManagedForm(), ientry.getText(), this.getProject(), true){

            @Override
            protected boolean validateControl() {
                return LauncherSection.this.validateSingleWinIcon(ientry);
            }
        };
        this.fSingleWinIconValidator.setEnabled(false);
        this.fIcons.add(ientry);
        toolkit.paintBordersFor(comp);
        return comp;
    }

    private boolean validateSingleWinIcon(IconEntry ientry) {
        return EditorUtilities.imageEntryHasValidIco(this.fSingleWinIconValidator, ientry, this.getProduct());
    }

    private boolean validateMultipleWinIcon(IconEntry ientry, int index) {
        return EditorUtilities.imageEntryHasExactDepthAndSize(this.fMultipleWinIconValidator[index], ientry, this.getProduct(), F_WIN_ICON_DIMENSIONS[index][0], F_WIN_ICON_DIMENSIONS[index][1], F_WIN_ICON_DEPTHS[index]);
    }

    private void createLabel(Composite parent, FormToolkit toolkit, String text, int span) {
        Label label = toolkit.createLabel(parent, text, 64);
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            GridData gd = new GridData();
            gd.horizontalSpan = span;
            label.setLayoutData((Object)gd);
        } else if (layout instanceof TableWrapLayout) {
            TableWrapData td = new TableWrapData();
            td.colspan = span;
            label.setLayoutData((Object)td);
        }
    }

    private Composite addLinuxSection(Composite parent, FormToolkit toolkit) {
        Composite comp = this.createComposite(parent, toolkit);
        this.createLabel(comp, toolkit, PDEUIMessages.LauncherSection_linuxLabel, 3);
        this.fIcons.add(new IconEntry(comp, toolkit, PDEUIMessages.LauncherSection_icon, "linuxIcon"));
        toolkit.paintBordersFor(comp);
        return comp;
    }

    private Composite addMacSection(Composite parent, FormToolkit toolkit) {
        Composite compOuter = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(compOuter);
        Composite comp = this.createComposite(compOuter, toolkit);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)comp);
        this.createLabel(comp, toolkit, PDEUIMessages.LauncherSection_macLabel, 3);
        this.fIcons.add(new IconEntry(comp, toolkit, PDEUIMessages.LauncherSection_file, "macosxIcon"));
        this.fMacBundleUrlTypesComposite = new MacBundleUrlTypesComposite(compOuter, toolkit);
        toolkit.paintBordersFor(comp);
        return compOuter;
    }

    private Composite createComposite(Composite parent, FormToolkit toolkit) {
        Composite comp = toolkit.createComposite(parent);
        TableWrapLayout layout = new TableWrapLayout();
        layout.rightMargin = 0;
        layout.leftMargin = 0;
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        layout.numColumns = 3;
        comp.setLayout((Layout)layout);
        return comp;
    }

    public void refresh() {
        ILauncherInfo info = this.getLauncherInfo();
        this.fNameEntry.setValue(info.getLauncherName(), true);
        boolean useIco = info.usesWinIcoFile();
        this.fIcoButton.setSelection(useIco);
        this.fBmpButton.setSelection(!useIco);
        this.fSingleWinIconValidator.setRefresh(false);
        int i = 0;
        while (i < this.fIcons.size()) {
            IconEntry entry = this.fIcons.get(i);
            entry.setValue(info.getIconPath(entry.getIconId()), true);
            ++i;
        }
        this.fSingleWinIconValidator.setRefresh(true);
        this.updateWinEntries(useIco);
        this.fMacBundleUrlTypesComposite.fBundleUrlTypesTable.setInput((Object)this.getProduct());
        this.fMacBundleUrlTypesComposite.fBundleUrlTypesTable.refresh();
        this.fMacBundleUrlTypesComposite.updateButtons();
        super.refresh();
    }

    private void updateWinEntries(boolean useIco) {
        int i = 0;
        while (i < this.fIcons.size()) {
            IconEntry entry = this.fIcons.get(i);
            String id = entry.getIconId();
            if (id.equals("icoFile")) {
                boolean enabled = this.isEditable() && useIco;
                entry.setEditable(enabled);
            } else if (id.equals("winSmallHigh") || id.equals("winSmallLow") || id.equals("winMediumHigh") || id.equals("winMediumLow") || id.equals("winLargeHigh") || id.equals("winLargeLow") || id.equals("winExtraLargeHigh")) {
                entry.setEditable(this.isEditable() && !useIco);
            }
            ++i;
        }
        this.updateWinEntryValidators(useIco);
    }

    private void updateWinEntryValidators(boolean useIco) {
        this.fSingleWinIconValidator.setRefresh(false);
        this.fSingleWinIconValidator.setEnabled(this.isEditable() && useIco);
        TextValidator[] textValidatorArray = this.fMultipleWinIconValidator;
        int n = this.fMultipleWinIconValidator.length;
        int n2 = 0;
        while (n2 < n) {
            TextValidator validator = textValidatorArray[n2];
            validator.setEnabled(this.isEditable() && !useIco);
            ++n2;
        }
        this.fSingleWinIconValidator.setRefresh(true);
    }

    private ILauncherInfo getLauncherInfo() {
        ILauncherInfo info = this.getProduct().getLauncherInfo();
        if (info == null) {
            info = this.getModel().getFactory().createLauncherInfo();
            this.getProduct().setLauncherInfo(info);
        }
        return info;
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    public void commit(boolean onSave) {
        this.fNameEntry.commit();
        int i = 0;
        while (i < this.fIcons.size()) {
            this.fIcons.get(i).commit();
            ++i;
        }
        super.commit(onSave);
    }

    @Override
    public void cancelEdit() {
        this.fNameEntry.cancelEdit();
        int i = 0;
        while (i < this.fIcons.size()) {
            this.fIcons.get(i).commit();
            ++i;
        }
        super.cancelEdit();
    }

    private void handleBrowse(IconEntry entry) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getSection().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)new FileValidator());
        dialog.setAllowMultiple(false);
        dialog.setTitle(PDEUIMessages.LauncherSection_dialogTitle);
        String extension = this.getExtension(entry.getIconId());
        dialog.setMessage(PDEUIMessages.LauncherSection_dialogMessage);
        dialog.addFilter((ViewerFilter)new FileExtensionFilter(extension));
        dialog.setInput((Object)PDEPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            entry.setValue(file.getFullPath().toString());
        }
    }

    private void openImage(String value) {
        IWorkspaceRoot root = PDEPlugin.getWorkspace().getRoot();
        IPath path = IPath.fromOSString((String)value);
        if (path.isEmpty()) {
            MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.WindowImagesSection_open, (String)PDEUIMessages.WindowImagesSection_emptyPath);
            return;
        }
        IResource resource = root.findMember(IPath.fromOSString((String)value));
        try {
            if (resource != null && resource instanceof IFile) {
                IDE.openEditor((IWorkbenchPage)PDEPlugin.getActivePage(), (IFile)((IFile)resource), (boolean)true);
            } else {
                MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.WindowImagesSection_open, (String)PDEUIMessages.WindowImagesSection_warning);
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    private String getExtension(String iconId) {
        if (iconId.equals("linuxIcon")) {
            return "xpm";
        }
        if (iconId.equals("macosxIcon")) {
            return "icns";
        }
        if (iconId.equals("icoFile")) {
            return "ico";
        }
        return "bmp";
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        return d.getFocusControl() instanceof Text;
    }

    private void updateTabSelection() {
        int index = this.fTabFolder.getSelectionIndex();
        Control oldPage = this.fNotebookLayout.topControl;
        switch (index) {
            case 0: {
                this.fNotebookLayout.topControl = this.fLinuxSection;
                break;
            }
            case 1: {
                this.fNotebookLayout.topControl = this.fMacSection;
                break;
            }
            case 2: {
                this.fNotebookLayout.topControl = this.fWin32Section;
            }
        }
        if (oldPage != this.fNotebookLayout.topControl) {
            this.fNotebook.layout();
        }
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
        this.getPage().setLastFocusControl((Control)this.fNameEntry.getText());
    }

    class IconEntry
    extends FormEntry {
        String fIconId;

        public IconEntry(Composite parent, FormToolkit toolkit, String labelText, String iconId) {
            super(parent, toolkit, labelText, PDEUIMessages.LauncherSection_browse, LauncherSection.this.isEditable(), 20);
            this.fIconId = iconId;
            this.addEntryFormListener();
            this.setEditable(LauncherSection.this.isEditable());
        }

        private void addEntryFormListener() {
            IActionBars actionBars = LauncherSection.this.getPage().getPDEEditor().getEditorSite().getActionBars();
            this.setFormEntryListener(new FormEntryAdapter(LauncherSection.this, actionBars){

                @Override
                public void textValueChanged(FormEntry entry) {
                    LauncherSection.this.getLauncherInfo().setIconPath(IconEntry.this.fIconId, entry.getValue());
                }

                @Override
                public void browseButtonSelected(FormEntry entry) {
                    LauncherSection.this.handleBrowse((IconEntry)entry);
                }

                @Override
                public void linkActivated(HyperlinkEvent e) {
                    LauncherSection.this.openImage(IconEntry.this.getValue());
                }
            });
        }

        public String getIconId() {
            return this.fIconId;
        }
    }

    private class MacBundleUrlTypesComposite {
        private MacBundleUrlTypesPartAdapter fTablePart;
        private TableViewer fBundleUrlTypesTable;

        public MacBundleUrlTypesComposite(Composite comp, FormToolkit toolkit) {
            LauncherSection.this.createLabel(comp, toolkit, PDEUIMessages.LauncherSection_macBundleUrlTypes_LauncherSection_macBundleUrlTypesTitle, 2);
            this.fTablePart = new MacBundleUrlTypesPartAdapter(new String[]{PDEUIMessages.LauncherSection_macBundleUrlTypes_Add, PDEUIMessages.LauncherSection_macBundleUrlTypes_Edit, PDEUIMessages.LauncherSection_macBundleUrlTypes_Remove});
            this.fTablePart.createControl(comp, 65536, 1, toolkit);
            this.fBundleUrlTypesTable = (TableViewer)this.fTablePart.getViewer();
            this.fBundleUrlTypesTable.setComparator(new ViewerComparator());
            this.fBundleUrlTypesTable.addDoubleClickListener(event -> this.handleEdit());
            this.fBundleUrlTypesTable.getTable().addKeyListener(KeyListener.keyReleasedAdapter(e -> {
                if (e.keyCode == 127) {
                    this.handleRemove();
                }
            }));
            Table table = this.fBundleUrlTypesTable.getTable();
            TableColumn schemeColumn = new TableColumn(table, 16384);
            schemeColumn.setText(PDEUIMessages.LauncherSection_macBundleUrlTypes_SchemeColumn);
            schemeColumn.setWidth(160);
            TableColumn nameColumn = new TableColumn(table, 16384);
            nameColumn.setText(PDEUIMessages.LauncherSection_macBundleUrlTypes_NameColumn);
            nameColumn.setWidth(220);
            table.addControlListener(ControlListener.controlResizedAdapter(e -> {
                int size = table.getSize().x;
                schemeColumn.setWidth(size / 10 * 4);
                nameColumn.setWidth(size / 10 * 6);
            }));
            table.setHeaderVisible(true);
            this.fBundleUrlTypesTable.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.fBundleUrlTypesTable.setContentProvider((IContentProvider)((IStructuredContentProvider)inputElement -> {
                IProduct product;
                ILauncherInfo launcherInfo;
                if (inputElement instanceof IProduct && (launcherInfo = (product = (IProduct)inputElement).getLauncherInfo()) != null) {
                    return launcherInfo.getMacBundleUrlTypes().toArray();
                }
                return new Object[0];
            }));
            this.fBundleUrlTypesTable.setInput((Object)LauncherSection.this.getProduct());
            this.updateButtons();
        }

        private void handleAdd() {
            this.openBundleURLTypeDialog(null, this.getExistingBundleUrlTypes());
        }

        private void handleEdit() {
            Object object;
            IStructuredSelection ssel = this.fBundleUrlTypesTable.getStructuredSelection();
            if (!ssel.isEmpty() && (object = ssel.getFirstElement()) instanceof IMacBundleUrlType) {
                IMacBundleUrlType propertyToEdit = (IMacBundleUrlType)object;
                Set<IMacBundleUrlType> existing = this.getExistingBundleUrlTypes();
                existing.remove(propertyToEdit);
                this.openBundleURLTypeDialog(propertyToEdit, existing);
            }
        }

        private void openBundleURLTypeDialog(IMacBundleUrlType propertyToEdit, Set<IMacBundleUrlType> existing) {
            IMacBundleUrlType result;
            BundleUrlTypeDialog dialog = new BundleUrlTypeDialog(PDEPlugin.getActiveWorkbenchShell(), propertyToEdit, existing);
            if (dialog.open() == 0 && (result = dialog.getResult()) != null) {
                this.fBundleUrlTypesTable.refresh();
                this.fBundleUrlTypesTable.setSelection((ISelection)new StructuredSelection((Object)result));
                this.updateButtons();
            }
        }

        private Set<IMacBundleUrlType> getExistingBundleUrlTypes() {
            return new HashSet<IMacBundleUrlType>(LauncherSection.this.getLauncherInfo().getMacBundleUrlTypes());
        }

        private void handleRemove() {
            IStructuredSelection ssel = this.fBundleUrlTypesTable.getStructuredSelection();
            if (!ssel.isEmpty()) {
                List bundleUrlTypes = ssel.toList();
                LauncherSection.this.getLauncherInfo().removeMacBundleUrlTypes(bundleUrlTypes);
                this.fBundleUrlTypesTable.refresh(false);
            }
        }

        private void updateButtons() {
            IStructuredSelection selection = this.fBundleUrlTypesTable.getStructuredSelection();
            this.fTablePart.setButtonEnabled(0, LauncherSection.this.isEditable());
            this.fTablePart.setButtonEnabled(1, LauncherSection.this.isEditable() && !selection.isEmpty());
            this.fTablePart.setButtonEnabled(2, LauncherSection.this.isEditable() && !selection.isEmpty());
        }

        private class BundleUrlTypeDialog
        extends StatusDialog {
            private Text fScheme;
            private Text fName;
            private IMacBundleUrlType fEdit;
            private final Set<IMacBundleUrlType> fExistingBundleUrlTypes;

            public BundleUrlTypeDialog(Shell shell, IMacBundleUrlType bundleUrlType, Set<IMacBundleUrlType> existingBundleUrlTypes) {
                super(shell);
                this.fEdit = bundleUrlType;
                this.fExistingBundleUrlTypes = existingBundleUrlTypes;
                this.setTitle(PDEUIMessages.LauncherSection_macBundleUrlTypes_DialogTitle);
            }

            protected Control createDialogArea(Composite parent) {
                Composite comp = (Composite)super.createDialogArea(parent);
                ((GridLayout)comp.getLayout()).numColumns = 2;
                SWTFactory.createLabel(comp, PDEUIMessages.LauncherSection_macBundleUrlTypes_Scheme, 1);
                this.fScheme = SWTFactory.createSingleText(comp, 1);
                this.fScheme.addModifyListener(e -> this.validate());
                SWTFactory.createLabel(comp, PDEUIMessages.LauncherSection_macBundleUrlTypes_Name, 1);
                this.fName = SWTFactory.createSingleText(comp, 1);
                this.fName.addModifyListener(e -> this.validate());
                if (this.fEdit != null) {
                    if (this.fEdit.getScheme() != null) {
                        this.fScheme.setText(this.fEdit.getScheme());
                    }
                    if (this.fEdit.getName() != null) {
                        this.fName.setText(this.fEdit.getName());
                    }
                }
                this.updateStatus(Status.error((String)""));
                return comp;
            }

            protected void validate() {
                String scheme = this.fScheme.getText().trim();
                String name = this.fName.getText().trim();
                if (scheme.length() == 0) {
                    this.updateStatus(Status.error((String)PDEUIMessages.LauncherSection_macBundleUrlTypes_ErrorNoScheme));
                } else if (name.length() == 0) {
                    this.updateStatus(Status.error((String)PDEUIMessages.LauncherSection_macBundleUrlTypes_ErrorNoName));
                } else if (this.fExistingBundleUrlTypes.stream().map(IMacBundleUrlType::getScheme).anyMatch(scheme::equals)) {
                    this.updateStatus(Status.error((String)NLS.bind((String)PDEUIMessages.LauncherSection_macBundleUrlTypes_ErrorSchemeExists, (Object)scheme)));
                } else {
                    this.updateStatus(Status.OK_STATUS);
                }
            }

            protected void okPressed() {
                if (this.fEdit != null) {
                    LauncherSection.this.getLauncherInfo().removeMacBundleUrlTypes(List.of(this.fEdit));
                }
                IProductModelFactory factory = LauncherSection.this.getModel().getFactory();
                this.fEdit = factory.createMacBundleUrlType();
                this.fEdit.setScheme(this.fScheme.getText().trim());
                this.fEdit.setName(this.fName.getText().trim());
                LauncherSection.this.getLauncherInfo().addMacBundleUrlTypes(List.of(this.fEdit));
                super.okPressed();
            }

            protected Control createHelpControl(Composite parent) {
                return parent;
            }

            public IMacBundleUrlType getResult() {
                return this.fEdit;
            }
        }

        private class LabelProvider
        extends PDELabelProvider {
            private LabelProvider() {
            }

            @Override
            public Image getColumnImage(Object obj, int index) {
                return null;
            }

            @Override
            public String getColumnText(Object obj, int index) {
                IMacBundleUrlType bundleUrlType = (IMacBundleUrlType)obj;
                return switch (index) {
                    case 0 -> bundleUrlType.getScheme();
                    case 1 -> bundleUrlType.getName();
                    default -> null;
                };
            }
        }

        private class MacBundleUrlTypesPartAdapter
        extends TablePart {
            public MacBundleUrlTypesPartAdapter(String[] buttonLabels) {
                super(buttonLabels);
            }

            @Override
            public void selectionChanged(IStructuredSelection selection) {
                LauncherSection.this.getManagedForm().fireSelectionChanged((IFormPart)LauncherSection.this, (ISelection)selection);
                MacBundleUrlTypesComposite.this.updateButtons();
            }

            @Override
            public void buttonSelected(Button button, int index) {
                switch (index) {
                    case 0: {
                        MacBundleUrlTypesComposite.this.handleAdd();
                        break;
                    }
                    case 1: {
                        MacBundleUrlTypesComposite.this.handleEdit();
                        break;
                    }
                    case 2: {
                        MacBundleUrlTypesComposite.this.handleRemove();
                    }
                }
            }
        }
    }
}

