/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.scoping.impl;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.lang.reflect.Method;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.scoping.impl.AbstractScopeProvider;
import org.eclipse.xtext.scoping.impl.IDelegatingScopeProvider;
import org.eclipse.xtext.util.PolymorphicDispatcher;

public abstract class AbstractDeclarativeScopeProvider
extends AbstractScopeProvider
implements IDelegatingScopeProvider {
    public static final String NAMED_DELEGATE = "org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider.delegate";
    public static final String NAMED_ERROR_HANDLER = "org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider.errorHandler";
    public final Logger logger = Logger.getLogger(this.getClass());
    @Inject
    @Named(value="org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider.delegate")
    private IScopeProvider delegate;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider.errorHandler")
    private PolymorphicDispatcher.ErrorHandler<IScope> errorHandler = new PolymorphicDispatcher.NullErrorHandler();

    protected IScope delegateGetScope(EObject context, EReference reference) {
        return this.getDelegate().getScope(context, reference);
    }

    public void setDelegate(IScopeProvider delegate) {
        this.delegate = delegate;
    }

    @Override
    public IScopeProvider getDelegate() {
        return this.delegate;
    }

    protected Predicate<Method> getPredicate(EObject context, EClass type) {
        String methodName = "scope_" + type.getName();
        return PolymorphicDispatcher.Predicates.forName((String)methodName, (int)2);
    }

    protected Predicate<Method> getPredicate(EObject context, EReference reference) {
        String methodName = "scope_" + reference.getEContainingClass().getName() + "_" + reference.getName();
        return PolymorphicDispatcher.Predicates.forName((String)methodName, (int)2);
    }

    @Override
    public IScope getScope(EObject context, EReference reference) {
        IScope scope = this.polymorphicFindScopeForReferenceName(context, reference);
        if (scope == null && (scope = this.polymorphicFindScopeForClassName(context, reference)) == null) {
            scope = this.delegateGetScope(context, reference);
        }
        return scope;
    }

    protected IScope polymorphicFindScopeForClassName(EObject context, EReference reference) {
        IScope scope = null;
        PolymorphicDispatcher<IScope> dispatcher = new PolymorphicDispatcher<IScope>(Collections.singletonList(this), this.getPredicate(context, reference.getEReferenceType()), this.errorHandler){

            protected IScope handleNoSuchMethod(Object ... params) {
                if (PolymorphicDispatcher.NullErrorHandler.class.equals(AbstractDeclarativeScopeProvider.this.errorHandler.getClass())) {
                    return null;
                }
                return (IScope)super.handleNoSuchMethod(params);
            }
        };
        EObject current = context;
        while (scope == null && current != null) {
            scope = (IScope)dispatcher.invoke(new Object[]{current, reference});
            current = current.eContainer();
        }
        current = context;
        while (scope == null && current != null) {
            scope = (IScope)dispatcher.invoke(new Object[]{current, reference.getEReferenceType()});
            if (scope != null) {
                this.logger.warn((Object)"scope_<EClass>(EObject,EClass) is deprecated. Use scope_<EClass>(EObject,EReference) instead.");
            }
            current = current.eContainer();
        }
        return scope;
    }

    protected IScope polymorphicFindScopeForReferenceName(EObject context, EReference reference) {
        Predicate<Method> predicate = this.getPredicate(context, reference);
        PolymorphicDispatcher<IScope> dispatcher = new PolymorphicDispatcher<IScope>(Collections.singletonList(this), predicate, this.errorHandler){

            protected IScope handleNoSuchMethod(Object ... params) {
                if (PolymorphicDispatcher.NullErrorHandler.class.equals(AbstractDeclarativeScopeProvider.this.errorHandler.getClass())) {
                    return null;
                }
                return (IScope)super.handleNoSuchMethod(params);
            }
        };
        EObject current = context;
        IScope scope = null;
        while (scope == null && current != null) {
            scope = (IScope)dispatcher.invoke(new Object[]{current, reference});
            current = current.eContainer();
        }
        return scope;
    }

    public void setErrorHandler(PolymorphicDispatcher.ErrorHandler<IScope> errorHandler) {
        this.errorHandler = errorHandler;
    }

    public PolymorphicDispatcher.ErrorHandler<IScope> getErrorHandler() {
        return this.errorHandler;
    }
}

