/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.create.diagrams;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.UMLHelper;
import org.eclipse.papyrus.uml.domain.services.create.CreationStatus;
import org.eclipse.papyrus.uml.domain.services.create.ElementConfigurer;
import org.eclipse.papyrus.uml.domain.services.create.ElementCreator;
import org.eclipse.papyrus.uml.domain.services.create.ICreator;
import org.eclipse.papyrus.uml.domain.services.modify.ElementFeatureModifier;
import org.eclipse.papyrus.uml.domain.services.status.State;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class CompositeStructureDiagramElementCreator
implements ICreator {
    private final ICreator delegate;

    public CompositeStructureDiagramElementCreator(ICreator delegate) {
        this.delegate = delegate;
    }

    public static CompositeStructureDiagramElementCreator buildDefault(ECrossReferenceAdapter crossRef, IEditableChecker editableChecker) {
        return new CompositeStructureDiagramElementCreator(new ElementCreator(new ElementConfigurer(), new ElementFeatureModifier(crossRef, editableChecker)));
    }

    @Override
    public CreationStatus create(EObject parent, String type, String referenceName) {
        if (parent == null || type == null || referenceName == null) {
            return CreationStatus.createFailingStatus(MessageFormat.format("Invalid input for creation (parent ={0} type ={1} referenceName = {2})", parent, type, referenceName));
        }
        CreatorSwitch creatorSwitch = new CreatorSwitch(type, referenceName);
        CreationStatus status = (CreationStatus)creatorSwitch.doSwitch(parent);
        CreationStatus result = status.getState() == State.NOTHING ? this.delegate.create(parent, type, referenceName) : status;
        return result;
    }

    class CreatorSwitch
    extends UMLSwitch<CreationStatus> {
        private final String type;
        private final String referenceName;

        CreatorSwitch(String type, String referenceName) {
            this.type = type;
            this.referenceName = referenceName;
        }

        public CreationStatus caseProperty(Property parent) {
            Type propType;
            CreationStatus result = UMLHelper.toEClass(this.type) == UMLPackage.eINSTANCE.getPort() && UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute().getName().equals(this.referenceName) ? ((propType = parent.getType()) instanceof StructuredClassifier ? CompositeStructureDiagramElementCreator.this.delegate.create((EObject)propType, this.type, this.referenceName) : CreationStatus.createFailingStatus("A Port on a Property can only be created if the type of the property is a StructureClassifier")) : (UMLHelper.toEClass(this.type) == UMLPackage.eINSTANCE.getProperty() && UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute().getName().equals(this.referenceName) ? ((propType = parent.getType()) instanceof StructuredClassifier ? CompositeStructureDiagramElementCreator.this.delegate.create((EObject)propType, this.type, this.referenceName) : CreationStatus.createFailingStatus("A Property can only be created if the type of the property is a StructureClassifier")) : (CreationStatus)super.caseProperty(parent));
            return result;
        }

        public CreationStatus defaultCase(EObject parent) {
            return CreationStatus.NOTHING;
        }
    }
}

