/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.uml.domain.services.EMFUtils;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.create.ElementConfigurer;
import org.eclipse.papyrus.uml.domain.services.create.ElementCreator;
import org.eclipse.papyrus.uml.domain.services.drop.DnDStatus;
import org.eclipse.papyrus.uml.domain.services.drop.IExternalSourceToRepresentationDropBehaviorProvider;
import org.eclipse.papyrus.uml.domain.services.modify.ElementFeatureModifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class SequenceExternalSourceToRepresentationDropBehaviorProvider
implements IExternalSourceToRepresentationDropBehaviorProvider {
    @Override
    public DnDStatus drop(EObject droppedElement, EObject target, ECrossReferenceAdapter crossRef, IEditableChecker editableChecker) {
        return (DnDStatus)new SequenceDropInsideRepresentationBehaviorProviderSwitch(target, crossRef, editableChecker).doSwitch(droppedElement);
    }

    static class SequenceDropInsideRepresentationBehaviorProviderSwitch
    extends UMLSwitch<DnDStatus> {
        private final EObject target;
        private final ECrossReferenceAdapter crossRef;
        private final IEditableChecker editableChecker;

        SequenceDropInsideRepresentationBehaviorProviderSwitch(EObject target, ECrossReferenceAdapter crossRef, IEditableChecker editableChecker) {
            this.target = target;
            this.crossRef = crossRef;
            this.editableChecker = editableChecker;
        }

        public DnDStatus caseProperty(Property property) {
            if (this.target instanceof Interaction || this.target instanceof Lifeline) {
                Set<EObject> resultStatusElements;
                Lifeline lifeline = null;
                EObject eObject = this.target;
                if (eObject instanceof Interaction) {
                    Interaction interaction = (Interaction)eObject;
                    lifeline = this.createLifeline(interaction);
                    resultStatusElements = Set.of(lifeline);
                } else {
                    lifeline = (Lifeline)this.target;
                    resultStatusElements = Collections.emptySet();
                }
                lifeline.setRepresents((ConnectableElement)property);
                return DnDStatus.createOKStatus(resultStatusElements);
            }
            return (DnDStatus)super.caseProperty(property);
        }

        public DnDStatus caseType(Type type) {
            if (this.target instanceof Interaction || this.target instanceof Lifeline) {
                Set<Object> resultStatusElements;
                Lifeline lifeline = null;
                Property property = null;
                EObject eObject = this.target;
                if (eObject instanceof Interaction) {
                    Interaction interaction = (Interaction)eObject;
                    property = this.createProperty(interaction);
                    lifeline = this.createLifeline(interaction);
                    resultStatusElements = Set.of(lifeline);
                } else {
                    property = this.createProperty(EMFUtils.getAncestor(Interaction.class, this.target));
                    lifeline = (Lifeline)this.target;
                    resultStatusElements = Collections.emptySet();
                }
                property.setType(type);
                lifeline.setRepresents((ConnectableElement)property);
                return DnDStatus.createOKStatus(resultStatusElements);
            }
            return (DnDStatus)super.caseType(type);
        }

        private ElementCreator initElementCreator() {
            ElementFeatureModifier featureModifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            ElementCreator elementCreator = new ElementCreator(new ElementConfigurer(), featureModifier);
            return elementCreator;
        }

        private Lifeline createLifeline(Interaction interaction) {
            ElementCreator elementCreator = this.initElementCreator();
            return (Lifeline)elementCreator.create((EObject)interaction, UMLPackage.eINSTANCE.getLifeline().getName(), UMLPackage.eINSTANCE.getInteraction_Lifeline().getName()).getElement();
        }

        private Property createProperty(Interaction parentInteraction) {
            ElementCreator elementCreator = this.initElementCreator();
            return (Property)elementCreator.create((EObject)parentInteraction, UMLPackage.eINSTANCE.getProperty().getName(), UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute().getName()).getElement();
        }

        public DnDStatus defaultCase(EObject obj) {
            return DnDStatus.createFailingStatus("DnD is forbidden.", Collections.emptySet());
        }
    }
}

