/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.labels;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.labels.INamedElementNameProvider;
import org.eclipse.papyrus.uml.domain.services.labels.IViewLabelProvider;
import org.eclipse.papyrus.uml.domain.services.labels.KeywordLabelProvider;
import org.eclipse.papyrus.uml.domain.services.labels.StereotypeLabelPrefixProvider;
import org.eclipse.papyrus.uml.domain.services.labels.domains.CollaborationUseLabelHelper;
import org.eclipse.papyrus.uml.domain.services.labels.domains.DefaultNamedElementNameProvider;
import org.eclipse.papyrus.uml.domain.services.labels.domains.OperationLabelHelper;
import org.eclipse.papyrus.uml.domain.services.labels.domains.ParameterLabelHelper;
import org.eclipse.papyrus.uml.domain.services.labels.domains.PropertyLabelHelper;
import org.eclipse.papyrus.uml.domain.services.labels.domains.ReceptionLabelHelper;
import org.eclipse.papyrus.uml.domain.services.labels.domains.TransitionPropertiesParser;
import org.eclipse.papyrus.uml.domain.services.labels.domains.ValueSpecificationLabelHelper;
import org.eclipse.papyrus.uml.domain.services.labels.domains.VisibilityLabelHelper;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.CommunicationPath;
import org.eclipse.uml2.uml.ConditionalNode;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Duration;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExpansionKind;
import org.eclipse.uml2.uml.ExpansionRegion;
import org.eclipse.uml2.uml.InformationFlow;
import org.eclipse.uml2.uml.InteractionConstraint;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.IntervalConstraint;
import org.eclipse.uml2.uml.JoinNode;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.LoopNode;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.SequenceNode;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLSwitch;

public final class ElementLabelProvider
implements IViewLabelProvider {
    private ElementLabelProviderSwitch nameRenderer;
    private final Function<EObject, String> prefixLabelProvider;
    private final Function<EObject, String> keywordLabelProvider;
    private final String prefixSeparator;
    private final String keywordSeparator;

    private ElementLabelProvider(Builder builder) {
        this.prefixLabelProvider = builder.prefixLabelProvider != null ? builder.prefixLabelProvider : e -> null;
        this.keywordLabelProvider = builder.keywordLabelProvider != null ? builder.keywordLabelProvider : e -> null;
        INamedElementNameProvider nameProvider = builder.nameProvider == null ? new DefaultNamedElementNameProvider() : builder.nameProvider;
        this.nameRenderer = new ElementLabelProviderSwitch(nameProvider);
        this.prefixSeparator = builder.prefixSeparator;
        this.keywordSeparator = builder.keywordSeparator;
    }

    public static ElementLabelProvider buildDefault() {
        return ElementLabelProvider.builder().withKeywordLabelProvider(new KeywordLabelProvider()).withNameProvider(new DefaultNamedElementNameProvider()).withPrefixLabelProvider(new StereotypeLabelPrefixProvider()).build();
    }

    @Override
    public String getLabel(EObject element) {
        String baseLabel;
        String prefix;
        if (element == null) {
            return "";
        }
        StringBuilder label = new StringBuilder();
        String keyword = this.keywordLabelProvider.apply(element);
        if (keyword != null && !keyword.isBlank()) {
            label.append(keyword);
        }
        if ((prefix = this.prefixLabelProvider.apply(element)) != null && !prefix.isBlank()) {
            if (label.length() > 0) {
                label.append(this.keywordSeparator);
            }
            label.append(prefix);
        }
        if ((baseLabel = (String)this.nameRenderer.doSwitch(element)) != null && !baseLabel.isBlank()) {
            if (label.length() > 0) {
                label.append(this.prefixSeparator);
            }
            label.append(baseLabel);
        }
        return label.toString();
    }

    private static StringBuilder encloseInBrackets(String content, StringBuilder builder) {
        builder.append("{");
        builder.append(content);
        builder.append("}");
        return builder;
    }

    private static String encloseInBrackets(String content) {
        return ElementLabelProvider.encloseInBrackets(content, new StringBuilder()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private INamedElementNameProvider nameProvider;
        private Function<EObject, String> prefixLabelProvider;
        private Function<EObject, String> keywordLabelProvider;
        private String prefixSeparator = "\n";
        private String keywordSeparator = "\n";

        private Builder() {
        }

        public Builder withNameProvider(INamedElementNameProvider aNameProvider) {
            this.nameProvider = aNameProvider;
            return this;
        }

        public Builder withPrefixLabelProvider(Function<EObject, String> aPrefixLabelProvider) {
            this.prefixLabelProvider = aPrefixLabelProvider;
            return this;
        }

        public Builder withKeywordLabelProvider(Function<EObject, String> aKeywordLabelProvider) {
            this.keywordLabelProvider = aKeywordLabelProvider;
            return this;
        }

        public Builder withPrefixSeparator(String aPrefixSeparator) {
            this.prefixSeparator = aPrefixSeparator;
            return this;
        }

        public Builder withKeywordSeparator(String aKeywordSeparator) {
            this.keywordSeparator = aKeywordSeparator;
            return this;
        }

        public ElementLabelProvider build() {
            return new ElementLabelProvider(this);
        }
    }

    static final class ElementLabelProviderSwitch
    extends UMLSwitch<String> {
        private static final String REF = "ref";
        private static final String ASSIGNED = " = ";
        private static final String WEIGHT = "weight=";
        private static final String CONDITIONAL = "\u00abconditional\u00bb";
        private static final String SEQUENCE = "\u00absequence\u00bb";
        private static final String LOOP_NODE = "\u00abloop node\u00bb";
        private static final String STRUCTURED = "\u00abstructured\u00bb";
        private static final String JOIN_SPEC = "joinSpec = ";
        private static final String NATURAL = "NATURAL";
        private static final String NULL_CONSTRAINT = "<NULL Constraint>";
        private static final String TIME_OBSERVATION = " = now";
        private static final String DURATION_OBSERVATION = " = duration";
        private static final String TYPED = " : ";
        private CollaborationUseLabelHelper collaborationUseLabelHelper;
        private PropertyLabelHelper propertyLabelHelper;
        private ParameterLabelHelper parameterLabelHelper;
        private INamedElementNameProvider namedElementNameProvider;
        private VisibilityLabelHelper visibilityLabelHelper;
        private ValueSpecificationLabelHelper valueSpecificationHelper;
        private final OperationLabelHelper operationLabelHelper;
        private final ReceptionLabelHelper receptionLabelHelper;

        ElementLabelProviderSwitch(INamedElementNameProvider namedElementNameProvider) {
            this.namedElementNameProvider = Objects.requireNonNull(namedElementNameProvider);
            this.visibilityLabelHelper = new VisibilityLabelHelper();
            this.collaborationUseLabelHelper = new CollaborationUseLabelHelper(namedElementNameProvider, this.visibilityLabelHelper);
            this.propertyLabelHelper = new PropertyLabelHelper(false, true, namedElementNameProvider, this.visibilityLabelHelper);
            this.parameterLabelHelper = new ParameterLabelHelper(false, true, namedElementNameProvider);
            this.valueSpecificationHelper = new ValueSpecificationLabelHelper(namedElementNameProvider);
            this.operationLabelHelper = new OperationLabelHelper(this.parameterLabelHelper, this.visibilityLabelHelper, this.namedElementNameProvider);
            this.receptionLabelHelper = new ReceptionLabelHelper(this.parameterLabelHelper, this.visibilityLabelHelper, this.namedElementNameProvider);
        }

        public String caseCollaborationUse(CollaborationUse collaborationUse) {
            return this.collaborationUseLabelHelper.getLabel(collaborationUse);
        }

        public String caseCombinedFragment(CombinedFragment combinedFragment) {
            return combinedFragment.getInteractionOperator().getName();
        }

        public String caseComment(Comment comment) {
            return comment.getBody();
        }

        public String caseCommunicationPath(CommunicationPath communicationPath) {
            Object result = "";
            String name = this.namedElementNameProvider.getName((NamedElement)communicationPath);
            if (communicationPath.isDerived()) {
                result = (String)result + "/";
            }
            result = (String)result + name;
            return result;
        }

        public String caseInformationFlow(InformationFlow flow) {
            Object result = "";
            if (flow != null) {
                result = this.getConveyeds((EList<Classifier>)flow.getConveyeds());
                String flowName = this.namedElementNameProvider.getName((NamedElement)flow);
                if (flowName != null && !flowName.isBlank()) {
                    if (!((String)result).isBlank()) {
                        result = (String)result + "\n";
                    }
                    result = (String)result + flowName;
                }
            }
            return result;
        }

        public String caseInteractionOperand(InteractionOperand interactionOperand) {
            Object result = "";
            InteractionConstraint guard = interactionOperand.getGuard();
            if (guard != null && guard.getSpecification() != null) {
                String specificationValue = this.valueSpecificationHelper.getSpecificationValue(guard.getSpecification(), true);
                result = (String)result + "[" + specificationValue + "]";
            }
            return result;
        }

        public String caseInteractionUse(InteractionUse interactionUse) {
            return REF;
        }

        private String getConveyeds(EList<Classifier> conveyeds) {
            Object result = "";
            if (!conveyeds.isEmpty()) {
                result = (String)result + conveyeds.stream().map(NamedElement::getName).collect(Collectors.joining(", "));
            }
            return result;
        }

        public String caseNamedElement(NamedElement object) {
            return this.namedElementNameProvider.getName(object);
        }

        public String caseRegion(Region object) {
            return "";
        }

        public String caseProperty(Property property) {
            return this.propertyLabelHelper.getLabel(property);
        }

        public String caseParameter(Parameter parameter) {
            return this.parameterLabelHelper.getLabel(parameter);
        }

        public String caseConstraint(Constraint constraint) {
            Object specLabel;
            StringBuilder constLabel = new StringBuilder();
            constLabel.append(constraint.getName());
            constLabel.append("\n");
            ValueSpecification value = constraint.getSpecification();
            if (value == null) {
                specLabel = NULL_CONSTRAINT;
            } else if (value instanceof OpaqueExpression) {
                OpaqueExpression expression = (OpaqueExpression)value;
                if (!expression.getBodies().isEmpty()) {
                    String lang = (String)expression.getLanguages().get(0);
                    specLabel = (String)expression.getBodies().get(0);
                    if (!lang.isEmpty()) {
                        specLabel = ElementLabelProvider.encloseInBrackets(lang) + " " + (String)specLabel;
                    }
                } else {
                    specLabel = ElementLabelProvider.encloseInBrackets(NATURAL) + " ";
                }
            } else {
                specLabel = this.valueSpecificationHelper.getSpecificationValue(value, false);
            }
            return ElementLabelProvider.encloseInBrackets((String)specLabel, constLabel).toString();
        }

        public String caseOperation(Operation operation) {
            return this.operationLabelHelper.getLabel(operation);
        }

        public String caseReception(Reception reception) {
            return this.receptionLabelHelper.getLabel(reception);
        }

        public String caseStateInvariant(StateInvariant stateInvariant) {
            ValueSpecification value = null;
            if (stateInvariant.getInvariant() != null) {
                value = stateInvariant.getInvariant().getSpecification();
            }
            return this.getValueBasedLabel((NamedElement)stateInvariant, value);
        }

        public String caseDurationObservation(DurationObservation object) {
            return this.namedElementNameProvider.getName((NamedElement)object) + DURATION_OBSERVATION;
        }

        public String caseTimeObservation(TimeObservation object) {
            return this.namedElementNameProvider.getName((NamedElement)object) + TIME_OBSERVATION;
        }

        public String caseIntervalConstraint(IntervalConstraint object) {
            return this.getValueBasedLabel((NamedElement)object, object.getSpecification());
        }

        public String caseTimeExpression(TimeExpression timeExpression) {
            StringBuilder constLabel = new StringBuilder();
            constLabel.append(this.namedElementNameProvider.getName((NamedElement)timeExpression));
            ValueSpecification expr = timeExpression.getExpr();
            if (expr != null) {
                constLabel.append("=");
                constLabel.append(this.valueSpecificationHelper.getSpecificationValue(expr, true));
            }
            return constLabel.toString();
        }

        public String caseDuration(Duration duration) {
            StringBuilder constLabel = new StringBuilder();
            constLabel.append(this.namedElementNameProvider.getName((NamedElement)duration));
            ValueSpecification expr = duration.getExpr();
            if (expr != null) {
                constLabel.append("=");
                constLabel.append(this.valueSpecificationHelper.getSpecificationValue(expr, true));
            }
            return constLabel.toString();
        }

        public String caseActivityPartition(ActivityPartition activityPartition) {
            Element representedElement = activityPartition.getRepresents();
            String label = representedElement instanceof NamedElement ? this.namedElementNameProvider.getName((NamedElement)representedElement) : (String)super.caseActivityPartition(activityPartition);
            return label;
        }

        public String caseTransition(Transition transition) {
            return new TransitionPropertiesParser(this.namedElementNameProvider).getValueString(transition);
        }

        public String caseExpansionRegion(ExpansionRegion expansionRegion) {
            ExpansionKind mode = expansionRegion.getMode();
            return "\u00ab" + mode.getName() + "\u00bb";
        }

        public String caseJoinNode(JoinNode joinNode) {
            StringBuilder constLabel = new StringBuilder();
            ValueSpecification joinSpec = joinNode.getJoinSpec();
            if (joinSpec != null) {
                ElementLabelProvider.encloseInBrackets(JOIN_SPEC + this.valueSpecificationHelper.getSpecificationValue(joinSpec, true), constLabel);
                constLabel.append("\n");
            }
            constLabel.append(this.namedElementNameProvider.getName((NamedElement)joinNode));
            return constLabel.toString();
        }

        public String caseStructuredActivityNode(StructuredActivityNode structuredActivityNode) {
            return STRUCTURED;
        }

        public String caseLoopNode(LoopNode loopNode) {
            return LOOP_NODE;
        }

        public String caseSequenceNode(SequenceNode sequenceNode) {
            return SEQUENCE;
        }

        public String caseConditionalNode(ConditionalNode conditionalNode) {
            return CONDITIONAL;
        }

        public String caseLifeline(Lifeline lifeline) {
            StringBuilder lifelineLabel = new StringBuilder();
            ConnectableElement connectableElement = lifeline.getRepresents();
            ValueSpecification selector = lifeline.getSelector();
            if (connectableElement == null) {
                String lifelineName = this.namedElementNameProvider.getName((NamedElement)lifeline);
                if (lifelineName != null) {
                    lifelineLabel.append(lifelineName);
                }
            } else {
                Type type;
                String connectableElementName = this.namedElementNameProvider.getName((NamedElement)connectableElement);
                if (connectableElementName != null) {
                    lifelineLabel.append(connectableElementName);
                }
                if (selector != null) {
                    lifelineLabel.append("[");
                    lifelineLabel.append(this.valueSpecificationHelper.getSpecificationValue(selector, true));
                    lifelineLabel.append("]");
                }
                if ((type = connectableElement.getType()) != null) {
                    lifelineLabel.append(TYPED);
                    lifelineLabel.append(this.namedElementNameProvider.getName((NamedElement)type));
                }
            }
            return lifelineLabel.toString();
        }

        public String caseActivityEdge(ActivityEdge activityEdge) {
            StringBuilder objectFlowStringBuilder = new StringBuilder();
            ValueSpecification weight = activityEdge.getWeight();
            ValueSpecification guard = activityEdge.getGuard();
            objectFlowStringBuilder.append(this.namedElementNameProvider.getName((NamedElement)activityEdge));
            if (weight != null) {
                if (!objectFlowStringBuilder.isEmpty()) {
                    objectFlowStringBuilder.append("\n");
                }
                ElementLabelProvider.encloseInBrackets(WEIGHT + this.valueSpecificationHelper.getSpecificationValue(weight, true), objectFlowStringBuilder);
            }
            if (guard != null) {
                if (!objectFlowStringBuilder.isEmpty()) {
                    objectFlowStringBuilder.append("\n");
                }
                objectFlowStringBuilder.append("[");
                objectFlowStringBuilder.append(this.valueSpecificationHelper.getSpecificationValue(guard, true));
                objectFlowStringBuilder.append("]");
            }
            return objectFlowStringBuilder.toString();
        }

        private String getValueBasedLabel(NamedElement element, ValueSpecification value) {
            if (value == null) {
                return this.namedElementNameProvider.getName(element);
            }
            return ElementLabelProvider.encloseInBrackets(this.valueSpecificationHelper.getSpecificationValue(value, false));
        }
    }
}

