/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.labels.domains;

import java.util.Iterator;
import org.eclipse.papyrus.uml.domain.services.labels.domains.OpaqueExpressionLabelHelper;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;

public class OpaqueBehaviorLabelHelper {
    public static final String DOTS = "...";
    public static final String PARAM_DOTS = "(...)";
    public static final String EMPTY_STRING = "";

    public static String getBody(OpaqueBehavior behavior, String language) {
        int index = 0;
        String tmp = EMPTY_STRING;
        index = OpaqueBehaviorLabelHelper.getBodyIndex(behavior, language);
        if (index > -1 && index < behavior.getBodies().size()) {
            tmp = (String)behavior.getBodies().get(index);
        }
        return tmp;
    }

    public static int getBodyIndex(OpaqueBehavior behavior, String language) {
        int index = 0;
        boolean isFound = false;
        Iterator it = behavior.getLanguages().iterator();
        while (it.hasNext() && !isFound) {
            String lang = (String)it.next();
            if (lang.equalsIgnoreCase(language)) {
                isFound = true;
                continue;
            }
            ++index;
        }
        if (!isFound) {
            index = -1;
        }
        return index;
    }

    public static String cutBodyString(String body) {
        int cutLength = 1;
        if (cutLength == 0) {
            return DOTS;
        }
        int start = 0;
        int newStart = 0;
        while (cutLength > 0) {
            newStart = body.indexOf("\n", start);
            if (newStart > 0) {
                --cutLength;
                start = newStart + 1;
                continue;
            }
            return body;
        }
        if (newStart > 0) {
            if (newStart >= 1 && body.charAt(newStart - 1) == '\r') {
                return body.substring(0, start - 1) + DOTS;
            }
            return body.substring(0, newStart) + DOTS;
        }
        return body;
    }

    public static String retrieveBody(OpaqueBehavior ob) {
        String body = OpaqueBehaviorLabelHelper.getBody(ob, "Natural Language");
        if (body.equals(EMPTY_STRING) && ob.getBodies().size() > 0) {
            body = (String)ob.getBodies().get(0);
        }
        return OpaqueBehaviorLabelHelper.cutBodyString(body);
    }

    public static String retrieveBody(OpaqueExpression exp) {
        String body = OpaqueExpressionLabelHelper.getBodyForLanguage(exp, "Natural Language");
        if (body.equals(EMPTY_STRING)) {
            body = OpaqueExpressionLabelHelper.getBodyForLanguage(exp, null);
        }
        return OpaqueBehaviorLabelHelper.cutBodyString(body);
    }
}

