/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.profile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.uml.domain.services.profile.ProfileDefinition;
import org.eclipse.papyrus.uml.domain.services.profile.ProfileRedefinitionHelper;
import org.eclipse.papyrus.uml.domain.services.profile.ProfileUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class DynamicProfileConverter {
    public boolean generateEPackageInProfile(Profile rootProfile, boolean saveConstraint, ProfileDefinition profileDefinition) {
        ProfileRedefinitionHelper.removeUndefinedVersion((Package)rootProfile);
        List<EPackage> profileDefinitions = DynamicProfileConverter.defineProfiles((Package)rootProfile, saveConstraint);
        if (profileDefinitions.size() > 0) {
            ProfileRedefinitionHelper.redefineProfile((Package)rootProfile, profileDefinition);
            ProfileRedefinitionHelper.cleanProfile((Package)rootProfile);
            return true;
        }
        return false;
    }

    public static List<EPackage> defineProfiles(Package thePackage, boolean saveConstraintInDef) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ECORE_TAGGED_VALUES", "PROCESS");
        options.put("DERIVED_FEATURES", "REPORT");
        options.put("DUPLICATE_FEATURE_INHERITANCE", "PROCESS");
        options.put("DUPLICATE_FEATURES", "PROCESS");
        options.put("DUPLICATE_OPERATIONS", "REPORT");
        options.put("DUPLICATE_OPERATION_INHERITANCE", "REPORT");
        options.put("REDEFINING_OPERATIONS", "REPORT");
        options.put("REDEFINING_PROPERTIES", "REPORT");
        options.put("SUBSETTING_PROPERTIES", "REPORT");
        options.put("UNION_PROPERTIES", "PROCESS");
        options.put("SUPER_CLASS_ORDER", "REPORT");
        options.put("ANNOTATION_DETAILS", "REPORT");
        String handleConstraints = "PROCESS";
        if (!saveConstraintInDef) {
            handleConstraints = "IGNORE";
        }
        options.put("INVARIANT_CONSTRAINTS", handleConstraints);
        options.put("VALIDATION_DELEGATES", handleConstraints);
        options.put("INVOCATION_DELEGATES", handleConstraints);
        options.put("OPERATION_BODIES", handleConstraints);
        options.put("OCL_DELEGATE_URI", "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        options.put("COMMENTS", "IGNORE");
        options.put("FOREIGN_DEFINITIONS", "PROCESS");
        options.put("UNTYPED_PROPERTIES", "PROCESS");
        ArrayList<Profile> toDefine = new ArrayList<Profile>();
        TreeIterator all = UML2Util.getAllContents((EObject)thePackage, (boolean)true, (boolean)false);
        while (all.hasNext()) {
            EObject eObject = (EObject)all.next();
            if (eObject instanceof Profile) {
                toDefine.add((Profile)eObject);
                continue;
            }
            if (eObject instanceof Package) continue;
            all.prune();
        }
        if (toDefine.size() > 1) {
            ProfileUtil.sortProfiles(toDefine);
        }
        ArrayList<EPackage> result = new ArrayList<EPackage>(toDefine.size());
        for (Profile profile : toDefine) {
            result.add(profile.define(options, null, null));
        }
        return result;
    }
}

