/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.properties;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class UMLUtil {
    public static Stereotype getAppliedStereotype(Element umlElement, String stereotypeName, boolean strict) {
        Stereotype res = null;
        if (umlElement != null && stereotypeName != null) {
            res = umlElement.getAppliedStereotype(stereotypeName);
            if (!strict && res == null) {
                for (Stereotype subStereotype : umlElement.getAppliedStereotypes()) {
                    for (Stereotype superStereotype : UMLUtil.getAllSuperStereotypes(subStereotype)) {
                        if (!stereotypeName.equals(superStereotype.getQualifiedName())) continue;
                        return subStereotype;
                    }
                }
            }
        }
        return res;
    }

    public static Collection<Stereotype> getAllSuperStereotypes(Stereotype stereotype) {
        HashSet<Stereotype> result = new HashSet<Stereotype>();
        if (stereotype != null) {
            UMLUtil.getAllSuperStereotypes(stereotype, result);
        }
        return result;
    }

    private static void getAllSuperStereotypes(Stereotype stereotype, Set<Stereotype> result) {
        result.add(stereotype);
        for (Classifier superClassifier : stereotype.getGenerals()) {
            if (!(superClassifier instanceof Stereotype) || result.contains(superClassifier)) continue;
            UMLUtil.getAllSuperStereotypes((Stereotype)superClassifier, result);
        }
    }
}

