/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.scope;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.uml.domain.services.EMFUtils;
import org.eclipse.papyrus.uml.domain.services.profile.StereotypeUtil;
import org.eclipse.papyrus.uml.domain.services.scope.IRootCandidateSearchProvider;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;

public class ElementRootCandidateSeachProvider
implements IRootCandidateSearchProvider {
    @Override
    public List<Notifier> getReachableRoots(EObject self) {
        return this.computeReachableRootCandidates(self);
    }

    private List<Notifier> computeReachableRootCandidates(EObject self) {
        List<Notifier> result;
        if (self instanceof Element) {
            Element elem = (Element)self;
            result = this.computeElementReachableRoots(elem);
        } else {
            result = self != null && StereotypeUtil.isStereotypeApplication(self) ? this.handleStereotypeApplication(self) : List.of();
        }
        return result;
    }

    private List<Notifier> handleStereotypeApplication(EObject self) {
        Element element = this.getBaseElement(self);
        List<Notifier> result = element != null ? this.computeElementReachableRoots(element) : List.of();
        return result;
    }

    private Element getBaseElement(EObject self) {
        return StereotypeUtil.getInUsedBaseReference(self).map(ref -> self.eGet((EStructuralFeature)ref)).orElse(null);
    }

    private void computeReachableRoots(Element elem, Set<Notifier> roots, Set<Notifier> computed) {
        computed.add((Notifier)elem);
        for (Package importedPackage : this.getAllImportedPackages(elem)) {
            if (computed.contains(importedPackage) || !roots.add((Notifier)importedPackage)) continue;
            this.computeReachableRoots((Element)importedPackage, roots, computed);
        }
    }

    private List<Notifier> computeElementReachableRoots(Element elem) {
        HashSet<Notifier> roots = new HashSet<Notifier>();
        HashSet<Notifier> computed = new HashSet<Notifier>();
        EObject rootElement = EcoreUtil.getRootContainer((EObject)elem);
        if (rootElement != null) {
            roots.add((Notifier)rootElement);
            computed.add((Notifier)rootElement);
        }
        for (Package importedPackage : this.getAllImportedPackages(elem)) {
            if (!roots.add((Notifier)importedPackage)) continue;
            this.computeReachableRoots((Element)importedPackage, roots, computed);
        }
        return this.filterNestedRoots(roots);
    }

    private List<Notifier> filterNestedRoots(Set<Notifier> roots) {
        ArrayList<Notifier> result = new ArrayList<Notifier>(roots);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Object root = iterator.next();
            if (!(root instanceof EObject)) continue;
            EObject rootEObject = (EObject)root;
            EObject eContainer = rootEObject.eContainer();
            boolean isNested = false;
            while (eContainer != null && !isNested) {
                isNested = roots.contains(eContainer);
                eContainer = eContainer.eContainer();
            }
            if (!isNested) continue;
            iterator.remove();
        }
        return result;
    }

    private List<Package> getAllImportedPackages(Element elem) {
        List<Namespace> ancestors = EMFUtils.getAncestors(Namespace.class, (EObject)elem);
        Stream importedNamespace = ancestors.stream().flatMap(pack -> pack.getImportedPackages().stream());
        if (elem instanceof Package) {
            Package pack2 = (Package)elem;
            importedNamespace = Stream.concat(importedNamespace, pack2.getImportedPackages().stream());
        }
        return importedNamespace.distinct().toList();
    }
}

