/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.tools.api.command.semantic.AddSemanticResourceCommand;
import org.eclipse.sirius.viewpoint.provider.Messages;

public class SemanticResourceAdditionOperation
implements IRunnableWithProgress {
    private Collection<Session> sessions;
    private Collection<URI> uris;
    private Collection<Object> results;

    public SemanticResourceAdditionOperation(Collection<Session> sessions, Collection<URI> uris) {
        this.sessions = sessions;
        this.uris = uris;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(Messages.SemanticResourceAdditionOperation_semanticResourceAdditionTask, this.uris.size() * this.sessions.size());
            this.results = new LinkedHashSet<Object>();
            for (Session session : this.sessions) {
                TransactionalEditingDomain transDomain = session.getTransactionalEditingDomain();
                CompoundCommand command = new CompoundCommand();
                for (URI semanticModelURI : this.uris) {
                    AddSemanticResourceCommand cmd = new AddSemanticResourceCommand(session, semanticModelURI, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    command.append((Command)cmd);
                }
                transDomain.getCommandStack().execute((Command)command);
                this.results.addAll(command.getResult());
            }
        }
        finally {
            monitor.done();
        }
    }

    public Collection<Object> getResults() {
        return this.results;
    }
}

