/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.collections;

import com.google.common.collect.ForwardingSetMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.InvalidationListener;
import org.eclipse.gef.common.collections.ObservableSetMultimap;
import org.eclipse.gef.common.collections.SetMultimapChangeListener;
import org.eclipse.gef.common.collections.SetMultimapListenerHelper;

class ObservableSetMultimapWrapper<K, V>
extends ForwardingSetMultimap<K, V>
implements ObservableSetMultimap<K, V> {
    private SetMultimap<K, V> backingSetMultiMap;
    private SetMultimapListenerHelper<K, V> helper = new SetMultimapListenerHelper(this);

    public ObservableSetMultimapWrapper(SetMultimap<K, V> setMultimap) {
        this.backingSetMultiMap = setMultimap;
    }

    public void addListener(InvalidationListener listener) {
        this.helper.addListener(listener);
    }

    @Override
    public void addListener(SetMultimapChangeListener<? super K, ? super V> listener) {
        this.helper.addListener(listener);
    }

    public void clear() {
        SetMultimap<K, V> previousContents = this.delegateCopy();
        super.clear();
        if (!previousContents.isEmpty()) {
            ArrayList elementaryChanges = new ArrayList();
            for (Object key : previousContents.keySet()) {
                elementaryChanges.add(new SetMultimapListenerHelper.ElementarySubChange(key, previousContents.get(key), Collections.emptySet()));
            }
            this.helper.fireValueChangedEvent(new SetMultimapListenerHelper.AtomicChange<K, V>(this, previousContents, elementaryChanges));
        }
    }

    protected SetMultimap<K, V> delegate() {
        return this.backingSetMultiMap;
    }

    protected SetMultimap<K, V> delegateCopy() {
        return HashMultimap.create(this.backingSetMultiMap);
    }

    public boolean put(K key, V value) {
        SetMultimap<K, V> previousContents = this.delegateCopy();
        if (super.put(key, value)) {
            this.helper.fireValueChangedEvent(new SetMultimapListenerHelper.AtomicChange<K, V>(this, previousContents, new SetMultimapListenerHelper.ElementarySubChange(key, Collections.emptySet(), Collections.singleton(value))));
            return true;
        }
        return false;
    }

    public boolean putAll(K key, Iterable<? extends V> values) {
        SetMultimap<K, V> previousContents = this.delegateCopy();
        if (super.putAll(key, values)) {
            HashSet removedValues = new HashSet(previousContents.get(key));
            removedValues.removeAll(this.get(key));
            HashSet addedValues = new HashSet(this.get(key));
            addedValues.removeAll(previousContents.get(key));
            this.helper.fireValueChangedEvent(new SetMultimapListenerHelper.AtomicChange<K, V>(this, previousContents, new SetMultimapListenerHelper.ElementarySubChange(key, removedValues, addedValues)));
            return true;
        }
        return false;
    }

    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        SetMultimap<K, V> previousContents = this.delegateCopy();
        if (super.putAll(multimap)) {
            ArrayList elementaryChanges = new ArrayList();
            for (Object key : multimap.keySet()) {
                HashSet removedValues = new HashSet(previousContents.get(key));
                removedValues.removeAll(this.get(key));
                HashSet addedValues = new HashSet(this.get(key));
                addedValues.removeAll(previousContents.get(key));
                elementaryChanges.add(new SetMultimapListenerHelper.ElementarySubChange(key, removedValues, addedValues));
            }
            this.helper.fireValueChangedEvent(new SetMultimapListenerHelper.AtomicChange<K, V>(this, previousContents, elementaryChanges));
            return true;
        }
        return false;
    }

    public boolean remove(Object key, Object value) {
        SetMultimap<K, V> previousContents = this.delegateCopy();
        if (super.remove(key, value)) {
            this.helper.fireValueChangedEvent(new SetMultimapListenerHelper.AtomicChange<Object, Object>(this, previousContents, new SetMultimapListenerHelper.ElementarySubChange<Object, Object>(key, Collections.singleton(value), Collections.emptySet())));
            return true;
        }
        return false;
    }

    public Set<V> removeAll(Object key) {
        SetMultimap<K, V> previousContents = this.delegateCopy();
        Set oldValues = super.removeAll(key);
        if (!oldValues.isEmpty()) {
            this.helper.fireValueChangedEvent(new SetMultimapListenerHelper.AtomicChange<Object, V>(this, previousContents, new SetMultimapListenerHelper.ElementarySubChange(key, oldValues, Collections.emptySet())));
        }
        return oldValues;
    }

    public void removeListener(InvalidationListener listener) {
        this.helper.removeListener(listener);
    }

    @Override
    public void removeListener(SetMultimapChangeListener<? super K, ? super V> listener) {
        this.helper.removeListener(listener);
    }

    @Override
    public boolean replaceAll(SetMultimap<? extends K, ? extends V> setMultimap) {
        SetMultimap<K, V> previousContents = this.delegateCopy();
        super.clear();
        super.putAll(setMultimap);
        if (!previousContents.equals(setMultimap)) {
            ArrayList elementaryChanges = new ArrayList();
            for (Object key : previousContents.keySet()) {
                if (!setMultimap.containsKey(key)) {
                    elementaryChanges.add(new SetMultimapListenerHelper.ElementarySubChange(key, new HashSet(previousContents.get(key)), Collections.emptySet()));
                    continue;
                }
                HashSet addedValues = new HashSet(this.get(key));
                addedValues.removeAll(previousContents.get(key));
                HashSet removedValues = new HashSet(previousContents.get(key));
                removedValues.removeAll(this.get(key));
                if (addedValues.isEmpty() && removedValues.isEmpty()) continue;
                elementaryChanges.add(new SetMultimapListenerHelper.ElementarySubChange(key, removedValues, addedValues));
            }
            for (Object key : this.keySet()) {
                if (previousContents.containsKey(key)) continue;
                elementaryChanges.add(new SetMultimapListenerHelper.ElementarySubChange(key, Collections.emptySet(), new HashSet(this.get(key))));
            }
            this.helper.fireValueChangedEvent(new SetMultimapListenerHelper.AtomicChange<K, V>(this, previousContents, elementaryChanges));
            return true;
        }
        return false;
    }

    public Set<V> replaceValues(K key, Iterable<? extends V> values) {
        SetMultimap<K, V> previousContents = this.delegateCopy();
        Set replacedValues = super.replaceValues(key, values);
        if (!replacedValues.isEmpty()) {
            this.helper.fireValueChangedEvent(new SetMultimapListenerHelper.AtomicChange<K, V>(this, previousContents, new SetMultimapListenerHelper.ElementarySubChange(key, replacedValues, Sets.newHashSet(values))));
        }
        return replacedValues;
    }
}

