/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.edit.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCreationEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultGraphicalNodeEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultSemanticEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.RoundedRectangleNodePlateFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SelectableBorderedNodeFigure;
import org.eclipse.papyrus.uml.diagram.common.editparts.RoundedCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AffixedNodeAlignmentEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.BorderItemResizableEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.QualifiedNameDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideCompartmentEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.SideAffixedNodesCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocator;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.figures.StateMachineFigure;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.policies.CustomStateMachineDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.policies.CustomStateMachineLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.PseudostateEntryPointEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.PseudostateExitPointEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.StateMachineCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.StateMachineNameEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLVisualIDRegistry;
import org.eclipse.swt.graphics.Color;

public class StateMachineEditPart
extends RoundedCompartmentEditPart {
    public static final String VISUAL_ID = "StateMachine_Shape";
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public StateMachineEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("CreationPolicy", (EditPolicy)new DefaultCreationEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DefaultSemanticEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new DefaultGraphicalNodeEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DragDropEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("Qualified_name_editpolicy", (EditPolicy)new QualifiedNameDisplayEditPolicy());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeNodeLabelDisplayEditPolicy());
        this.installEditPolicy("affixed node alignment editpolicy", (EditPolicy)new AffixedNodeAlignmentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new CustomStateMachineLayoutEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new CustomStateMachineDiagramDragDropEditPolicy());
        this.installEditPolicy("Show/Hide Compartment Policy", (EditPolicy)new ShowHideCompartmentEditPolicy());
        this.installEditPolicy("CreationPolicy", (EditPolicy)new SideAffixedNodesCreationEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result;
                block10: {
                    View childView = (View)child.getModel();
                    String vid = UMLVisualIDRegistry.getVisualID(childView);
                    if (vid == null) break block10;
                    switch (vid) {
                        case "Pseudostate_ExitPointShape": 
                        case "Pseudostate_EntryPointShape": {
                            return new BorderItemResizableEditPolicy();
                        }
                    }
                }
                if ((result = child.getEditPolicy((Object)"PrimaryDrag Policy")) == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new StateMachineFigure();
        return this.primaryShape;
    }

    public StateMachineFigure getPrimaryShape() {
        return (StateMachineFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof StateMachineNameEditPart) {
            ((StateMachineNameEditPart)childEditPart).setLabel((IFigure)this.getPrimaryShape().getNameLabel());
            return true;
        }
        if (childEditPart instanceof StateMachineCompartmentEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getStateMachineCompartmentFigure();
            this.setupContentPane((IFigure)pane);
            pane.add(((StateMachineCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof PseudostateEntryPointEditPart) {
            PortPositionLocator locator = new PortPositionLocator(this.getMainFigure(), 0);
            this.getBorderedFigure().getBorderItemContainer().add(((PseudostateEntryPointEditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        if (childEditPart instanceof PseudostateExitPointEditPart) {
            PortPositionLocator locator = new PortPositionLocator(this.getMainFigure(), 0);
            this.getBorderedFigure().getBorderItemContainer().add(((PseudostateExitPointEditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof StateMachineNameEditPart) {
            return true;
        }
        if (childEditPart instanceof StateMachineCompartmentEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getStateMachineCompartmentFigure();
            pane.remove(((StateMachineCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof PseudostateEntryPointEditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((PseudostateEntryPointEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof PseudostateExitPointEditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((PseudostateExitPointEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof StateMachineCompartmentEditPart) {
            return this.getPrimaryShape().getStateMachineCompartmentFigure();
        }
        if (editPart instanceof IBorderItemEditPart) {
            return this.getBorderedFigure().getBorderItemContainer();
        }
        return this.getContentPane();
    }

    protected NodeFigure createNodePlate() {
        RoundedRectangleNodePlateFigure result = new RoundedRectangleNodePlateFigure(200, 100);
        return result;
    }

    protected NodeFigure createMainFigure() {
        return new SelectableBorderedNodeFigure((IFigure)this.createMainFigureWithSVG());
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        super.setLineWidth(width);
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof IPapyrusNodeFigure) {
            ((IPapyrusNodeFigure)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType("StateMachine_NameLabel"));
    }
}

