/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.editor.internal.sessions;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.architecture.listeners.AbstractArchitectureDescriptionAdapter;
import org.eclipse.papyrus.infra.architecture.listeners.ArchitectureDescriptionAdapterUtils;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;
import org.eclipse.papyrus.sirius.editor.Activator;
import org.eclipse.papyrus.sirius.editor.internal.listeners.SiriusArchitectureDescriptionAdapter;
import org.eclipse.papyrus.sirius.editor.internal.runnables.RegisterSemanticResourceRunnable;
import org.eclipse.papyrus.sirius.editor.internal.runnables.UpdateSiriusViewpointRunnable;
import org.eclipse.papyrus.sirius.editor.internal.sessions.ISiriusSessionViewpointUpdater;
import org.eclipse.papyrus.sirius.editor.internal.sessions.PapyrusLocalSessionCreationOperation;
import org.eclipse.papyrus.sirius.editor.modelresource.SiriusDiagramModel;
import org.eclipse.papyrus.sirius.editor.representation.SiriusDiagramPrototype;
import org.eclipse.papyrus.sirius.editor.sirius.ISiriusSessionService;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.session.SessionTransientAttachment;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;

public class SessionService
implements ISiriusSessionService,
ISiriusSessionViewpointUpdater {
    private ServicesRegistry servicesRegistry;
    private ModelSet modelSet;
    private TransactionalEditingDomain editingDomain;
    private Session createdSession = null;
    private SiriusArchitectureDescriptionAdapter architectureListener;
    private Adapter semanticResourceListener;

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.servicesRegistry = servicesRegistry;
        if (this.servicesRegistry == null) {
            throw new ServiceException(NLS.bind((String)"The service {0} can't be initialized because the ServicesRegistry is not found", (Object)"org.eclipse.papyrus.sirius.editor.sirius.ISiriusSessionService"));
        }
    }

    public void startService() throws ServiceException {
        this.modelSet = this.getModelSet();
        this.editingDomain = this.getEditingDomain();
        if (this.modelSet == null || this.editingDomain == null) {
            throw new ServiceException(NLS.bind((String)"The service {0} can't start.", (Object)"org.eclipse.papyrus.sirius.editor.sirius.ISiriusSessionService"));
        }
        this.createdSession();
        this.architectureListener = new SiriusArchitectureDescriptionAdapter(this);
        ArchitectureDescriptionAdapterUtils.registerListener((ModelSet)this.modelSet, (AbstractArchitectureDescriptionAdapter)this.architectureListener);
    }

    public void disposeService() throws ServiceException {
        if (this.architectureListener != null) {
            ArchitectureDescriptionAdapterUtils.unregisterListener((ModelSet)this.modelSet, (AbstractArchitectureDescriptionAdapter)this.architectureListener);
        }
        this.servicesRegistry = null;
        this.editingDomain = null;
        this.modelSet = null;
        this.createdSession = null;
    }

    public Session getSiriusSession() {
        if (this.createdSession == null) {
            this.createdSession();
        }
        return this.createdSession;
    }

    private void createdSession() {
        if (this.servicesRegistry == null || this.modelSet == null || this.editingDomain == null) {
            return;
        }
        URI siriusFileResource = this.modelSet.getURIWithoutExtension();
        siriusFileResource = siriusFileResource.appendFileExtension("aird");
        this.saveNotationFile(this.modelSet);
        this.createdSession = this.createSiriusSession(siriusFileResource);
        SiriusDiagramModel siriusModel = (SiriusDiagramModel)this.modelSet.getModel("org.eclipse.papyrus.sirius.editor.DSemanticDiagram");
        Assert.isNotNull((Object)((Object)siriusModel), (String)NLS.bind((String)"We can't find the '{0}' class.", (Object)SiriusDiagramModel.class.getName()));
        siriusModel.setSiriusSession(this.createdSession);
        final Resource semanticResource = this.modelSet.getResource(this.getSemanticResourceURI(), false);
        if (semanticResource.getContents().size() != 0) {
            this.setSemanticResource();
            this.updateAppliedSiriusViewpoints();
            this.openSessions();
        } else {
            this.semanticResourceListener = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (3 == msg.getEventType() && msg.getNewValue() instanceof EObject) {
                        SessionService.this.setSemanticResource();
                        SessionService.this.updateAppliedSiriusViewpoints();
                        SessionService.this.openSessions();
                        semanticResource.eAdapters().remove((Object)SessionService.this.semanticResourceListener);
                    }
                }
            };
            semanticResource.eAdapters().add((Object)this.semanticResourceListener);
        }
    }

    private final TransactionalEditingDomain getEditingDomain() {
        try {
            return ServiceUtils.getInstance().getTransactionalEditingDomain((Object)this.servicesRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error("EditingDomain not found", (Throwable)e);
            return null;
        }
    }

    private final ModelSet getModelSet() {
        try {
            return (ModelSet)this.servicesRegistry.getService(ModelSet.class);
        }
        catch (ServiceException e) {
            Activator.log.error("ModelSet not found", (Throwable)e);
            return null;
        }
    }

    private final void saveNotationFile(ModelSet modelSet) {
        URI notationURi = modelSet.getURIWithoutExtension();
        notationURi = notationURi.appendFileExtension("notation");
        boolean exists = modelSet.getURIConverter().exists(notationURi, null);
        if (!exists) {
            try {
                modelSet.save((IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException e) {
                Activator.log.error("ModelSet can't be saved", (Throwable)e);
            }
        }
    }

    private Session createSiriusSession(URI siriusResourceURI) {
        PapyrusLocalSessionCreationOperation operation = new PapyrusLocalSessionCreationOperation(siriusResourceURI, (IProgressMonitor)new NullProgressMonitor(), this.editingDomain);
        try {
            operation.execute();
            return operation.getCreatedSession();
        }
        catch (CoreException e) {
            Activator.log.error(NLS.bind((String)"The resource {0} can't be created", (Object)siriusResourceURI), (Throwable)e);
            return null;
        }
    }

    @Override
    public void updateAppliedSiriusViewpoints() {
        if (this.getEditingDomain() == null) {
            return;
        }
        try {
            GMFUnsafe.write((TransactionalEditingDomain)this.getEditingDomain(), (Runnable)new UpdateSiriusViewpointRunnable(this.createdSession, this.modelSet));
        }
        catch (InterruptedException | RollbackException e) {
            Activator.log.error("Unexpected Error", e);
        }
    }

    public DiagramDescription getSiriusDiagramDescriptionFromPapyrusPrototype(SiriusDiagramPrototype siriusDiagramPrototype, EObject context) {
        if (this.getSiriusSession() == null || siriusDiagramPrototype == null || siriusDiagramPrototype.getDiagramDescription() == null) {
            return null;
        }
        URI descriptionURI = siriusDiagramPrototype.getDiagramDescription().eResource().getURI();
        if (descriptionURI == null) {
            return null;
        }
        Collection desc = DialectManager.INSTANCE.getAvailableRepresentationDescriptions(this.createdSession.getSelectedViewpoints(false), context);
        if (desc.isEmpty()) {
            this.updateAppliedSiriusViewpoints();
            desc = DialectManager.INSTANCE.getAvailableRepresentationDescriptions(this.createdSession.getSelectedViewpoints(false), context);
        }
        for (RepresentationDescription current : desc) {
            URI uri;
            if (!(current instanceof DiagramDescription) || current.eResource() == null || !descriptionURI.equals(uri = current.eResource().getURI())) continue;
            return (DiagramDescription)current;
        }
        return null;
    }

    private void setSemanticResource() {
        URI semanticResourceURI = this.getSemanticResourceURI();
        try {
            GMFUnsafe.write((TransactionalEditingDomain)this.editingDomain, (Runnable)new RegisterSemanticResourceRunnable(this.createdSession, semanticResourceURI));
        }
        catch (InterruptedException | RollbackException e) {
            Activator.log.error("We are not able to register the semantic resource into the Sirius Session", e);
        }
    }

    private URI getSemanticResourceURI() {
        UmlModel umlModel = (UmlModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
        return umlModel.getResourceURI();
    }

    public void openSessions() {
        IEditingSession uiSession;
        if (!this.createdSession.isOpen()) {
            this.createdSession.open((IProgressMonitor)new NullProgressMonitor());
        }
        if (this.createdSession != null && !(uiSession = SessionUIManager.INSTANCE.getOrCreateUISession(this.createdSession)).isOpen()) {
            uiSession.open();
        }
    }

    public void attachSession(EObject eobject) {
        boolean needToBeAttached = true;
        Iterator iter = eobject.eAdapters().iterator();
        while (needToBeAttached && iter.hasNext()) {
            Adapter tmp = (Adapter)iter.next();
            if (!(tmp instanceof SessionTransientAttachment) || ((SessionTransientAttachment)tmp).getSession() != this.createdSession) continue;
            needToBeAttached = false;
        }
        if (needToBeAttached) {
            eobject.eAdapters().add((Object)new SessionTransientAttachment(this.createdSession));
        }
    }
}

