/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox.java;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.Java2QVTTypeResolver;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaBlackboxMessages;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.NumberConversions;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtInterruptedExecutionException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtRuntimeException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.TransformationInstance;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.ocl.types.OCLStandardLibrary;

class JavaMethodHandlerFactory {
    private static int FAILURE_COUNT_TOLERANCE = 5;
    private final Object fInvalid;
    private final QvtOperationalModuleEnv fModuleEnv;

    JavaMethodHandlerFactory(QvtOperationalModuleEnv moduleEnv) {
        this.fInvalid = moduleEnv.getOCLStandardLibrary().getInvalid();
        this.fModuleEnv = moduleEnv;
    }

    @Deprecated
    JavaMethodHandlerFactory(OCLStandardLibrary<EClassifier> oclStdLib) {
        this.fInvalid = oclStdLib.getInvalid();
        this.fModuleEnv = null;
    }

    CallHandler createHandler(Method method) {
        if (method == null) {
            throw new IllegalArgumentException();
        }
        Operation opAnnotation = method.getAnnotation(Operation.class);
        return new Handler(method, opAnnotation != null && opAnnotation.contextual(), opAnnotation != null && opAnnotation.withExecutionContext());
    }

    private Object getInvalidResult() {
        return this.fInvalid;
    }

    private class Handler
    extends CallHandler {
        private final Method fMethod;
        private final Class<?>[] fCachedParamTypes;
        private final boolean fIsContextual;
        private final boolean fWithExecutionContext;
        private final boolean fRequiresNumConversion;
        private volatile int fFatalErrorCount;

        Handler(Method method, boolean isContextual, boolean isWithExecutionContext) {
            assert (method != null);
            this.fMethod = method;
            this.fCachedParamTypes = this.fMethod.getParameterTypes();
            this.fIsContextual = isContextual;
            this.fWithExecutionContext = isWithExecutionContext;
            this.fRequiresNumConversion = this.requiresNumberConversion();
            this.fFatalErrorCount = 0;
        }

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            try {
                if (this.isDisabled()) {
                    return JavaMethodHandlerFactory.this.getInvalidResult();
                }
                Object[] actualArgs = this.prepareArguments(source, args, evalEnv);
                Object javaCallSource = null;
                boolean isStatic = Modifier.isStatic(this.fMethod.getModifiers());
                if (!isStatic) {
                    Class<?> moduleJavaClass = this.fMethod.getDeclaringClass();
                    javaCallSource = this.getJavaCallSource(module, moduleJavaClass, evalEnv);
                    assert (javaCallSource != null);
                }
                return this.fMethod.invoke(javaCallSource, actualArgs);
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                if (t instanceof OperationCanceledException) {
                    throw new QvtInterruptedExecutionException();
                }
                this.incrementFatalErrorCount();
                QvtPlugin.error(NLS.bind(JavaBlackboxMessages.MethodInvocationError, this.fMethod), t);
                String localized = "\nCaused by: " + t.getClass().getName() + (t.getLocalizedMessage() == null ? "" : ": " + t.getLocalizedMessage());
                evalEnv.getAdapter(InternalEvaluationEnv.class).throwQVTException(new QvtRuntimeException(String.valueOf(NLS.bind(JavaBlackboxMessages.MethodInvocationError, this.fMethod)) + localized, t));
                return CallHandlerAdapter.getInvalidResult(evalEnv);
            }
        }

        private void incrementFatalErrorCount() {
            ++this.fFatalErrorCount;
        }

        private Object getJavaCallSource(ModuleInstance moduleInstance, Class<?> javaClass, QvtOperationalEvaluationEnv evalEnv) throws IllegalAccessException, InstantiationException {
            Object callSource = moduleInstance.getAdapter(javaClass);
            if (callSource != null) {
                return callSource;
            }
            TransformationInstance rootTransformation = evalEnv.getRoot().getAdapter(InternalEvaluationEnv.class).getCurrentTransformation();
            callSource = rootTransformation.getAdapter(javaClass);
            if (callSource == null) {
                callSource = javaClass.newInstance();
                rootTransformation.getAdapter(ModuleInstance.Internal.class).addAdapter(callSource);
            }
            moduleInstance.getAdapter(ModuleInstance.Internal.class).addAdapter(callSource);
            return callSource;
        }

        private boolean isDisabled() {
            return this.fFatalErrorCount > FAILURE_COUNT_TOLERANCE;
        }

        private Object[] prepareArguments(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            int argCount = args.length;
            if (this.fIsContextual) {
                ++argCount;
            }
            if (this.fWithExecutionContext) {
                ++argCount;
            }
            Object[] resultArgs = new Object[argCount];
            int argIndex = 0;
            if (this.fWithExecutionContext) {
                resultArgs[argIndex] = evalEnv.getContext();
                ++argIndex;
            }
            if (this.fIsContextual) {
                EObject eObject;
                if (source instanceof EObject && EmfUtil.isDynamic((EObject)(eObject = (EObject)source)) && !this.fCachedParamTypes[argIndex].isAssignableFrom(eObject.getClass()) && this.fCachedParamTypes[argIndex].isInterface()) {
                    source = this.convertEObjectToProxy(eObject, this.fCachedParamTypes[argIndex]);
                }
                resultArgs[argIndex] = source;
                ++argIndex;
            }
            int i = 0;
            while (i < args.length) {
                EObject eObject;
                Object nextArg = args[i];
                if (nextArg == JavaMethodHandlerFactory.this.getInvalidResult()) {
                    nextArg = null;
                }
                if (this.fRequiresNumConversion) {
                    nextArg = NumberConversions.convertNumber(nextArg, this.fCachedParamTypes[argIndex]);
                }
                if (nextArg instanceof EObject && EmfUtil.isDynamic((EObject)(eObject = (EObject)nextArg)) && !this.fCachedParamTypes[argIndex].isAssignableFrom(eObject.getClass()) && this.fCachedParamTypes[argIndex].isInterface()) {
                    nextArg = this.convertEObjectToProxy(eObject, this.fCachedParamTypes[argIndex]);
                }
                resultArgs[argIndex++] = nextArg;
                ++i;
            }
            return resultArgs;
        }

        private boolean requiresNumberConversion() {
            assert (this.fMethod != null);
            Class<?>[] classArray = this.fMethod.getParameterTypes();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> paramType = classArray[n2];
                if (Number.class.isAssignableFrom(paramType)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private Object convertEObjectToProxy(final EObject eObject, Class<?> proxyClass) {
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
                    EList operations = eObject.eClass().getEAllOperations();
                    for (EOperation operation : operations) {
                        if (!Handler.this.isMatch(method, operation)) continue;
                        return eObject.eInvoke(operation, (EList)(args == null ? ECollections.newBasicEList() : ECollections.newBasicEList((Object[])args)));
                    }
                    EList features = eObject.eClass().getEAllStructuralFeatures();
                    for (EStructuralFeature feature : features) {
                        if (method.getName().equalsIgnoreCase("get" + feature.getName())) {
                            return eObject.eGet(feature);
                        }
                        if (!method.getName().equalsIgnoreCase("set" + feature.getName())) continue;
                        BasicEList newValue = feature.isMany() ? ECollections.newBasicEList((Object[])args) : (args.length > 0 ? args[0] : null);
                        eObject.eSet(feature, (Object)newValue);
                        return null;
                    }
                    return method.invoke((Object)eObject, args);
                }
            };
            return Proxy.newProxyInstance(proxyClass.getClassLoader(), new Class[]{proxyClass}, handler);
        }

        private boolean isMatch(Method method, EOperation operation) {
            EClassifier eClassifier;
            Java2QVTTypeResolver typeResolver;
            List<String> nsURIs;
            if (!operation.getName().equals(method.getName())) {
                return false;
            }
            EClassifier eType = (EClassifier)JavaMethodHandlerFactory.this.fModuleEnv.getUMLReflection().getOCLType((Object)operation.getEType());
            if (eType != null) {
                nsURIs = Collections.singletonList(eType.getEPackage().getNsURI());
                typeResolver = new Java2QVTTypeResolver(JavaMethodHandlerFactory.this.fModuleEnv, nsURIs, new BasicDiagnostic());
                eClassifier = typeResolver.toEClassifier(method.getGenericReturnType(), 1);
                if (eClassifier != eType) {
                    return false;
                }
            }
            List<Class<?>> parameterTypes = Arrays.asList(method.getParameterTypes());
            EList eParameters = operation.getEParameters();
            if (parameterTypes.size() != eParameters.size()) {
                return false;
            }
            Iterator<Class<?>> paramTypesIterator = parameterTypes.iterator();
            for (EParameter param : eParameters) {
                eType = (EClassifier)JavaMethodHandlerFactory.this.fModuleEnv.getUMLReflection().getOCLType((Object)param.getEType());
                nsURIs = Collections.singletonList(eType.getEPackage().getNsURI());
                Class<?> parameterType = paramTypesIterator.next();
                typeResolver = new Java2QVTTypeResolver(JavaMethodHandlerFactory.this.fModuleEnv, nsURIs, new BasicDiagnostic());
                eClassifier = typeResolver.toEClassifier(parameterType, 1);
                if (eClassifier == eType) continue;
                return false;
            }
            return true;
        }
    }
}

