/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.net4j.util.om.monitor.SubProgressMonitor;
import org.eclipse.net4j.util.ui.actions.LongRunningAction;
import org.eclipse.ui.IWorkbenchPage;

public abstract class TransactionalBackgroundAction
extends LongRunningAction {
    private final CDOObject object;

    public TransactionalBackgroundAction(IWorkbenchPage page, String text, String toolTipText, ImageDescriptor image, CDOObject object) {
        super(page, text, toolTipText, image);
        this.object = object;
    }

    public final CDOObject getObject() {
        return this.object;
    }

    protected CDOTransaction openTransaction(CDOObject object) {
        CDOView view = object.cdoView();
        CDOSession session = view.getSession();
        CDOBranch branch = view.getBranch();
        CDOTransaction transaction = session.openTransaction(branch);
        this.configureTransaction(transaction);
        return transaction;
    }

    protected void configureTransaction(CDOTransaction transaction) {
        CDOUtil.configureView((CDOView)transaction);
    }

    protected final void doRun(IProgressMonitor progressMonitor) throws Exception {
        progressMonitor.beginTask(Messages.getString("TransactionalBackgroundAction_1"), 100);
        CDOTransaction transaction = this.openTransaction(this.object);
        CDOObject transactionalObject = null;
        CDOCommitInfo commitInfo = null;
        try {
            transactionalObject = (CDOObject)transaction.getObject((EObject)this.object);
            progressMonitor.worked(5);
            this.doRun(transaction, transactionalObject, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
            commitInfo = transaction.commit((IProgressMonitor)new SubProgressMonitor(progressMonitor, 80));
        }
        finally {
            progressMonitor.done();
            transaction.close();
            transactionalObject = null;
        }
        if (commitInfo != null) {
            CDOView view = this.object.cdoView();
            view.waitForUpdate(commitInfo.getTimeStamp(), 5000L);
            this.postRun(view, this.object, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
        }
    }

    protected abstract void doRun(CDOTransaction var1, CDOObject var2, IProgressMonitor var3) throws Exception;

    protected void postRun(CDOView view, CDOObject object, IProgressMonitor progressMonitor) {
        this.postRun(view, object);
    }

    protected void postRun(CDOView view, CDOObject object) {
    }
}

