/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutContentProvider;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.NewWizardPage;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public abstract class NewWizard
extends Wizard
implements INewWizard {
    private final String resourceType;
    private final String title;
    private IStructuredSelection selection;
    private CDOCheckoutContentProvider contentProvider;
    private NewWizardPage page;

    protected NewWizard(String resourceType, String title) {
        this.resourceType = resourceType;
        this.title = title;
    }

    public void setContentProvider(CDOCheckoutContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public final String getResourceType() {
        return this.resourceType;
    }

    public final String getTitle() {
        return this.title;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        this.page = new NewWizardPage(this.resourceType, this.title, this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean canFinish() {
        return this.page.getNodeInfo() != null && super.canFinish();
    }

    public boolean performFinish() {
        Pair<CDOCheckout, CDOResourceNode> parentInfo = this.page.getNodeInfo();
        String name = this.page.getName();
        String error = "An error occured while creating the " + this.title.toLowerCase() + ".";
        Job.create((String)this.title, monitor -> {
            CDOResourceNode newResourceNode = this.createNewResourceNode();
            newResourceNode.setName(name);
            CDOCheckout checkout = (CDOCheckout)parentInfo.getElement1();
            CDOResourceNode parentNode = (CDOResourceNode)parentInfo.getElement2();
            CDOTransaction transaction = checkout.openTransaction();
            CDOCommitInfo commitInfo = null;
            CDOID newID = null;
            try {
                try {
                    CDOResourceNode txParent = (CDOResourceNode)transaction.getObject((EObject)parentNode);
                    if (txParent instanceof CDOResourceFolder) {
                        InternalEList nodes = (InternalEList)((CDOResourceFolder)txParent).getNodes();
                        nodes.addUnique((Object)newResourceNode);
                    } else {
                        InternalEList contents = (InternalEList)transaction.getRootResource().getContents();
                        contents.addUnique((Object)newResourceNode);
                    }
                    commitInfo = transaction.commit();
                    newID = newResourceNode.cdoID();
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                    Status status = new Status(4, "org.eclipse.emf.cdo.explorer.ui", ex.getMessage(), (Throwable)ex);
                    UIUtil.asyncExec(() -> this.lambda$1(error, (IStatus)status));
                    IStatus iStatus = Status.OK_STATUS;
                    transaction.close();
                    return iStatus;
                }
            }
            finally {
                transaction.close();
            }
            if (commitInfo != null) {
                CDOView view = checkout.getView();
                if (!view.waitForUpdate(commitInfo.getTimeStamp(), 10000L)) {
                    OM.LOG.error(String.valueOf(error) + " Did not receive an update");
                    return Status.OK_STATUS;
                }
                CDOObject newObject = view.getObject(newID);
                if (this.contentProvider != null) {
                    this.contentProvider.selectObjects(newObject);
                } else {
                    CDOCheckoutContentProvider.forEachInstance(cp -> cp.selectObjects(newObject));
                }
            }
            return Status.OK_STATUS;
        }).schedule();
        return true;
    }

    protected abstract CDOResourceNode createNewResourceNode();

    private /* synthetic */ void lambda$1(String string, IStatus iStatus) {
        int n = ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)string, (IStatus)iStatus);
    }
}

