/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buffer;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.buffer.IBufferHandler;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class BufferOutputStream
extends OutputStream {
    public static final boolean DEFAULT_PROPAGATE_CLOSE = false;
    private static final boolean DISABLE_BULK_WRITE = Boolean.getBoolean("org.eclipse.net4j.buffer.BufferOutputStream.disableBulkWrite");
    private final IBufferProvider bufferProvider;
    private final IBufferHandler bufferHandler;
    private IBuffer currentBuffer;
    private short channelID;
    private Throwable error;

    public BufferOutputStream(IBufferHandler bufferHandler, IBufferProvider bufferProvider, short channelID) {
        if (bufferHandler == null) {
            throw new IllegalArgumentException("bufferHandler == null");
        }
        if (bufferProvider == null) {
            throw new IllegalArgumentException("bufferProvider == null");
        }
        this.bufferHandler = bufferHandler;
        this.bufferProvider = bufferProvider;
        this.channelID = channelID;
    }

    public BufferOutputStream(IBufferHandler bufferHandler, short channelID) {
        this(bufferHandler, BufferOutputStream.extractBufferProvider(bufferHandler), channelID);
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    @Override
    public void write(int b) throws IOException {
        this.throwExceptionOnError();
        this.flushIfFilled();
        this.ensureBufferPrivate();
        this.currentBuffer.put((byte)(b &= 0xFF));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (BufferOutputStream.DISABLE_BULK_WRITE) {
            super.write(b, off, len);
            return;
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off >= 0 && off <= b.length && len >= 0 && off + len <= b.length && off + len >= 0) ** GOTO lbl16
        throw new IndexOutOfBoundsException();
lbl-1000:
        // 1 sources

        {
            this.throwExceptionOnError();
            this.flushIfFilled();
            this.ensureBufferPrivate();
            byteBuffer = this.currentBuffer.getByteBuffer();
            bytesToPut = Math.min(len, byteBuffer.remaining());
            this.currentBuffer.put(b, off, bytesToPut);
            off += bytesToPut;
            len -= bytesToPut;
lbl16:
            // 2 sources

            ** while (len > 0)
        }
lbl17:
        // 1 sources

    }

    @Override
    public void flush() throws IOException {
        this.flushPrivate();
    }

    private void flushIfFilled() throws IOException {
        if (this.currentBuffer != null && !this.currentBuffer.hasRemaining()) {
            this.flushPrivate();
        }
    }

    private void flushPrivate() {
        if (this.currentBuffer != null) {
            this.bufferHandler.handleBuffer(this.currentBuffer);
            this.currentBuffer = null;
        }
    }

    public void flushWithEOS() throws IOException {
        this.flushWithEOS(false);
    }

    public void flushWithEOS(boolean ccam) throws IOException {
        this.throwExceptionOnError();
        this.ensureBufferPrivate();
        this.currentBuffer.setEOS(true);
        this.currentBuffer.setCCAM(ccam);
        this.flushPrivate();
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.isPropagateClose()) {
                LifecycleUtil.deactivate((Object)this.bufferHandler);
            }
        }
        finally {
            this.currentBuffer = null;
            super.close();
        }
    }

    public String toString() {
        return "BufferOutputStream";
    }

    protected void ensureBuffer() throws IOException {
        this.ensureBufferPrivate();
    }

    private void ensureBufferPrivate() {
        if (this.currentBuffer == null) {
            this.currentBuffer = this.bufferProvider.provideBuffer();
            this.currentBuffer.setErrorHandler(throwable -> this.setError(throwable));
            this.currentBuffer.startPutting(this.channelID);
        }
    }

    private void throwExceptionOnError() throws IOException {
        if (this.error != null) {
            if (this.error instanceof IOException) {
                throw (IOException)this.error;
            }
            if (this.error instanceof RuntimeException) {
                throw (RuntimeException)this.error;
            }
            throw new IORuntimeException(this.error);
        }
    }

    protected boolean isPropagateClose() {
        return false;
    }

    private static IBufferProvider extractBufferProvider(IBufferHandler bufferHandler) {
        if (bufferHandler instanceof IBufferProvider) {
            return (IBufferProvider)((Object)bufferHandler);
        }
        throw new IllegalArgumentException("Buffer handler unable to provide buffers");
    }
}

