/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.common.IContributionClassCreator;
import org.eclipse.e4.tools.emf.ui.internal.common.ModelEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs.FindContributionDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs.UriDialog;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class BundleClassDialog
extends Dialog
implements UriDialog {
    private Text txtUri;
    private Text txtBundle;
    private Text txtClass;
    private Text txtPackage;
    public String uri = "";
    private String bundle = "";
    private String clazz = "";
    private String pakage = "";
    protected boolean ignoreModify;
    private final IEclipseContext context;
    static Pattern patternBundleClass = Pattern.compile("bundleclass:/*([^/]+)/((.*)\\.)?([^\\.]+)");

    public BundleClassDialog(Shell parentShell, IEclipseContext context) {
        super(parentShell);
        this.context = context;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.BundleClassDialog_bundleClassEditor);
        super.configureShell(newShell);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        ToolBar toolBar = new ToolBar(composite, 524288);
        toolBar.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Label lbl = new Label(composite, 0);
        lbl.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        lbl.setText(Messages.BundleClassDialog_uri);
        this.txtUri = new Text(composite, 18436);
        this.txtUri.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtUri.setText("bundleclass://");
        this.txtUri.addModifyListener(e -> {
            if (this.ignoreModify) {
                return;
            }
            this.ignoreModify = true;
            this.setUri(this.txtUri.getText());
            this.txtBundle.setText(this.bundle);
            this.txtPackage.setText(this.pakage);
            this.txtClass.setText(this.clazz);
            this.ignoreModify = false;
            parent.pack();
        });
        ModifyListener listener = e -> {
            if (this.ignoreModify) {
                return;
            }
            this.ignoreModify = true;
            String prefix = "bundleclass://";
            this.setUri(prefix + this.txtBundle.getText() + "/" + this.txtPackage.getText() + "." + this.txtClass.getText());
            this.txtUri.setText(this.getUri());
            this.ignoreModify = false;
        };
        Link lbl2 = new Link(composite, 0);
        lbl2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        lbl2.setText("<A>" + Messages.BundleClassDialog_bundle + "</A>");
        this.txtBundle = new Text(composite, 18436);
        this.txtBundle.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtBundle.addModifyListener(listener);
        lbl2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String uri;
                Matcher matcher;
                IEclipseContext childCtx = BundleClassDialog.this.context.createChild();
                childCtx.set(Bundle.class, (Object)FrameworkUtil.getBundle(FindContributionDialog.class));
                childCtx.set("bundle", (Object)BundleClassDialog.this.getBundle());
                childCtx.set("package", (Object)BundleClassDialog.this.getPackage());
                childCtx.set("mode", (Object)"show-bundles");
                FindContributionDialog dlg = new FindContributionDialog(childCtx);
                if (dlg.open() == 0 && (matcher = BundleClassDialog.this.getMatcher(uri = BundleClassDialog.this.getUri(dlg))).matches()) {
                    BundleClassDialog.this.txtBundle.setText(matcher.group(1));
                }
            }
        });
        lbl2 = new Link(composite, 0);
        lbl2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        lbl2.setText("<A>" + Messages.BundleClassDialog_package + "</A>");
        this.txtPackage = new Text(composite, 18436);
        this.txtPackage.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtPackage.addModifyListener(listener);
        lbl2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String uri;
                Matcher matcher;
                IEclipseContext childCtx = BundleClassDialog.this.context.createChild();
                childCtx.set(Bundle.class, (Object)FrameworkUtil.getBundle(FindContributionDialog.class));
                childCtx.set("bundle", (Object)BundleClassDialog.this.getBundle());
                childCtx.set("package", (Object)BundleClassDialog.this.getPackage());
                childCtx.set("mode", (Object)"show-packages");
                FindContributionDialog dlg = new FindContributionDialog(childCtx);
                if (dlg.open() == 0 && (matcher = BundleClassDialog.this.getMatcher(uri = BundleClassDialog.this.getUri(dlg))).matches()) {
                    BundleClassDialog.this.txtPackage.setText(matcher.group(3));
                }
            }
        });
        lbl2 = new Link(composite, 0);
        lbl2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        lbl2.setText("<A>" + Messages.BundleClassDialog_class + "</A>");
        this.txtClass = new Text(composite, 18436);
        this.txtClass.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtClass.addModifyListener(listener);
        lbl2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IEclipseContext childCtx = BundleClassDialog.this.context.createChild();
                childCtx.set(Bundle.class, (Object)FrameworkUtil.getBundle(FindContributionDialog.class));
                childCtx.set("bundle", (Object)BundleClassDialog.this.getBundle());
                childCtx.set("package", (Object)BundleClassDialog.this.getPackage());
                FindContributionDialog dlg = new FindContributionDialog(childCtx);
                if (dlg.open() == 0) {
                    BundleClassDialog.this.txtUri.setText(BundleClassDialog.this.getUri(dlg));
                }
            }
        });
        ToolItem btnGo = new ToolItem(toolBar, 8);
        btnGo.setText(Messages.BundleClassDialog_create_goto);
        btnGo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    MPart dummyPart = MBasicFactory.INSTANCE.createPart();
                    dummyPart.setContributionURI(BundleClassDialog.this.getUri());
                    IContributionClassCreator c = ((ModelEditor)BundleClassDialog.this.context.get(ModelEditor.class)).getContributionCreator(BasicPackageImpl.Literals.PART);
                    c.createOpen((MContribution)dummyPart, (EditingDomain)BundleClassDialog.this.context.get(EditingDomain.class), (IProject)BundleClassDialog.this.context.get(IProject.class), BundleClassDialog.this.getShell());
                    BundleClassDialog.this.setUri(dummyPart.getContributionURI());
                    BundleClassDialog.this.okPressed();
                }
                catch (Exception exception) {}
            }
        });
        ToolItem btnFind = new ToolItem(toolBar, 8);
        btnFind.setText(Messages.BundleClassDialog_find + "...");
        btnFind.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IEclipseContext childCtx = BundleClassDialog.this.context.createChild();
                childCtx.set(Bundle.class, (Object)FrameworkUtil.getBundle(FindContributionDialog.class));
                FindContributionDialog dialog = new FindContributionDialog(childCtx);
                if (dialog.open() == 0) {
                    BundleClassDialog.this.txtUri.setText(BundleClassDialog.this.getUri(dialog));
                }
            }
        });
        ToolItem btnRemove = new ToolItem(toolBar, 8);
        btnRemove.setText("Remove");
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BundleClassDialog.this.txtUri.setText("");
                BundleClassDialog.this.close();
            }
        });
        this.txtUri.setText(this.uri);
        this.txtBundle.setText(this.bundle);
        this.txtClass.setText(this.clazz);
        return composite;
    }

    protected String getUri(FindContributionDialog dlg) {
        return dlg.getBundleclassUri();
    }

    @Override
    public int open() {
        int ret = super.open();
        return ret;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public void setUri(String uri) {
        this.uri = uri == null ? "" : uri.toString();
        Matcher matcher = this.getMatcher(this.uri);
        if (matcher.matches()) {
            this.bundle = matcher.group(1);
            this.pakage = matcher.group(3);
            if (this.pakage == null) {
                this.pakage = "";
            }
            this.clazz = matcher.group(4);
        } else {
            this.bundle = "";
            this.pakage = "";
            this.clazz = "";
        }
    }

    protected String getBundle() {
        return this.bundle;
    }

    protected void setBundle(String bundle) {
        this.bundle = bundle;
    }

    protected String getClazz() {
        return this.clazz;
    }

    protected void setClazz(String clazz) {
        this.clazz = clazz;
    }

    protected String getPackage() {
        return this.pakage;
    }

    protected void setPackage(String pakage) {
        this.pakage = pakage;
    }

    private Matcher getMatcher(String uri) {
        return patternBundleClass.matcher(uri);
    }
}

