/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.uml2.common.util.UnionEObjectEList;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.internal.operations.ClassifierOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationOperations
extends ClassifierOperations {
    protected AssociationOperations() {
    }

    public static boolean validateSpecializedEndNumber(Association association, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        int memberEndsSize = association.getMemberEnds().size();
        for (Classifier general : association.getGenerals()) {
            if (!(general instanceof Association) || ((Association)general).getMemberEnds().size() == memberEndsSize) continue;
            result = false;
            if (diagnostics == null) continue;
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 37, UMLPlugin.INSTANCE.getString("_UI_Association_SpecializedEndNumber_diagnostic", AssociationOperations.getMessageSubstitutions(context, (Object)association, (Object)general)), new Object[]{association}));
        }
        return result;
    }

    public static boolean validateSpecializedEndTypes(Association association, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        EList<Property> memberEnds = association.getMemberEnds();
        block0: for (Classifier general : association.getGenerals()) {
            if (!(general instanceof Association)) continue;
            EList<Property> generalMemberEnds = ((Association)general).getMemberEnds();
            int i = 0;
            while (i < memberEnds.size() && i < generalMemberEnds.size()) {
                Type memberEndType = ((Property)memberEnds.get(i)).getType();
                Type generalMemberEndType = ((Property)generalMemberEnds.get(i)).getType();
                if (memberEndType != null && generalMemberEndType != null && !memberEndType.conformsTo(generalMemberEndType)) {
                    result = false;
                    if (diagnostics == null) continue block0;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 38, UMLPlugin.INSTANCE.getString("_UI_Association_SpecializedEndTypes_diagnostic", AssociationOperations.getMessageSubstitutions(context, (Object)association, (Object)general)), new Object[]{association}));
                    continue block0;
                }
                ++i;
            }
        }
        return result;
    }

    public static boolean validateBinaryAssociations(Association association, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateAssociationEnds(Association association, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateEndsMustBeTyped(Association association, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean isBinary(Association association) {
        return association.getMemberEnds().size() == 2;
    }

    public static EList<Type> getEndTypes(Association association) {
        UniqueEList.FastCompare endTypes = new UniqueEList.FastCompare();
        for (Property memberEnd : association.getMemberEnds()) {
            Type endType = (Type)memberEnd.eGet((EStructuralFeature)UMLPackage.Literals.TYPED_ELEMENT__TYPE, false);
            if (endType == null) continue;
            endTypes.add((Object)endType);
        }
        return new UnionEObjectEList((InternalEObject)association, (EStructuralFeature)UMLPackage.Literals.ASSOCIATION__END_TYPE, endTypes.size(), endTypes.toArray());
    }
}

