/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class DependencyManager {
    private DependencyManager() {
    }

    public static Set<BundleDescription> getSelfAndDependencies(Collection<IPluginModelBase> plugins) {
        Collection<NameVersionDescriptor> implicit = DependencyManager.getImplicitDependencies();
        List<BundleDescription> bundles = DependencyManager.mergeBundleDescriptions(plugins, implicit, TargetPlatformHelper.getState());
        return DependencyManager.findRequirementsClosure(bundles, Options.INCLUDE_OPTIONAL_DEPENDENCIES, Options.INCLUDE_ALL_FRAGMENTS);
    }

    public static Set<BundleDescription> getDependencies(Collection<IPluginModelBase> plugins, Collection<NameVersionDescriptor> implicit, State state, Options ... options) {
        List<BundleDescription> bundles = DependencyManager.mergeBundleDescriptions(plugins, implicit, state);
        Set<BundleDescription> closure = DependencyManager.findRequirementsClosure(bundles, options);
        plugins.forEach(p -> {
            boolean bl = closure.remove(p.getBundleDescription());
        });
        return closure;
    }

    public static Set<BundleDescription> getDependencies(Collection<IPluginModelBase> plugins, Options ... options) {
        return DependencyManager.getDependencies(plugins, DependencyManager.getImplicitDependencies(), TargetPlatformHelper.getState(), options);
    }

    /*
     * WARNING - void declaration
     */
    public static Set<BundleDescription> findRequirementsClosure(Collection<BundleDescription> bundles, Options ... options) {
        Set<Options> optionSet = Set.of(options);
        boolean includeOptional = optionSet.contains((Object)Options.INCLUDE_OPTIONAL_DEPENDENCIES);
        boolean includeAllFragments = optionSet.contains((Object)Options.INCLUDE_ALL_FRAGMENTS);
        boolean includeNonTestFragments = optionSet.contains((Object)Options.INCLUDE_NON_TEST_FRAGMENTS);
        if (includeAllFragments && includeNonTestFragments) {
            throw new AssertionError((Object)"Cannot combine INCLUDE_ALL_FRAGMENTS and INCLUDE_NON_TEST_FRAGMENTS");
        }
        HashSet<BundleDescription> closure = new HashSet<BundleDescription>(bundles.size() * 4 / 3 + 1);
        ArrayDeque<BundleDescription> pending = new ArrayDeque<BundleDescription>(bundles.size());
        for (BundleDescription bundle : bundles) {
            DependencyManager.addNewRequiredBundle(bundle, closure, pending);
        }
        while (!pending.isEmpty()) {
            BundleDescription bundle;
            bundle = (BundleDescription)pending.remove();
            BundleWiring wiring = bundle.getWiring();
            if (wiring == null || !wiring.isInUse()) continue;
            if (includeAllFragments || includeNonTestFragments) {
                BundleDescription[] bundleDescriptionArray = bundle.getFragments();
                int n = bundleDescriptionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BundleDescription fragment = bundleDescriptionArray[n2];
                    if (includeAllFragments || !DependencyManager.isTestWorkspaceProject(fragment)) {
                        DependencyManager.addNewRequiredBundle(fragment, closure, pending);
                    }
                    ++n2;
                }
            }
            List requiredWires = wiring.getRequiredWires(null);
            for (BundleWire wire : requiredWires) {
                void requiredBundle;
                BundleRevision provider;
                BundleRevision bundleRevision;
                BundleRevision declaringBundle = wire.getRequirement().getRevision();
                if (declaringBundle != bundle && !closure.contains(declaringBundle) || !((bundleRevision = (provider = wire.getCapability().getRevision())) instanceof BundleDescription)) continue;
                BundleDescription cfr_ignored_0 = (BundleDescription)bundleRevision;
                BundleDescription cfr_ignored_1 = (BundleDescription)bundleRevision;
                if (!includeOptional && DependencyManager.isOptional(wire.getRequirement())) continue;
                DependencyManager.addNewRequiredBundle((BundleDescription)requiredBundle, closure, pending);
            }
        }
        return closure;
    }

    private static void addNewRequiredBundle(BundleDescription bundle, Set<BundleDescription> requiredBundles, Queue<BundleDescription> pending) {
        if (bundle != null && bundle.isResolved() && !bundle.isRemovalPending() && requiredBundles.add(bundle)) {
            pending.add(bundle);
        }
    }

    private static boolean isOptional(BundleRequirement requirement) {
        return "optional".equals(requirement.getDirectives().get("resolution"));
    }

    private static boolean isTestWorkspaceProject(BundleDescription f) {
        IResource resource;
        IPluginModelBase pluginModel = PluginRegistry.findModel(f);
        if (pluginModel != null && (resource = pluginModel.getUnderlyingResource()) != null) {
            return ClasspathComputer.hasTestOnlyClasspath(resource.getProject());
        }
        return false;
    }

    private static Collection<NameVersionDescriptor> getImplicitDependencies() {
        try {
            NameVersionDescriptor[] implicit;
            ITargetPlatformService service = PDECore.getDefault().acquireService(ITargetPlatformService.class);
            if (service != null && (implicit = service.getWorkspaceTargetDefinition().getImplicitDependencies()) != null) {
                return Arrays.asList(implicit);
            }
        }
        catch (CoreException e) {
            PDECore.log(e);
        }
        return Collections.emptyList();
    }

    private static List<BundleDescription> mergeBundleDescriptions(Collection<IPluginModelBase> plugins, Collection<NameVersionDescriptor> descriptors, State state) {
        ArrayList<BundleDescription> bundles = new ArrayList<BundleDescription>();
        for (IPluginModelBase plugin : plugins) {
            if (plugin == null) continue;
            bundles.add(plugin.getBundleDescription());
        }
        for (NameVersionDescriptor descriptor : descriptors) {
            String versionStr = descriptor.getVersion();
            Version version = versionStr != null ? Version.parseVersion((String)versionStr) : null;
            BundleDescription bundle = state.getBundle(descriptor.getId(), version);
            bundles.add(bundle);
        }
        return bundles;
    }

    public static enum Options {
        INCLUDE_OPTIONAL_DEPENDENCIES,
        INCLUDE_ALL_FRAGMENTS,
        INCLUDE_NON_TEST_FRAGMENTS;

    }
}

