/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.pde.core.IClasspathContributor;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.PDEClasspathContainer;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.bnd.BndProjectManager;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;

public class RequiredPluginsClasspathContainer
extends PDEClasspathContainer
implements IClasspathContainer {
    private static final Set<String> JUNIT5_RUNTIME_PLUGINS = Set.of("org.junit", "junit-jupiter-engine", "org.junit.jupiter.engine");
    private static final Set<String> JUNIT5_API_PLUGINS = Set.of("junit-jupiter-api", "org.junit.jupiter.api");
    private final IPluginModelBase fModel;
    private IBuild fBuild;
    private List<BundleDescription> junit5RuntimeClosure;
    private IClasspathEntry[] fEntries;
    private boolean addImportedPackages;
    private static List<IClasspathContributor> fClasspathContributors = null;
    private final IProject project;

    public RequiredPluginsClasspathContainer(IPluginModelBase model, IProject project) {
        this(model, null, project);
    }

    public RequiredPluginsClasspathContainer(IPluginModelBase model, IBuild build, IProject project) {
        this.fModel = model;
        this.fBuild = build;
        this.project = project;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return PDECore.REQUIRED_PLUGINS_CONTAINER_PATH;
    }

    public String getDescription() {
        return PDECoreMessages.RequiredPluginsClasspathContainer_description;
    }

    public IClasspathEntry[] getClasspathEntries() {
        if (this.fEntries == null) {
            this.fEntries = this.fModel == null ? this.computePluginEntriesByProject() : (IClasspathEntry[])this.computePluginEntriesByModel().toArray(IClasspathEntry[]::new);
            if (PDECore.DEBUG_CLASSPATH) {
                System.out.println("Dependencies for plugin '" + this.fModel.getPluginBase().getId() + "':");
                IClasspathEntry[] iClasspathEntryArray = this.fEntries;
                int n = this.fEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    System.out.println("\t" + String.valueOf(entry));
                    ++n2;
                }
            }
        }
        return this.fEntries;
    }

    private IClasspathEntry[] computePluginEntriesByProject() {
        try {
            Optional<Project> bndProject = BndProjectManager.getBndProject(this.project);
            if (bndProject.isPresent()) {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Project bnd = bndProject.get();){
                    IClasspathEntry[] entries = (IClasspathEntry[])BndProjectManager.getClasspathEntries(bnd, this.project.getWorkspace().getRoot()).toArray(IClasspathEntry[]::new);
                    for (String err : bnd.getErrors()) {
                        System.out.println("ERR: " + err);
                    }
                    for (String warn : bnd.getWarnings()) {
                        System.out.println("WARN: " + warn);
                    }
                    return entries;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (Exception e) {
            PDECore.getDefault().getLog().error("Can't compute classpath!", (Throwable)e);
        }
        if (PDECore.DEBUG_CLASSPATH) {
            System.out.println("********Returned an empty container");
        }
        return new IClasspathEntry[0];
    }

    private List<IClasspathEntry> computePluginEntriesByModel() {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        try {
            int n;
            int n2;
            BundleDescription[] bundleDescriptionArray;
            BundleDescription desc = this.fModel.getBundleDescription();
            if (desc == null) {
                return List.of();
            }
            Map<BundleDescription, List<PDEClasspathContainer.Rule>> map = this.retrieveVisiblePackagesFromState(desc);
            for (IClasspathContributor cc : RequiredPluginsClasspathContainer.getClasspathContributors()) {
                List<IClasspathEntry> classpathEntries = cc.getInitialEntries(desc);
                if (classpathEntries == null || classpathEntries.isEmpty()) continue;
                entries.addAll(classpathEntries);
            }
            HashSet<BundleDescription> added = new HashSet<BundleDescription>();
            added.add(desc);
            HostSpecification host = desc.getHost();
            if (host != null) {
                this.addHostPlugin(host, added, map, entries);
            } else if ("true".equals(System.getProperty("pde.allowCycles"))) {
                BundleDescription[] fragments;
                bundleDescriptionArray = fragments = desc.getFragments();
                n2 = fragments.length;
                n = 0;
                while (n < n2) {
                    BundleDescription fragment = bundleDescriptionArray[n];
                    if (fragment.isResolved()) {
                        this.addPlugin(fragment, false, map, entries);
                    }
                    ++n;
                }
            }
            BundleSpecification[] required = desc.getRequiredBundles();
            bundleDescriptionArray = required;
            n2 = required.length;
            n = 0;
            while (n < n2) {
                BundleDescription element = bundleDescriptionArray[n];
                this.addDependency((BundleDescription)element.getSupplier(), added, map, entries);
                ++n;
            }
            if (this.fBuild == null) {
                this.fBuild = ClasspathUtilCore.getBuild(this.fModel);
            }
            if (this.fBuild != null) {
                this.addSecondaryDependencies(desc, added, entries);
            }
            this.addBndClasspath(desc, added, entries);
            TreeMap<String, BundleDescription> sortedMap = new TreeMap<String, BundleDescription>();
            for (BundleDescription bundle : map.keySet()) {
                sortedMap.put(bundle.toString(), bundle);
            }
            for (BundleDescription bundle : sortedMap.values()) {
                IPluginModelBase model = PluginRegistry.findModel(bundle);
                if (model == null || !model.isEnabled()) continue;
                this.addDependencyViaImportPackage(model.getBundleDescription(), added, map, entries);
            }
            if (this.fBuild != null) {
                this.addExtraClasspathEntries(entries);
            }
            this.addJunit5RuntimeDependencies(added, entries);
        }
        catch (CoreException coreException) {}
        return entries;
    }

    private void addBndClasspath(BundleDescription desc, Set<BundleDescription> added, List<IClasspathEntry> entries) {
        try {
            Optional<Project> bndProject = BndProjectManager.getBndProject(this.project);
            if (bndProject.isPresent()) {
                for (Container container : bndProject.get().getBuildpath()) {
                    this.addExtraModel(desc, added, entries, container.getBundleSymbolicName());
                }
                for (Container container : bndProject.get().getTestpath()) {
                    this.addExtraModel(desc, added, entries, container.getBundleSymbolicName());
                }
            }
        }
        catch (Exception e) {
            PDECore.logException(e, "Can't set classpath from bnd!");
        }
    }

    private static synchronized List<IClasspathContributor> getClasspathContributors() {
        if (fClasspathContributors == null) {
            IConfigurationElement[] elements;
            fClasspathContributors = new ArrayList<IClasspathContributor>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.pde.core.pluginClasspathContributors");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    fClasspathContributors.add((IClasspathContributor)element.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    PDECore.log(e.getStatus());
                }
                ++n2;
            }
        }
        return fClasspathContributors;
    }

    private Map<BundleDescription, List<PDEClasspathContainer.Rule>> retrieveVisiblePackagesFromState(BundleDescription desc) {
        HashMap<BundleDescription, List<PDEClasspathContainer.Rule>> visiblePackages = new HashMap<BundleDescription, List<PDEClasspathContainer.Rule>>();
        StateHelper helper = Platform.getPlatformAdmin().getStateHelper();
        this.addVisiblePackagesFromState(helper, desc, visiblePackages);
        if (desc.getHost() != null) {
            this.addVisiblePackagesFromState(helper, (BundleDescription)desc.getHost().getSupplier(), visiblePackages);
        }
        return visiblePackages;
    }

    private void addVisiblePackagesFromState(StateHelper helper, BundleDescription desc, Map<BundleDescription, List<PDEClasspathContainer.Rule>> visiblePackages) {
        ExportPackageDescription[] exports;
        if (desc == null) {
            return;
        }
        ExportPackageDescription[] exportPackageDescriptionArray = exports = helper.getVisiblePackages(desc);
        int n = exports.length;
        int n2 = 0;
        while (n2 < n) {
            PDEClasspathContainer.Rule rule;
            List list;
            ExportPackageDescription export = exportPackageDescriptionArray[n2];
            BundleDescription exporter = export.getExporter();
            if (exporter != null && !(list = visiblePackages.computeIfAbsent(exporter, e -> new ArrayList())).contains(rule = this.getRule(helper, desc, export))) {
                list.add(rule);
            }
            ++n2;
        }
    }

    private PDEClasspathContainer.Rule getRule(StateHelper helper, BundleDescription desc, ExportPackageDescription export) {
        boolean discouraged = helper.getAccessCode(desc, export) == 2;
        String name = export.getName();
        IPath path = name.equals(".") ? IPath.fromOSString((String)"*") : IPath.fromOSString((String)(name.replace('.', '/') + "/*"));
        return new PDEClasspathContainer.Rule(path, discouraged);
    }

    protected void addDependencyViaImportPackage(BundleDescription desc, Set<BundleDescription> added, Map<BundleDescription, List<PDEClasspathContainer.Rule>> map, List<IClasspathEntry> entries) throws CoreException {
        if (desc == null || !added.add(desc)) {
            return;
        }
        this.addPlugin(desc, true, map, entries);
        if (this.hasExtensibleAPI(desc) && desc.getContainingState() != null) {
            BundleDescription[] fragments;
            BundleDescription[] bundleDescriptionArray = fragments = desc.getFragments();
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription fragment = bundleDescriptionArray[n2];
                if (fragment.isResolved()) {
                    this.addDependencyViaImportPackage(fragment, added, map, entries);
                }
                ++n2;
            }
        }
    }

    private void addDependency(BundleDescription desc, Set<BundleDescription> added, Map<BundleDescription, List<PDEClasspathContainer.Rule>> map, List<IClasspathEntry> entries) throws CoreException {
        this.addDependency(desc, added, map, entries, true);
    }

    /*
     * WARNING - void declaration
     */
    private void addDependency(BundleDescription desc, Set<BundleDescription> added, Map<BundleDescription, List<PDEClasspathContainer.Rule>> map, List<IClasspathEntry> entries, boolean useInclusion) throws CoreException {
        BundleSpecification[] required;
        BundleDescription[] fragments;
        if (desc == null || !added.add(desc)) {
            return;
        }
        BundleDescription[] bundleDescriptionArray = fragments = this.hasExtensibleAPI(desc) ? desc.getFragments() : new BundleDescription[]{};
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription fragment = bundleDescriptionArray[n2];
            if (fragment.isResolved() && ClasspathUtilCore.isPatchFragment(fragment)) {
                this.addDependency(fragment, added, map, entries, useInclusion);
            }
            ++n2;
        }
        this.addPlugin(desc, useInclusion, map, entries);
        int i = 0;
        while (i < fragments.length) {
            if (fragments[i].isResolved() && !ClasspathUtilCore.isPatchFragment(fragments[i])) {
                this.addDependency(fragments[i], added, map, entries, useInclusion);
            }
            ++i;
        }
        BundleSpecification[] bundleSpecificationArray = required = desc.getRequiredBundles();
        int n3 = required.length;
        n = 0;
        while (n < n3) {
            BundleSpecification element = bundleSpecificationArray[n];
            if (element.isExported()) {
                this.addDependency((BundleDescription)element.getSupplier(), added, map, entries, useInclusion);
            }
            ++n;
        }
        if (this.addImportedPackages) {
            ImportPackageSpecification[] imports;
            ImportPackageSpecification[] importPackageSpecificationArray = imports = desc.getImportPackages();
            int n4 = imports.length;
            n3 = 0;
            while (n3 < n4) {
                ImportPackageSpecification importSpec = importPackageSpecificationArray[n3];
                BaseDescription supplier = importSpec.getSupplier();
                BaseDescription baseDescription = supplier;
                if (baseDescription instanceof ExportPackageDescription) {
                    void exportPackageDescription;
                    ExportPackageDescription cfr_ignored_0 = (ExportPackageDescription)baseDescription;
                    ExportPackageDescription cfr_ignored_1 = (ExportPackageDescription)baseDescription;
                    this.addDependencyViaImportPackage(exportPackageDescription.getExporter(), added, map, entries);
                }
                ++n3;
            }
        }
    }

    private boolean addPlugin(BundleDescription desc, boolean useInclusions, Map<BundleDescription, List<PDEClasspathContainer.Rule>> map, List<IClasspathEntry> entries) throws CoreException {
        IPluginModelBase model = PluginRegistry.findModel(desc);
        if (model == null || !model.isEnabled()) {
            return false;
        }
        IResource resource = model.getUnderlyingResource();
        List<PDEClasspathContainer.Rule> rules = useInclusions ? this.getInclusions(map, model) : null;
        BundleDescription hostBundle = this.fModel.getBundleDescription();
        if (desc == null) {
            return false;
        }
        for (IClasspathContributor cc : RequiredPluginsClasspathContainer.getClasspathContributors()) {
            List<IClasspathEntry> classpathEntries = cc.getEntriesForDependency(hostBundle, desc);
            if (classpathEntries == null || classpathEntries.isEmpty()) continue;
            entries.addAll(classpathEntries);
        }
        if (resource != null) {
            this.addProjectEntry(resource.getProject(), rules, model.getPluginBase().exportsExternalAnnotations(), entries);
        } else {
            RequiredPluginsClasspathContainer.addExternalPlugin(model, rules, entries);
        }
        return true;
    }

    private List<PDEClasspathContainer.Rule> getInclusions(Map<BundleDescription, List<PDEClasspathContainer.Rule>> map, IPluginModelBase model) {
        List<PDEClasspathContainer.Rule> rules;
        BundleDescription desc = model.getBundleDescription();
        if (desc == null || "false".equals(System.getProperty("pde.restriction")) || !(this.fModel instanceof IBundlePluginModelBase) || TargetPlatformHelper.getTargetVersion() < 3.1) {
            return null;
        }
        if (desc.getHost() != null) {
            desc = (BundleDescription)desc.getHost().getSupplier();
        }
        return (rules = map.getOrDefault(desc, List.of())).isEmpty() && !ClasspathUtilCore.hasBundleStructure(model) ? null : rules;
    }

    /*
     * WARNING - void declaration
     */
    private void addHostPlugin(HostSpecification hostSpec, Set<BundleDescription> added, Map<BundleDescription, List<PDEClasspathContainer.Rule>> map, List<IClasspathEntry> entries) throws CoreException {
        BaseDescription desc = hostSpec.getSupplier();
        BaseDescription baseDescription = desc;
        if (baseDescription instanceof BundleDescription) {
            void host;
            BundleDescription bundleDescription = (BundleDescription)baseDescription;
            BundleDescription cfr_ignored_0 = (BundleDescription)baseDescription;
            if (added.add((BundleDescription)host) && this.addPlugin((BundleDescription)host, false, map, entries)) {
                ImportPackageSpecification[] imports;
                BundleSpecification[] required;
                BundleSpecification[] bundleSpecificationArray = required = host.getRequiredBundles();
                int n = required.length;
                int n2 = 0;
                while (n2 < n) {
                    BundleSpecification bundleSpec = bundleSpecificationArray[n2];
                    this.addDependency((BundleDescription)bundleSpec.getSupplier(), added, map, entries);
                    ++n2;
                }
                ImportPackageSpecification[] importPackageSpecificationArray = imports = host.getImportPackages();
                int n3 = imports.length;
                n = 0;
                while (n < n3) {
                    ImportPackageSpecification importSpec = importPackageSpecificationArray[n];
                    BaseDescription supplier = importSpec.getSupplier();
                    BaseDescription baseDescription2 = supplier;
                    if (baseDescription2 instanceof ExportPackageDescription) {
                        void exportPackageDescription;
                        ExportPackageDescription cfr_ignored_1 = (ExportPackageDescription)baseDescription2;
                        ExportPackageDescription cfr_ignored_2 = (ExportPackageDescription)baseDescription2;
                        this.addDependencyViaImportPackage(exportPackageDescription.getExporter(), added, map, entries);
                    }
                    ++n;
                }
            }
        }
    }

    private boolean hasExtensibleAPI(BundleDescription desc) {
        IPluginModelBase model = PluginRegistry.findModel(desc);
        return model != null && ClasspathUtilCore.hasExtensibleAPI(model);
    }

    protected void addExtraClasspathEntries(List<IClasspathEntry> entries) {
        IBuildEntry[] buildEntries;
        IBuildEntry[] iBuildEntryArray = buildEntries = this.fBuild.getBuildEntries();
        int n = buildEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildEntry entry = iBuildEntryArray[n2];
            String name = entry.getName();
            if (name.equals("jars.extra.classpath") || name.startsWith("extra.")) {
                this.addExtraClasspathEntries(entries, entry.getTokens());
            }
            ++n2;
        }
    }

    protected void addExtraClasspathEntries(List<IClasspathEntry> entries, String[] tokens) {
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                IPath path;
                block11: {
                    block12: {
                        IFile resource;
                        String token = stringArray[n2];
                        path = IPath.fromPortableString((String)token);
                        if (path.isAbsolute()) break block11;
                        File file = new File(this.fModel.getInstallLocation(), path.toString());
                        if (!file.exists() || (resource = PDECore.getWorkspace().getRoot().getFileForLocation(IPath.fromOSString((String)file.getAbsolutePath()))) == null || !resource.getProject().equals((Object)this.fModel.getUnderlyingResource().getProject())) break block12;
                        this.addExtraLibrary(resource.getFullPath(), null, entries);
                        break block13;
                    }
                    if (path.segmentCount() < 3 || !"..".equals(path.segment(0))) break block13;
                    path = path.removeFirstSegments(1);
                    path = IPath.fromPortableString((String)"platform:/plugin/").append(path);
                }
                if (!path.toPortableString().startsWith("platform:")) {
                    this.addExtraLibrary(path, null, entries);
                } else {
                    String pluginID;
                    IPluginModelBase model;
                    int count;
                    int n3 = count = path.getDevice() == null ? 4 : 3;
                    if (path.segmentCount() >= count && (model = PluginRegistry.findModel(pluginID = path.segment(count - 2))) != null && model.isEnabled()) {
                        path = path.setDevice(null);
                        path = path.removeFirstSegments(count - 1);
                        IResource underlyingResource = model.getUnderlyingResource();
                        if (underlyingResource == null) {
                            IPath result = PDECore.getDefault().getModelManager().getExternalModelManager().getNestedLibrary(model, path.toString());
                            if (result != null) {
                                this.addExtraLibrary(result, model, entries);
                            }
                        } else {
                            IFile file = underlyingResource.getProject().getFile(path);
                            if (file.exists()) {
                                this.addExtraLibrary(file.getFullPath(), model, entries);
                            }
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private void addJunit5RuntimeDependencies(Set<BundleDescription> added, List<IClasspathEntry> entries) throws CoreException {
        String id;
        if (!this.containsJunit5Dependency(added)) {
            return;
        }
        if (this.junit5RuntimeClosure == null) {
            this.junit5RuntimeClosure = RequiredPluginsClasspathContainer.collectJunit5RuntimeRequirements();
        }
        if ((id = this.fModel.getPluginBase().getId()) != null) {
            if (this.junit5RuntimeClosure.stream().map(BundleDescription::getSymbolicName).anyMatch(id::equals)) {
                return;
            }
        }
        for (BundleDescription desc : this.junit5RuntimeClosure) {
            if (added.contains(desc)) continue;
            Map<BundleDescription, List<PDEClasspathContainer.Rule>> rules = Map.of(desc, List.of());
            this.addPlugin(desc, true, rules, entries);
        }
    }

    private boolean containsJunit5Dependency(Collection<BundleDescription> dependencies) {
        return dependencies.stream().map(BundleDescription::getSymbolicName).anyMatch(JUNIT5_API_PLUGINS::contains);
    }

    private static List<BundleDescription> collectJunit5RuntimeRequirements() {
        List<BundleDescription> roots = JUNIT5_RUNTIME_PLUGINS.stream().map(PluginRegistry::findModel).filter(Objects::nonNull).filter(IPluginModelBase::isEnabled).map(IPluginModelBase::getBundleDescription).toList();
        Set<BundleDescription> closure = DependencyManager.findRequirementsClosure(roots, DependencyManager.Options.INCLUDE_OPTIONAL_DEPENDENCIES);
        String systemBundleBSN = TargetPlatformHelper.getPDEState().getSystemBundle();
        return closure.stream().filter(b -> !b.getSymbolicName().equals(systemBundleBSN)).toList();
    }

    private void addSecondaryDependencies(BundleDescription desc, Set<BundleDescription> added, List<IClasspathEntry> entries) {
        try {
            IBuildEntry entry = this.fBuild.getEntry("additional.bundles");
            if (entry != null) {
                String[] tokens;
                String[] stringArray = tokens = entry.getTokens();
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String pluginId = stringArray[n2];
                    this.addExtraModel(desc, added, entries, pluginId);
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    private void addExtraModel(BundleDescription desc, Set<BundleDescription> added, List<IClasspathEntry> entries, String pluginId) throws CoreException {
        IPluginModelBase model = PluginRegistry.findModel(pluginId);
        if (model != null) {
            BundleDescription bundleDesc = model.getBundleDescription();
            if (added.contains(bundleDesc)) {
                return;
            }
            HashMap<BundleDescription, List<PDEClasspathContainer.Rule>> rules = new HashMap<BundleDescription, List<PDEClasspathContainer.Rule>>();
            this.findExportedPackages(bundleDesc, desc, rules);
            this.addDependency(bundleDesc, added, rules, entries, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void findExportedPackages(BundleDescription desc, BundleDescription projectDesc, Map<BundleDescription, List<PDEClasspathContainer.Rule>> map) {
        if (desc != null) {
            ArrayDeque<Object> queue = new ArrayDeque<Object>();
            queue.add(desc);
            while (!queue.isEmpty()) {
                BundleSpecification[] requiredBundles;
                BundleDescription bdesc = (BundleDescription)queue.remove();
                ExportPackageDescription[] expkgs = bdesc.getExportPackages();
                ArrayList<PDEClasspathContainer.Rule> rules = new ArrayList<PDEClasspathContainer.Rule>();
                ExportPackageDescription[] exportPackageDescriptionArray = expkgs;
                int n = expkgs.length;
                int n2 = 0;
                while (n2 < n) {
                    ExportPackageDescription expkg = exportPackageDescriptionArray[n2];
                    boolean discouraged = this.restrictPackage(projectDesc, expkg);
                    IPath path = IPath.fromOSString((String)(expkg.getName().replace('.', '/') + "/*"));
                    rules.add(new PDEClasspathContainer.Rule(path, discouraged));
                    ++n2;
                }
                map.put(bdesc, rules);
                BundleSpecification[] bundleSpecificationArray = requiredBundles = bdesc.getRequiredBundles();
                int n3 = requiredBundles.length;
                n = 0;
                while (n < n3) {
                    BaseDescription bd;
                    BaseDescription baseDescription;
                    BundleSpecification requiredBundle = bundleSpecificationArray[n];
                    if (requiredBundle.isExported() && (baseDescription = (bd = requiredBundle.getSupplier())) instanceof BundleDescription) {
                        void description;
                        BundleDescription cfr_ignored_0 = (BundleDescription)baseDescription;
                        BundleDescription cfr_ignored_1 = (BundleDescription)baseDescription;
                        queue.add(description);
                    }
                    ++n;
                }
            }
        }
    }

    private boolean restrictPackage(BundleDescription desc, ExportPackageDescription pkg) {
        String[] friends = (String[])pkg.getDirective("x-friends");
        if (friends != null) {
            String symbolicName = desc.getSymbolicName();
            return Arrays.stream(friends).noneMatch(symbolicName::equals);
        }
        return (Boolean)pkg.getDirective("x-internal");
    }

    private void addExtraLibrary(IPath path, IPluginModelBase model, List<IClasspathEntry> entries) {
        if (path.segmentCount() > 1) {
            IPath srcPath = null;
            if (model != null) {
                IPath shortPath = path.removeFirstSegments(path.matchingFirstSegments(IPath.fromOSString((String)model.getInstallLocation())));
                srcPath = ClasspathUtilCore.getSourceAnnotation(model, shortPath.toString());
            } else {
                String filename = ClasspathUtilCore.getSourceZipName(path.lastSegment());
                IPath candidate = path.removeLastSegments(1).append(filename);
                if (PDECore.getWorkspace().getRoot().getFile(candidate).exists()) {
                    srcPath = candidate;
                }
            }
            IClasspathEntry clsEntry = JavaCore.newLibraryEntry((IPath)path, (IPath)srcPath, null);
            if (!entries.contains(clsEntry)) {
                entries.add(clsEntry);
            }
        }
    }

    public List<IProject> getAllProjectDependencies() {
        IWorkspaceRoot root = PDECore.getWorkspace().getRoot();
        try {
            this.addImportedPackages = true;
            List<IProject> list = this.computePluginEntriesByModel().stream().filter(cpe -> cpe.getEntryKind() == 2).map(cpe -> cpe.getPath().lastSegment()).map(arg_0 -> ((IWorkspaceRoot)root).getProject(arg_0)).filter(IResource::exists).toList();
            return list;
        }
        finally {
            this.addImportedPackages = false;
        }
    }
}

