/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.internal.dialogs;

import java.util.Collection;
import java.util.Hashtable;
import org.eclipse.gmf.runtime.common.ui.dialogs.SelectableElement;
import org.eclipse.gmf.runtime.common.ui.util.ShiftedImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

public class SelectableElementsLabelProvider
extends LabelProvider
implements ILabelProviderListener {
    private Hashtable baseImagePool = new Hashtable();
    private short width = 0;
    private short height = 0;

    public SelectableElementsLabelProvider() {
    }

    public SelectableElementsLabelProvider(short aWidth, short aHeight) {
        this.width = aWidth;
        this.height = aHeight;
    }

    public Image getImage(Object element) {
        if (element instanceof SelectableElement) {
            SelectableElement selectableElement = (SelectableElement)element;
            String key = Integer.toString(selectableElement.getIconImageDescriptor().hashCode());
            Image image = (Image)this.baseImagePool.get(key);
            if (image == null) {
                ImageDescriptor imageDescriptor = selectableElement.getIconImageDescriptor();
                if (imageDescriptor != null) {
                    image = new ShiftedImageDescriptor(this.width, this.height, imageDescriptor).createImage();
                }
                this.baseImagePool.put(key, image);
            }
            return image;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof SelectableElement) {
            return ((SelectableElement)element).getName();
        }
        return "";
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        this.fireLabelProviderChanged(event);
    }

    public void dispose(Hashtable imagePool) {
        Collection c = imagePool.values();
        for (Image image : c) {
            if (image.isDisposed()) continue;
            image.dispose();
        }
    }

    public void dispose() {
        this.dispose(this.baseImagePool);
        super.dispose();
    }
}

