/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.util;

import java.util.regex.Pattern;

public final class BadKeyException
extends RuntimeException {
    private static final int MIN_CHARS = 5;
    private static final int MAX_CHARS = 25;
    private static final Pattern PATTERN = Pattern.compile("[a-zA-Z][a-zA-z0-9_]*");
    private static final long serialVersionUID = 1L;

    public BadKeyException() {
    }

    private BadKeyException(String message) {
        super(message);
    }

    public static String validate(String key) throws BadKeyException {
        if (key == null) {
            throw new BadKeyException("Key is null");
        }
        int length = key.length();
        if (length < 5) {
            throw new BadKeyException("Key is shorter than the minimum of 5 characters");
        }
        if (length > 25) {
            throw new BadKeyException("Key is longer than the maximum of 25 characters");
        }
        if (!PATTERN.matcher(key).matches()) {
            throw new BadKeyException("Key '" + key + "' does not match pattern " + PATTERN);
        }
        return key;
    }
}

