/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.shared.target.EditDirectoryContainerPage;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.pde.internal.ui.shared.target.StyledBundleLabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class PreviewContainerPage
extends WizardPage {
    private final ITargetDefinition fTarget;
    private final EditDirectoryContainerPage fPage1;
    protected TableViewer fPreviewTable;
    protected Object fInput;

    protected PreviewContainerPage(ITargetDefinition definition, EditDirectoryContainerPage page1) {
        super("ContainerPreviewPage");
        this.setTitle(Messages.PreviewContainerPage_1);
        this.setMessage(Messages.PreviewContainerPage_2);
        this.fTarget = definition;
        this.fPage1 = page1;
    }

    public void createControl(Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, 1, 1, 1808);
        SWTFactory.createLabel(composite, Messages.PreviewContainerPage_3, 1);
        this.fPreviewTable = new TableViewer(composite);
        this.fPreviewTable.setLabelProvider((IBaseLabelProvider)new StyledBundleLabelProvider(true, false));
        this.fPreviewTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fPreviewTable.getControl().setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.pde.doc.user.location_preview_wizard");
    }

    protected void setInput(ITargetLocation container) {
        if (container == null) {
            this.fInput = null;
            this.fPreviewTable.setInput(null);
            return;
        }
        if (container.isResolved()) {
            this.fInput = container.getBundles();
            this.fPreviewTable.setInput(this.fInput);
            return;
        }
        try {
            this.getContainer().run(true, true, monitor -> {
                IStatus result = container.resolve(this.fTarget, monitor);
                this.fInput = monitor.isCanceled() ? new Object[]{Messages.PreviewContainerPage_0} : (!result.isOK() && !result.isMultiStatus() ? new Object[]{result} : container.getBundles());
            });
            this.fPreviewTable.setInput(this.fInput);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.log(e);
            this.setErrorMessage(e.getMessage());
        }
        catch (InterruptedException interruptedException) {}
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setInput(this.fPage1.getBundleContainer());
        }
    }
}

