/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uml2.articles;

import com.ibm.uml2.articles.GettingStartedWithUML2;
import com.ibm.uml2.articles.UML2Article;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.Extension;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.PackageableElement;
import org.eclipse.uml2.PrimitiveType;
import org.eclipse.uml2.Profile;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.Stereotype;
import org.eclipse.uml2.Type;
import org.eclipse.uml2.UML2Factory;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.VisibilityKind;

public class IntroductionToUML2Profiles
extends UML2Article {
    protected static Profile createProfile(String name) {
        Profile profile = UML2Factory.eINSTANCE.createProfile();
        profile.setName(name);
        UML2Article.out("Profile '" + profile.getQualifiedName() + "' created.");
        return profile;
    }

    protected static PrimitiveType importPrimitiveType(Package package_, String name) {
        Model uml2Library = (Model)UML2Article.load(URI.createURI((String)"pathmap://UML2_LIBRARIES/UML2PrimitiveTypes.library.uml2"));
        PrimitiveType primitiveType = (PrimitiveType)uml2Library.getOwnedType(name);
        package_.importElement(VisibilityKind.PUBLIC_LITERAL, (PackageableElement)primitiveType);
        UML2Article.out("Primitive type '" + primitiveType.getQualifiedName() + "' imported.");
        return primitiveType;
    }

    protected static Stereotype createStereotype(Profile profile, String name, boolean isAbstract) {
        Stereotype stereotype = (Stereotype)profile.createOwnedMember(UML2Package.eINSTANCE.getStereotype());
        stereotype.setName(name);
        stereotype.setIsAbstract(isAbstract);
        UML2Article.out("Stereotype '" + stereotype.getQualifiedName() + "' created.");
        return stereotype;
    }

    protected static Class referenceMetaclass(Profile profile, String name) {
        Model uml2Metamodel = (Model)UML2Article.load(URI.createURI((String)"pathmap://UML2_METAMODELS/UML2.metamodel.uml2"));
        Class metaclass = (Class)uml2Metamodel.getOwnedType(name);
        profile.referenceMetaclass(metaclass);
        UML2Article.out("Metaclass '" + metaclass.getQualifiedName() + "' referenced.");
        return metaclass;
    }

    protected static Extension createExtension(EClass metaclass, Stereotype stereotype, boolean required) {
        Extension extension = stereotype.createExtension(metaclass, required);
        UML2Article.out(String.valueOf(required ? "Required extension '" : "Extension '") + extension.getQualifiedName() + "' created.");
        return extension;
    }

    protected static void defineProfile(Profile profile) {
        profile.define();
        UML2Article.out("Profile '" + profile.getQualifiedName() + "' defined.");
    }

    protected static void applyProfile(Package package_, Profile profile) {
        package_.apply(profile);
        UML2Article.out("Profile '" + profile.getQualifiedName() + "' applied to package '" + package_.getQualifiedName() + "'.");
    }

    protected static void applyStereotype(NamedElement namedElement, Stereotype stereotype) {
        namedElement.apply(stereotype);
        UML2Article.out("Stereotype '" + stereotype.getQualifiedName() + "' applied to element '" + namedElement.getQualifiedName() + "'.");
    }

    protected static Object getStereotypePropertyValue(NamedElement namedElement, Stereotype stereotype, Property property) {
        Object value = namedElement.getValue(stereotype, property.getName());
        UML2Article.out("Value of stereotype property '" + property.getQualifiedName() + "' on element '" + namedElement.getQualifiedName() + "' is " + String.valueOf(value) + ".");
        return value;
    }

    protected static void setStereotypePropertyValue(NamedElement namedElement, Stereotype stereotype, Property property, Object value) {
        namedElement.setValue(stereotype, property.getName(), value);
        UML2Article.out("Value of stereotype property '" + property.getQualifiedName() + "' on element '" + namedElement.getQualifiedName() + "' set to " + String.valueOf(value) + ".");
    }

    public static void main(String[] args) {
        if (2 != args.length) {
            UML2Article.err("Usage: java IntroductionToUML2Profiles <URI> <URI>");
            System.exit(1);
        }
        UML2Article.registerResourceFactories();
        UML2Article.registerPathmaps(URI.createURI((String)args[1]));
        UML2Article.out("Creating profile...");
        Profile ecoreProfile = IntroductionToUML2Profiles.createProfile("ecore");
        UML2Article.out("Importing primitive types...");
        PrimitiveType booleanPrimitiveType = IntroductionToUML2Profiles.importPrimitiveType((Package)ecoreProfile, "Boolean");
        PrimitiveType stringPrimitiveType = IntroductionToUML2Profiles.importPrimitiveType((Package)ecoreProfile, "String");
        UML2Article.out("Creating stereotypes...");
        Stereotype eStructuralFeatureStereotype = IntroductionToUML2Profiles.createStereotype(ecoreProfile, "EStructuralFeature", true);
        Stereotype eAttributeStereotype = IntroductionToUML2Profiles.createStereotype(ecoreProfile, "EAttribute", false);
        Stereotype eReferenceStereotype = IntroductionToUML2Profiles.createStereotype(ecoreProfile, "EReference", false);
        UML2Article.out("Creating stereotype generalizations...");
        GettingStartedWithUML2.createGeneralization((Classifier)eAttributeStereotype, (Classifier)eStructuralFeatureStereotype);
        GettingStartedWithUML2.createGeneralization((Classifier)eReferenceStereotype, (Classifier)eStructuralFeatureStereotype);
        UML2Article.out("Creating stereotype properties...");
        Property isTransientProperty = GettingStartedWithUML2.createAttribute((Class)eStructuralFeatureStereotype, "isTransient", (Type)booleanPrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute((Class)eStructuralFeatureStereotype, "isUnsettable", (Type)booleanPrimitiveType, 0, 1);
        Property isVolatileProperty = GettingStartedWithUML2.createAttribute((Class)eStructuralFeatureStereotype, "isVolatile", (Type)booleanPrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute((Class)eAttributeStereotype, "attributeName", (Type)stringPrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute((Class)eAttributeStereotype, "isID", (Type)booleanPrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute((Class)eReferenceStereotype, "referenceName", (Type)stringPrimitiveType, 0, 1);
        Property isResolveProxiesProperty = GettingStartedWithUML2.createAttribute((Class)eReferenceStereotype, "isResolveProxies", (Type)booleanPrimitiveType, 0, 1);
        isResolveProxiesProperty.setBooleanDefault(true);
        UML2Article.out("Referencing metaclasses...");
        IntroductionToUML2Profiles.referenceMetaclass(ecoreProfile, UML2Package.eINSTANCE.getProperty().getName());
        UML2Article.out("Creating extensions...");
        IntroductionToUML2Profiles.createExtension(UML2Package.eINSTANCE.getProperty(), eAttributeStereotype, false);
        IntroductionToUML2Profiles.createExtension(UML2Package.eINSTANCE.getProperty(), eReferenceStereotype, false);
        UML2Article.out("Defining profile...");
        IntroductionToUML2Profiles.defineProfile(ecoreProfile);
        UML2Article.out("Saving profile...");
        UML2Article.save((Package)ecoreProfile, URI.createURI((String)args[0]).appendSegment("Ecore").appendFileExtension("profile.uml2"));
        UML2Article.out("Loading model...");
        Model epo2Model = (Model)UML2Article.load(URI.createURI((String)args[0]).appendSegment("ExtendedPO2").appendFileExtension("uml2"));
        UML2Article.out("Applying profile...");
        IntroductionToUML2Profiles.applyProfile((Package)epo2Model, ecoreProfile);
        UML2Article.out("Applying stereotypes...");
        Class supplierClass = (Class)epo2Model.getOwnedType("Supplier");
        Property pendingOrdersProperty = supplierClass.getOwnedAttribute("pendingOrders");
        IntroductionToUML2Profiles.applyStereotype((NamedElement)pendingOrdersProperty, eReferenceStereotype);
        Property shippedOrdersProperty = supplierClass.getOwnedAttribute("shippedOrders");
        IntroductionToUML2Profiles.applyStereotype((NamedElement)shippedOrdersProperty, eReferenceStereotype);
        Class purchaseOrderClass = (Class)epo2Model.getOwnedType("PurchaseOrder");
        Property totalAmountProperty = purchaseOrderClass.getOwnedAttribute("totalAmount");
        IntroductionToUML2Profiles.applyStereotype((NamedElement)totalAmountProperty, eAttributeStereotype);
        Property previousOrderProperty = purchaseOrderClass.getOwnedAttribute("previousOrder");
        IntroductionToUML2Profiles.applyStereotype((NamedElement)previousOrderProperty, eReferenceStereotype);
        Property customerProperty = purchaseOrderClass.getOwnedAttribute("customer");
        IntroductionToUML2Profiles.applyStereotype((NamedElement)customerProperty, eReferenceStereotype);
        Class customerClass = (Class)epo2Model.getOwnedType("Customer");
        Property ordersProperty = customerClass.getOwnedAttribute("orders");
        IntroductionToUML2Profiles.applyStereotype((NamedElement)ordersProperty, eReferenceStereotype);
        UML2Article.out("Getting stereotype property values...");
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)pendingOrdersProperty, eReferenceStereotype, isVolatileProperty);
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)pendingOrdersProperty, eReferenceStereotype, isTransientProperty);
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)pendingOrdersProperty, eReferenceStereotype, isResolveProxiesProperty);
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)shippedOrdersProperty, eReferenceStereotype, isVolatileProperty);
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)shippedOrdersProperty, eReferenceStereotype, isTransientProperty);
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)shippedOrdersProperty, eReferenceStereotype, isResolveProxiesProperty);
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)totalAmountProperty, eAttributeStereotype, isVolatileProperty);
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)totalAmountProperty, eAttributeStereotype, isTransientProperty);
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)previousOrderProperty, eReferenceStereotype, isResolveProxiesProperty);
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)customerProperty, eReferenceStereotype, isResolveProxiesProperty);
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)ordersProperty, eReferenceStereotype, isResolveProxiesProperty);
        UML2Article.out("Setting stereotype property values...");
        IntroductionToUML2Profiles.setStereotypePropertyValue((NamedElement)pendingOrdersProperty, eReferenceStereotype, isVolatileProperty, Boolean.TRUE);
        IntroductionToUML2Profiles.setStereotypePropertyValue((NamedElement)pendingOrdersProperty, eReferenceStereotype, isTransientProperty, Boolean.TRUE);
        IntroductionToUML2Profiles.setStereotypePropertyValue((NamedElement)pendingOrdersProperty, eReferenceStereotype, isResolveProxiesProperty, Boolean.FALSE);
        IntroductionToUML2Profiles.setStereotypePropertyValue((NamedElement)shippedOrdersProperty, eReferenceStereotype, isVolatileProperty, Boolean.TRUE);
        IntroductionToUML2Profiles.setStereotypePropertyValue((NamedElement)shippedOrdersProperty, eReferenceStereotype, isTransientProperty, Boolean.TRUE);
        IntroductionToUML2Profiles.setStereotypePropertyValue((NamedElement)shippedOrdersProperty, eReferenceStereotype, isResolveProxiesProperty, Boolean.FALSE);
        IntroductionToUML2Profiles.setStereotypePropertyValue((NamedElement)totalAmountProperty, eAttributeStereotype, isVolatileProperty, Boolean.TRUE);
        IntroductionToUML2Profiles.setStereotypePropertyValue((NamedElement)totalAmountProperty, eAttributeStereotype, isTransientProperty, Boolean.TRUE);
        IntroductionToUML2Profiles.setStereotypePropertyValue((NamedElement)previousOrderProperty, eReferenceStereotype, isResolveProxiesProperty, Boolean.FALSE);
        IntroductionToUML2Profiles.setStereotypePropertyValue((NamedElement)customerProperty, eReferenceStereotype, isResolveProxiesProperty, Boolean.FALSE);
        IntroductionToUML2Profiles.setStereotypePropertyValue((NamedElement)ordersProperty, eReferenceStereotype, isResolveProxiesProperty, Boolean.FALSE);
        UML2Article.out("Getting stereotype property values...");
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)pendingOrdersProperty, eReferenceStereotype, isVolatileProperty);
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)pendingOrdersProperty, eReferenceStereotype, isTransientProperty);
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)pendingOrdersProperty, eReferenceStereotype, isResolveProxiesProperty);
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)shippedOrdersProperty, eReferenceStereotype, isVolatileProperty);
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)shippedOrdersProperty, eReferenceStereotype, isTransientProperty);
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)shippedOrdersProperty, eReferenceStereotype, isResolveProxiesProperty);
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)totalAmountProperty, eAttributeStereotype, isVolatileProperty);
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)totalAmountProperty, eAttributeStereotype, isTransientProperty);
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)previousOrderProperty, eReferenceStereotype, isResolveProxiesProperty);
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)customerProperty, eReferenceStereotype, isResolveProxiesProperty);
        IntroductionToUML2Profiles.getStereotypePropertyValue((NamedElement)ordersProperty, eReferenceStereotype, isResolveProxiesProperty);
        UML2Article.out("Saving model...");
        UML2Article.save((Package)epo2Model, URI.createURI((String)args[0]).appendSegment("ExtendedPO2_Ecore").appendFileExtension("uml2"));
    }
}

