/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.uml2.diagram.common.providers.AlternativeUMLItemProviderAdapterFactory;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class UMLCommonPlugin
extends AbstractUIPlugin {
    public static final String IMAGE_PLUS = "icons/plus.gif";
    public static final String IMAGE_MINUS = "icons/minus.gif";
    private static UMLCommonPlugin plugin;
    private ComposedAdapterFactory adapterFactory;

    public UMLCommonPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.adapterFactory = this.createAdapterFactory();
    }

    public void stop(BundleContext context) throws Exception {
        this.adapterFactory.dispose();
        this.adapterFactory = null;
        super.stop(context);
    }

    private ComposedAdapterFactory createAdapterFactory() {
        ArrayList factories = new ArrayList();
        this.fillItemProviderFactories(factories);
        return new ComposedAdapterFactory(factories);
    }

    private void fillItemProviderFactories(List factories) {
        factories.add(new AlternativeUMLItemProviderAdapterFactory(this.getPreferenceStore()));
        factories.add(new UMLItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
    }

    public AdapterFactory getItemProvidersAdapterFactory() {
        return this.adapterFactory;
    }

    public static UMLCommonPlugin getInstance() {
        return plugin;
    }

    public static String getPluginId() {
        return UMLCommonPlugin.getInstance().getBundle().getSymbolicName();
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        this.addImage(reg, IMAGE_PLUS);
        this.addImage(reg, IMAGE_MINUS);
    }

    private void addImage(ImageRegistry registry, String pluginPath) {
        registry.put(pluginPath, ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)this.getBundle(), (IPath)new Path(pluginPath), null)));
    }
}

