/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.actions;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.notation.DescriptionStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.Messages;
import org.eclipse.uml2.diagram.common.actions.ConvertCommentCommandBase;
import org.eclipse.uml2.diagram.common.actions.UMLDiagramAction;
import org.eclipse.uml2.uml.Comment;

public class ConvertCommentIntoNoteAction
extends UMLDiagramAction {
    private final ConvertCommentCommandBase.Config myConfig;

    public ConvertCommentIntoNoteAction(ConvertCommentCommandBase.Config config) {
        this.myConfig = config;
    }

    @Override
    protected Command getCommand(IGraphicalEditPart editPart) {
        IGraphicalEditPart parentEP = (IGraphicalEditPart)editPart.getParent();
        if (editPart == null) {
            // empty if block
        }
        PreferencesHint preferencesHint = editPart.getDiagramPreferencesHint();
        TransactionalEditingDomain domain = editPart.getEditingDomain();
        Node commentNode = (Node)editPart.getNotationView();
        CompositeTransactionalCommand result = new CompositeTransactionalCommand(editPart.getEditingDomain(), Messages.ConvertCommentIntoNoteAction_command_convert_comment_into_note);
        CreateNoteCommand createNote = new CreateNoteCommand(domain, commentNode, parentEP.getNotationView(), preferencesHint, this.myConfig);
        result.compose((IUndoableOperation)createNote);
        DeleteCommand deleteView = new DeleteCommand((View)commentNode);
        result.compose((IUndoableOperation)deleteView);
        DestroyElementCommand destroyComment = new DestroyElementCommand(new DestroyElementRequest(commentNode.getElement(), false));
        result.compose((IUndoableOperation)destroyComment);
        return new ICommandProxy((ICommand)result);
    }

    private static class CreateNoteCommand
    extends ConvertCommentCommandBase {
        private final Node myToConvert;
        private final View myParent;
        private final PreferencesHint myPreferenceHint;
        private final ConvertCommentCommandBase.Config myConfig;

        public CreateNoteCommand(TransactionalEditingDomain domain, Node toConvert, View parent, PreferencesHint preferenceHint, ConvertCommentCommandBase.Config config) {
            super(domain, Messages.ConvertCommentIntoNoteAction_command_create_note, CreateNoteCommand.getWorkspaceFiles((EObject)toConvert));
            this.myToConvert = toConvert;
            this.myParent = parent;
            this.myPreferenceHint = preferenceHint;
            this.myConfig = config;
        }

        public boolean canExecute() {
            return super.canExecute();
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            Node newNote = this.createNote();
            this.replaceAllLinks(newNote);
            return CommandResult.newOKCommandResult();
        }

        private Node createNote() {
            Node newNote = ViewService.createNode((View)this.myParent, (String)this.myConfig.getNoteVisualId(), (PreferencesHint)this.myPreferenceHint);
            this.migrateNode(this.myToConvert, newNote);
            this.setName((View)this.myToConvert, newNote);
            return newNote;
        }

        private void replaceAllLinks(Node newNote) {
            for (Edge next : this.getAnnotatedElementLinks()) {
                Edge created = ViewService.createEdge((View)newNote, (View)next.getTarget(), (String)this.myConfig.getNoteAttachmentVisualID(), (PreferencesHint)this.myPreferenceHint);
                this.migrateLink(next, created);
            }
        }

        private List<Edge> getAnnotatedElementLinks() {
            LinkedList<Edge> result = new LinkedList<Edge>();
            for (Object next : this.myToConvert.getSourceEdges()) {
                Edge nextEdge = (Edge)next;
                if (!String.valueOf(this.myConfig.getAnnotatedElementVisualID()).equals(nextEdge.getType())) continue;
                result.add(nextEdge);
            }
            return result;
        }

        private void setName(View oldView, Node newView) {
            String description = ((Comment)oldView.getElement()).getBody();
            DescriptionStyle style = (DescriptionStyle)newView.getStyle(NotationPackage.eINSTANCE.getDescriptionStyle());
            if (style == null) {
                style = (DescriptionStyle)newView.createStyle(NotationPackage.eINSTANCE.getDescriptionStyle());
            }
            style.setDescription(description);
        }
    }
}

