/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.actions;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.DescriptionStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.Messages;
import org.eclipse.uml2.diagram.common.actions.ConvertCommentCommandBase;
import org.eclipse.uml2.diagram.common.actions.UMLDiagramAction;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;

public class ConvertNoteToCommentAction
extends UMLDiagramAction {
    private final ConvertCommentCommandBase.Config myConfig;

    public ConvertNoteToCommentAction(ConvertCommentCommandBase.Config config) {
        this.myConfig = config;
    }

    @Override
    protected Command getCommand(IGraphicalEditPart editPart) {
        IGraphicalEditPart parentEP = (IGraphicalEditPart)editPart.getParent();
        if (editPart == null) {
            // empty if block
        }
        PreferencesHint preferencesHint = editPart.getDiagramPreferencesHint();
        TransactionalEditingDomain domain = editPart.getEditingDomain();
        ConvertNoteToCommentCommand result = new ConvertNoteToCommentCommand(domain, (Node)editPart.getNotationView(), parentEP.getNotationView(), preferencesHint, this.myConfig);
        return new ICommandProxy((ICommand)result);
    }

    private static class ConvertNoteToCommentCommand
    extends ConvertCommentCommandBase {
        private final Node myToConvert;
        private final View myParent;
        private final PreferencesHint myPreferenceHint;
        private final ConvertCommentCommandBase.Config myConfig;
        private List<Edge> myAnnotatedElements;

        public ConvertNoteToCommentCommand(TransactionalEditingDomain domain, Node toConvert, View parent, PreferencesHint preferenceHint, ConvertCommentCommandBase.Config config) {
            super(domain, Messages.ConvertNoteToCommentAction_command_convert_note_into_comment, ConvertNoteToCommentCommand.getWorkspaceFiles((EObject)toConvert));
            this.myToConvert = toConvert;
            this.myParent = parent;
            this.myPreferenceHint = preferenceHint;
            this.myConfig = config;
        }

        private List<Edge> getNoteAttachments() {
            if (this.myAnnotatedElements == null) {
                Edge nextEdge;
                this.myAnnotatedElements = new LinkedList<Edge>();
                for (Object next : this.myToConvert.getSourceEdges()) {
                    nextEdge = (Edge)next;
                    if (!this.myConfig.getNoteAttachmentVisualID().equals(nextEdge.getType())) continue;
                    this.myAnnotatedElements.add(nextEdge);
                }
                for (Object next : this.myToConvert.getTargetEdges()) {
                    nextEdge = (Edge)next;
                    if (!this.myConfig.getNoteAttachmentVisualID().equals(nextEdge.getType())) continue;
                    this.myAnnotatedElements.add(nextEdge);
                }
            }
            return this.myAnnotatedElements;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            Element semanticParent = (Element)this.myParent.getElement();
            Comment comment = this.createSemanticComment(semanticParent);
            Node commentNode = this.createCommentView(comment);
            for (Edge next : this.getNoteAttachments()) {
                this.createUMLLink(next, (View)commentNode);
            }
            this.destroyNoteAndItsLinks();
            return CommandResult.newOKCommandResult();
        }

        private void destroyNoteAndItsLinks() {
            ViewUtil.destroy((View)this.myToConvert);
        }

        private Comment createSemanticComment(Element semanticParent) {
            Comment comment = semanticParent.createOwnedComment();
            this.setName((View)this.myToConvert, comment);
            LinkedList<Element> annotated = new LinkedList<Element>();
            for (Edge noteLink : this.getNoteAttachments()) {
                View target;
                View view = target = noteLink.getSource() == this.myToConvert ? noteLink.getTarget() : noteLink.getSource();
                if (!(target.getElement() instanceof Element)) continue;
                annotated.add((Element)target.getElement());
            }
            comment.getAnnotatedElements().addAll(annotated);
            return comment;
        }

        private Node createCommentView(Comment c) {
            String semanticHint = String.valueOf(this.myConfig.getCommentVisualID());
            Node commentView = ViewService.getInstance().createNode((IAdaptable)new EObjectAdapter((EObject)c), this.myParent, semanticHint, -1, false, this.myPreferenceHint);
            this.migrateNode(this.myToConvert, commentView);
            return commentView;
        }

        private Edge createUMLLink(Edge noteLink, View commentNode) {
            View target;
            View view = target = noteLink.getSource() == this.myToConvert ? noteLink.getTarget() : noteLink.getSource();
            if (!(target.getElement() instanceof Element)) {
                return null;
            }
            String linkHint = String.valueOf(this.myConfig.getAnnotatedElementVisualID());
            IAdaptable elementTypeAdapter = new IAdaptable(){

                public Object getAdapter(Class adapter) {
                    if (IElementType.class.equals((Object)adapter)) {
                        return ConvertNoteToCommentCommand.this.myConfig.getAnnotatedElementElementType();
                    }
                    return null;
                }
            };
            Edge result = (Edge)ViewService.getInstance().createEdge(elementTypeAdapter, (View)this.myToConvert.getDiagram(), linkHint, -1, this.myPreferenceHint);
            if (result != null) {
                result.setSource(commentNode);
                result.setTarget(target);
                this.migrateLink(noteLink, result);
            }
            return result;
        }

        private void setName(View oldNote, Comment newComment) {
            String description;
            DescriptionStyle style = (DescriptionStyle)oldNote.getStyle(NotationPackage.eINSTANCE.getDescriptionStyle());
            if (style != null && (description = style.getDescription()) != null && description.length() > 0) {
                newComment.setBody(description);
            }
        }

        public boolean canExecute() {
            return this.myParent.getElement() instanceof Element;
        }
    }
}

