/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.async;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.async.ICanonicalHelper;
import org.eclipse.uml2.diagram.common.async.SyncModelContext;
import org.eclipse.uml2.diagram.common.genapi.IDiagramUpdater;
import org.eclipse.uml2.diagram.common.genapi.IUpdaterNodeDescriptor;
import org.eclipse.uml2.diagram.common.genapi.IVisualIDRegistry;

public class SyncModelNode
implements IAdaptable {
    private final SyncModelContext myContext;
    private View mySyncModelView;
    private List<SyncModelNode> myChildren;
    private SyncModelNode myParent;
    private View mySyncModelCompartment;
    private View myDiagramView;
    private boolean myIsAutoSynchronized;
    private boolean myIsChecked;

    public SyncModelNode(View syncModelRoot, View diagramRoot, SyncModelContext context) {
        this(syncModelRoot, (SyncModelNode)null, context);
        if (syncModelRoot == null) {
            throw new NullPointerException();
        }
        if (diagramRoot != null) {
            if (diagramRoot.getElement() == null) {
                throw new IllegalArgumentException("Diagram root should have an semantic element");
            }
            if (!diagramRoot.getElement().equals(syncModelRoot.getElement())) {
                throw new IllegalArgumentException("Diagram root element : " + diagramRoot.getElement() + ", while SyncModel root element: " + syncModelRoot.getElement());
            }
        }
        this.initWithDiagramView(diagramRoot);
    }

    protected SyncModelNode(View syncModelView, SyncModelNode parent) {
        this(syncModelView, parent, parent.getContext());
    }

    private SyncModelNode(View syncModelView, SyncModelNode parent, SyncModelContext context) {
        this.mySyncModelView = syncModelView;
        this.myParent = parent;
        if (this.myParent != null) {
            this.myParent.addChild(this);
        }
        this.myContext = context;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public void setChecked(boolean isChecked) {
        this.myIsChecked = isChecked;
    }

    public boolean isChecked() {
        return this.myIsChecked;
    }

    public View getSyncModelView() {
        return this.mySyncModelView;
    }

    public View getDiagramView() {
        return this.myDiagramView;
    }

    public boolean isKnownLeaf() {
        int visualID = this.getContext().getRegistry().getVisualID(this.mySyncModelView);
        return this.getContext().getRegistry().isSemanticLeafVisualID(visualID);
    }

    public boolean isInCompartment() {
        return this.mySyncModelCompartment != null;
    }

    public View getSyncModelCompartment() {
        return this.mySyncModelCompartment;
    }

    public boolean isAutoSynchronized() {
        return this.myIsAutoSynchronized;
    }

    public void setAutoSynchronized(boolean isAutoSynchronized) {
        this.myIsAutoSynchronized = isAutoSynchronized;
    }

    public List<SyncModelNode> getChildren() {
        if (this.myChildren == null) {
            this.myChildren = new LinkedList<SyncModelNode>();
            this.createSyncModelChildren();
            if (this.myChildren.isEmpty()) {
                this.myChildren = Collections.emptyList();
            }
        }
        return this.myChildren;
    }

    public SyncModelNode getParent() {
        return this.myParent;
    }

    private void setCompartment(View compartment) {
        this.mySyncModelCompartment = compartment;
    }

    public SyncModelContext getContext() {
        return this.myContext;
    }

    private IDiagramUpdater getUpdater() {
        return this.myContext.getUpdater();
    }

    private PreferencesHint getPreferencesHint() {
        return this.myContext.getPreferencesHint();
    }

    private void addChild(SyncModelNode child) {
        this.myChildren.add(child);
    }

    private void createSyncModelChildren() {
        this.myContext.runCommand(new Runnable(){

            @Override
            public void run() {
                SyncModelNode.this.doCreateSyncModelChildren();
            }
        });
    }

    private void doCreateSyncModelChildren() {
        List<View> directChildren = this.createChildViews(this.mySyncModelView, this.myDiagramView);
        for (View nextDirect : directChildren) {
            SyncModelNode child = this.doCreateNodeView(nextDirect, this);
            View diagramCounterpart = SyncModelNode.findCounterpart(nextDirect, this.myDiagramView);
            child.initWithDiagramView(diagramCounterpart);
        }
        for (Object next : this.mySyncModelView.getChildren()) {
            View nextSyncCompartment = (View)next;
            if (!this.isCompartment(nextSyncCompartment)) continue;
            View diagramCompartment = SyncModelNode.findCounterpart(nextSyncCompartment, this.myDiagramView);
            List<View> syncCompartmentChildren = this.createChildViews(nextSyncCompartment, diagramCompartment);
            for (View nextCompartmentChild : syncCompartmentChildren) {
                SyncModelNode nextResult = this.doCreateNodeView(nextCompartmentChild, this);
                nextResult.setCompartment(nextSyncCompartment);
                View diagramCounterpart = SyncModelNode.findCounterpart(nextCompartmentChild, diagramCompartment);
                nextResult.initWithDiagramView(diagramCounterpart);
            }
        }
    }

    protected SyncModelNode doCreateNodeView(View syncModelView, SyncModelNode parent) {
        return new SyncModelNode(syncModelView, parent);
    }

    private boolean isCompartment(View view) {
        IVisualIDRegistry registry = this.getContext().getRegistry();
        int visualId = registry.getVisualID(view);
        return registry.isCompartmentVisualID(visualId);
    }

    private List<View> createChildViews(View syncModelParent, View diagramViewParent) {
        List<? extends IUpdaterNodeDescriptor> descriptors = this.getUpdater().getSemanticChildren(syncModelParent);
        LinkedList<View> result = new LinkedList<View>();
        Iterator<? extends IUpdaterNodeDescriptor> iterator = descriptors.iterator();
        while (iterator.hasNext()) {
            IUpdaterNodeDescriptor next;
            IUpdaterNodeDescriptor nextDescriptor = next = iterator.next();
            EObject nextSemanticChild = nextDescriptor.getModelElement();
            View nextView = null;
            if (diagramViewParent != null) {
                EList children = diagramViewParent.getChildren();
                boolean found = false;
                Iterator iter = children.iterator();
                while (!found && iter.hasNext()) {
                    View nextDiagramChild = (View)iter.next();
                    if (nextDiagramChild.getElement() == null || !nextDiagramChild.getElement().equals(nextSemanticChild)) continue;
                    nextView = ViewService.createNode((View)syncModelParent, (EObject)nextSemanticChild, (String)nextDiagramChild.getType(), (PreferencesHint)this.getPreferencesHint());
                    found = true;
                }
            }
            if (nextView == null) {
                nextView = ViewService.getInstance().createView(Node.class, (IAdaptable)new EObjectAdapter(nextSemanticChild), syncModelParent, null, -1, true, this.getPreferencesHint());
            }
            if (nextView == null) continue;
            result.add(nextView);
        }
        return result;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(View.class)) {
            return this.mySyncModelView;
        }
        if (adapter.isInstance(this)) {
            return this;
        }
        return null;
    }

    public static View findCounterpart(View syncChild, View diagramParent) {
        if (diagramParent == null) {
            return null;
        }
        for (Object nextChild : diagramParent.getChildren()) {
            View nextDiagramChild = (View)nextChild;
            if (!SyncModelNode.isCounterparts(syncChild, nextDiagramChild)) continue;
            return nextDiagramChild;
        }
        return null;
    }

    public static boolean isCounterparts(View syncView, View diagramView) {
        if (syncView.getType() == null || diagramView.getType() == null) {
            return false;
        }
        if (!syncView.getType().equals(diagramView.getType())) {
            return false;
        }
        if (syncView.getElement() == null) {
            return diagramView.getElement() == null;
        }
        return syncView.getElement().equals(diagramView.getElement());
    }

    public void applyCanonicalStyle() {
        this.checkHasDiagramView();
        this.applyCanonicalStyle(this.getDiagramView());
    }

    private void applyCanonicalStyle(View view) {
        if (this.isKnownLeaf()) {
            return;
        }
        this.doApplyCanonicalStyle(view);
        for (Object nextChild : view.getChildren()) {
            View nextChildView = (View)nextChild;
            if (!this.isCompartment(nextChildView)) continue;
            this.doApplyCanonicalStyle(nextChildView);
        }
    }

    private void doApplyCanonicalStyle(View target) {
        ICanonicalHelper.IMPLEMENTATION.setAutoSynchronized(target, this.isAutoSynchronized());
    }

    protected void initWithDiagramView(View diagramView) {
        this.myDiagramView = diagramView;
        if (this.myDiagramView != null) {
            this.setChecked(true);
            this.myIsAutoSynchronized = ICanonicalHelper.IMPLEMENTATION.isAutoSynchronized(this.myDiagramView);
        } else {
            this.myIsAutoSynchronized = this.getContext().isDiagramInitialization();
            this.setChecked(this.getContext().isDiagramInitialization());
        }
        if (this.isKnownLeaf()) {
            this.myIsAutoSynchronized = false;
        }
    }

    private void checkHasDiagramView() {
        if (this.getDiagramView() == null) {
            throw new IllegalStateException("I am not associated with diagram view:" + this.getSyncModelView());
        }
    }

    void associateWithDiagramView(View diagramView) {
        this.myDiagramView = diagramView;
    }

    void setChosenSyncModelViewType(String type) {
        if (type == null || this.mySyncModelView.getType().equals(type)) {
            return;
        }
        this.myParent.setChildTypeHint(this, type);
    }

    private void forseChildrenRecreation() {
        this.myChildren = null;
        this.getChildren();
    }

    private void correctChildrenStatus(NodeInfo nodeInfo) {
        List<SyncModelNode> newChildren = this.getChildren();
        for (SyncModelNode newChild : newChildren) {
            boolean found = false;
            for (NodeInfo oldChild : nodeInfo.getChildren()) {
                if (!newChild.getSyncModelView().getElement().equals(oldChild.getSemanticElement())) continue;
                newChild.setAutoSynchronized(oldChild.isAutoSynchronized());
                newChild.setChecked(oldChild.isChecked());
                newChild.correctChildrenStatus(oldChild);
                found = true;
            }
            if (found) continue;
            newChild.setAutoSynchronized(false);
            newChild.setChecked(false);
        }
    }

    private void setChildTypeHint(final SyncModelNode childNode, final String type) {
        final NodeInfo nodeInfo = this.collectNodeInfo(childNode);
        final EObject semanticElement = childNode.getSyncModelView().getElement();
        ViewUtil.destroy((View)childNode.getSyncModelView());
        this.myContext.runCommand(new Runnable(){

            @Override
            public void run() {
                try {
                    childNode.mySyncModelView = (View)ViewService.createNode((View)SyncModelNode.this.mySyncModelView, (EObject)semanticElement, (String)type, (PreferencesHint)SyncModelNode.this.getPreferencesHint());
                    childNode.forseChildrenRecreation();
                    childNode.correctChildrenStatus(nodeInfo);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private NodeInfo collectNodeInfo(SyncModelNode node) {
        NodeInfo result = new NodeInfo(node.mySyncModelView.getElement(), node.isChecked(), node.isAutoSynchronized(), new LinkedList<NodeInfo>());
        for (SyncModelNode child : node.getChildren()) {
            NodeInfo childNodeInfo = this.collectNodeInfo(child);
            result.getChildren().add(childNodeInfo);
        }
        return result;
    }

    private static class NodeInfo {
        private final EObject mySemanticElement;
        private final boolean myIsChecked;
        private final boolean myIsAutoSynchronized;
        private final List<NodeInfo> myChildren;

        public NodeInfo(EObject mySemanticElement, boolean isChecked, boolean isAutoSynchronized, List<NodeInfo> myChildren) {
            this.mySemanticElement = mySemanticElement;
            this.myIsChecked = isChecked;
            this.myIsAutoSynchronized = isAutoSynchronized;
            this.myChildren = myChildren;
        }

        public EObject getSemanticElement() {
            return this.mySemanticElement;
        }

        public boolean isChecked() {
            return this.myIsChecked;
        }

        public boolean isAutoSynchronized() {
            return this.myIsAutoSynchronized;
        }

        public List<NodeInfo> getChildren() {
            return this.myChildren;
        }
    }
}

