/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.async;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.uml2.diagram.common.async.ApplySynchronizationCommand;
import org.eclipse.uml2.diagram.common.async.SyncModelContext;
import org.eclipse.uml2.diagram.common.async.SyncModelNode;
import org.eclipse.uml2.diagram.common.async.SynchronizeDiagramDialog;
import org.eclipse.uml2.diagram.common.genapi.IDiagramUpdater;
import org.eclipse.uml2.diagram.common.genapi.IVisualIDRegistry;

public class SynchronizeDiagramAction
implements IObjectActionDelegate {
    private final IVisualIDRegistry myVisualIDRegistry;
    private final IDiagramUpdater myDiagramUpdater;
    private final ILabelProvider myDiagramSpecificLabelProvider;
    private IWorkbenchPart targetPart;
    private View myRootDiagramView;
    private PreferencesHint myPreferencesHint;

    public SynchronizeDiagramAction(IDiagramUpdater diagramUpdater, IVisualIDRegistry visualIDRegistry, ILabelProvider diagramSpecificLabelProvider) {
        this.myDiagramUpdater = diagramUpdater;
        this.myVisualIDRegistry = visualIDRegistry;
        this.myDiagramSpecificLabelProvider = diagramSpecificLabelProvider;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IGraphicalEditPart ep;
        View view;
        int visualId;
        action.setEnabled(false);
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return;
        }
        Object firstSelected = ((IStructuredSelection)selection).getFirstElement();
        this.myRootDiagramView = null;
        this.myPreferencesHint = null;
        if (firstSelected instanceof IGraphicalEditPart && (visualId = this.myVisualIDRegistry.getVisualID(view = (ep = (IGraphicalEditPart)firstSelected).getNotationView())) > 0) {
            if (this.myVisualIDRegistry.isCompartmentVisualID(visualId)) {
                view = (View)view.eContainer();
            }
            this.myRootDiagramView = view;
            this.myPreferencesHint = ep.getDiagramPreferencesHint();
        }
        action.setEnabled(this.myRootDiagramView != null);
    }

    private Shell getShell() {
        return this.targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        SyncModelContext context = this.createContext();
        try {
            SyncModelNode root = this.createRootNode(context);
            SynchronizeDiagramDialog dialog = new SynchronizeDiagramDialog(this.getShell(), root, this.myDiagramSpecificLabelProvider);
            for (ViewerFilter filter : this.createViewerFilters()) {
                dialog.addFilter(filter);
            }
            if (dialog.open() == 0) {
                this.applySynchronization(dialog.getRootSyncNode());
            }
        }
        finally {
            context.dispose();
        }
    }

    protected List<ViewerFilter> createViewerFilters() {
        return Collections.emptyList();
    }

    private void applySynchronization(SyncModelNode syncRoot) {
        SyncModelContext context = syncRoot.getContext();
        ApplySynchronizationCommand applyCommand = new ApplySynchronizationCommand(syncRoot);
        context.runCommand(applyCommand);
        SynchronizeDiagramAction.performCanonicalUpdate(syncRoot.getDiagramView().getDiagram().getElement());
        context.dispose();
    }

    private SyncModelNode createRootNode(SyncModelContext context) {
        final Resource syncModelResource = context.getSyncModelResource();
        final Diagram syncDiagram = ViewService.createDiagram((EObject)this.myRootDiagramView.getDiagram().getElement(), (String)this.myVisualIDRegistry.getModelID(this.myRootDiagramView), (PreferencesHint)this.myPreferencesHint);
        Object syncRoot = this.myRootDiagramView instanceof Diagram ? syncDiagram : ViewService.createNode((View)syncDiagram, (EObject)this.myRootDiagramView.getElement(), (String)this.myRootDiagramView.getType(), (PreferencesHint)this.myPreferencesHint);
        context.runCommand(new Runnable(){

            @Override
            public void run() {
                syncModelResource.getContents().add((Object)syncDiagram);
            }
        });
        SyncModelNode result = new SyncModelNode((View)syncRoot, this.myRootDiagramView, context);
        return result;
    }

    private SyncModelContext createContext() {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.getEditingDomain(this.myRootDiagramView.eResource().getResourceSet());
        return new SyncModelContext(this.myDiagramUpdater, this.myVisualIDRegistry, this.myPreferencesHint, editingDomain);
    }

    private static void performCanonicalUpdate(EObject modelElement) {
        if (modelElement == null) {
            return;
        }
        List editPolicies = CanonicalEditPolicy.getRegisteredEditPolicies((EObject)modelElement);
        for (CanonicalEditPolicy nextEditPolicy : editPolicies) {
            nextEditPolicy.refresh();
        }
    }
}

