/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.uml2.diagram.common.links.PortOperationsExt;
import org.eclipse.uml2.diagram.common.links.ProvidedInterfaceLink;
import org.eclipse.uml2.diagram.common.links.RefreshComplementaryLinksHelper;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class ProvidedPortLinkHelper {
    private final EObject mySource;
    private final EObject myTarget;
    private final IPreferenceStore myStore;

    public ProvidedPortLinkHelper(AdapterFactoryEditingDomain editingDomain, EObject source, EObject target, IPreferenceStore store) {
        this.mySource = source;
        this.myTarget = target;
        this.myStore = store;
    }

    public void create() {
        Port port = this.getSource();
        Interface targetInterface = this.getTarget();
        if (port == null || targetInterface == null) {
            return;
        }
        Type portType = port.getType();
        if (portType == null) {
            port.setType((Type)targetInterface);
            RefreshComplementaryLinksHelper.getInstance().addNotificationDescription((EObject)port, NotationPackage.eINSTANCE.getView_SourceEdges(), "Port`s provided interfaces after port event");
            return;
        }
        if (portType instanceof Classifier) {
            this.createRealization(port, targetInterface, (Classifier)portType);
            RefreshComplementaryLinksHelper.getInstance().addNotificationDescription((EObject)targetInterface, NotationPackage.eINSTANCE.getView_TargetEdges(), "Interface`s target interface realization links");
        }
    }

    public boolean canCreate() {
        return !this.myStore.getBoolean("org.eclipse.uml2.diagram.preferences.hide_provided_interface_links");
    }

    public void reorientSource(Port newSource) {
        Type portType;
        ProvidedInterfaceLink realization;
        if (this.getTarget().equals(this.getSource().getType())) {
            this.getSource().setType(null);
            realization = null;
            RefreshComplementaryLinksHelper.getInstance().addNotificationDescription((EObject)this.getSource(), NotationPackage.eINSTANCE.getView_SourceEdges(), "Port`s provided interfaces after port event");
        } else {
            realization = PortOperationsExt.getProvideds(this.getSource(), this.getTarget());
            realization.getRealization().getClients().remove((Object)realization.getSource());
            portType = newSource.getType();
            if (portType == null) {
                realization.getRealization().getSuppliers().remove((Object)this.getTarget());
                if (realization.getRealization().getSuppliers().isEmpty() && realization.getRealization().getClients().isEmpty()) {
                    realization.getRealization().destroy();
                }
            } else {
                RefreshComplementaryLinksHelper.getInstance().addNotificationDescription((EObject)newSource, NotationPackage.eINSTANCE.getView_SourceEdges(), "Port`s provided interface`s interface realization links");
            }
        }
        portType = newSource.getType();
        if (portType == null) {
            newSource.setType((Type)this.getTarget());
            RefreshComplementaryLinksHelper.getInstance().addNotificationDescription((EObject)newSource, NotationPackage.eINSTANCE.getView_SourceEdges(), "Port`s provided interfaces after port event");
            return;
        }
        if (portType instanceof Classifier) {
            if (realization == null) {
                this.createRealization(newSource, this.getTarget(), (Classifier)portType);
            } else {
                realization.getRealization().getClients().add((Object)((Classifier)portType));
            }
        }
    }

    public boolean canReorientSource(Port newSource) {
        return true;
    }

    public void reorientTarget(Interface newTarget) {
        Port port = this.getSource();
        RefreshComplementaryLinksHelper helper = RefreshComplementaryLinksHelper.getInstance();
        Classifier portType = (Classifier)port.getType();
        if (this.getTarget().equals(portType)) {
            port.setType((Type)newTarget);
            helper.addNotificationDescription((EObject)port, UMLPackage.eINSTANCE.getTypedElement_Type(), "Port`s provided interfaces after port event");
            return;
        }
        helper.addNotificationDescription((EObject)this.getTarget(), NotationPackage.eINSTANCE.getView_TargetEdges(), "Interface`s target interface realization links");
        helper.addNotificationDescription((EObject)newTarget, NotationPackage.eINSTANCE.getView_TargetEdges(), "Interface`s target interface realization links");
        InterfaceRealization dependency = PortOperationsExt.getProvideds(port, this.getTarget()).getRealization();
        dependency.getSuppliers().remove((Object)this.getTarget());
        dependency.getSuppliers().add((Object)newTarget);
    }

    public boolean canReorientTarget(Interface newTarget) {
        return true;
    }

    private Realization createRealization(Port port, Interface targetInterface, Classifier portType) {
        Package realizationContainer = null;
        Port element = this.getSource();
        while (element != null) {
            if (element instanceof Package) {
                realizationContainer = (Package)element;
                break;
            }
            element = element.eContainer();
        }
        if (realizationContainer == null) {
            return null;
        }
        InterfaceRealization realization = UMLFactory.eINSTANCE.createInterfaceRealization();
        realizationContainer.getPackagedElements().add((Object)realization);
        realization.getClients().add((Object)portType);
        realization.getSuppliers().add((Object)targetInterface);
        realization.setContract(targetInterface);
        return realization;
    }

    private Port getSource() {
        return (Port)this.mySource;
    }

    private Interface getTarget() {
        return (Interface)this.myTarget;
    }
}

