/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.uml2.diagram.common.links.PortOperationsExt;
import org.eclipse.uml2.diagram.common.links.RefreshComplementaryLinksHelper;
import org.eclipse.uml2.diagram.common.links.RequiredInterfaceLink;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;

public class RequiredPortLinkHelper {
    private final AdapterFactoryEditingDomain myEditingDomain;
    private final EObject mySource;
    private final EObject myTarget;
    private final IPreferenceStore myStore;

    public RequiredPortLinkHelper(AdapterFactoryEditingDomain editingDomain, EObject source, EObject target, IPreferenceStore store) {
        this.myEditingDomain = editingDomain;
        this.mySource = source;
        this.myTarget = target;
        this.myStore = store;
    }

    public void create() {
        if (this.getSource() == null || this.getTarget() == null || this.getSource().getType() == null) {
            return;
        }
        Type type = this.getSource().getType();
        if (type instanceof Classifier && !(type instanceof Interface)) {
            Classifier classifier = (Classifier)type;
            classifier.createUsage((NamedElement)this.getTarget());
            RefreshComplementaryLinksHelper.getInstance().addNotificationDescription((EObject)this.getTarget(), NotationPackage.eINSTANCE.getView_TargetEdges(), "Usages targeted by interface");
        }
    }

    public boolean canCreate() {
        if (this.myStore.getBoolean("org.eclipse.uml2.diagram.preferences.hide_required_interface_links")) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        Type type = this.getSource().getType();
        if (type == null) {
            return false;
        }
        if (!(type instanceof Classifier) || type instanceof Interface) {
            return false;
        }
        boolean isReadOnly = this.myEditingDomain.isReadOnly(type.eResource());
        return !isReadOnly;
    }

    public void reorientSource(Port newSource) {
        RequiredInterfaceLink link = PortOperationsExt.getRequireds(this.getSource(), this.getTarget());
        link.getLink().getClients().remove((Object)link.getSource());
        link.getLink().getClients().add((Object)newSource.getType());
        RefreshComplementaryLinksHelper.getInstance().addNotificationDescription((EObject)newSource, NotationPackage.eINSTANCE.getView_SourceEdges(), "Usages targeted by link`s target interface");
    }

    public boolean canReorientSource(Port newSource) {
        Type type = newSource.getType();
        return type != null && type instanceof Classifier && !(type instanceof Interface);
    }

    public void reorientTarget(Interface newTarget) {
        RequiredInterfaceLink link = PortOperationsExt.getRequireds(this.getSource(), this.getTarget());
        NamedElement oldTarget = link.getTarget();
        link.getLink().getSuppliers().remove((Object)oldTarget);
        link.getLink().getSuppliers().add((Object)newTarget);
        RefreshComplementaryLinksHelper.getInstance().addNotificationDescription((EObject)newTarget, NotationPackage.eINSTANCE.getView_TargetEdges(), "Usages targeted by interface");
        RefreshComplementaryLinksHelper.getInstance().addNotificationDescription((EObject)oldTarget, NotationPackage.eINSTANCE.getView_TargetEdges(), "Usages targeted by interface");
    }

    public boolean canReorientTarget(Interface newTarget) {
        return true;
    }

    private Port getSource() {
        return (Port)this.mySource;
    }

    private Interface getTarget() {
        return (Interface)this.myTarget;
    }
}

