/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.draw2d;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;

public class UnrestrictedOutsideBorderItemLocator
implements IBorderItemLocator {
    private IFigure parentFigure = null;
    private Rectangle constraint = new Rectangle(0, 0, 0, 0);
    private static final int VERTICAL_OFFSET = 6;

    public UnrestrictedOutsideBorderItemLocator(IFigure parentFigure) {
        this.parentFigure = parentFigure;
    }

    public int getCurrentSideOfParent() {
        return 4;
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        return new Rectangle(this.locateOutsideBorder(proposedLocation), proposedLocation.getSize());
    }

    public void setConstraint(Rectangle constraint) {
        this.constraint = constraint;
    }

    private Rectangle getConstraint() {
        return this.constraint;
    }

    private IFigure getParentFigure() {
        return this.parentFigure;
    }

    public void relocate(IFigure borderItem) {
        Dimension size = this.getSize(borderItem);
        Point ptNewLocation = this.getPreferredLocation(borderItem);
        ptNewLocation = this.locateOutsideBorder(new Rectangle(ptNewLocation, size));
        borderItem.setBounds(new Rectangle(ptNewLocation, size));
    }

    private final Dimension getSize(IFigure borderItem) {
        Dimension size = this.getConstraint().getSize();
        if (size.isEmpty()) {
            size = borderItem.getPreferredSize();
        }
        return size;
    }

    private Point getPreferredLocation(IFigure borderItem) {
        Point constraintLocation = this.getConstraint().getLocation();
        Point parentOrigin = this.getParentBorder().getTopLeft();
        Point ptAbsoluteLocation = parentOrigin.translate(constraintLocation);
        return ptAbsoluteLocation;
    }

    private Rectangle getParentBorder() {
        Rectangle bounds = this.getParentFigure().getBounds().getCopy();
        if (this.getParentFigure() instanceof NodeFigure) {
            bounds = ((NodeFigure)this.getParentFigure()).getHandleBounds().getCopy();
        }
        return bounds;
    }

    private Point locateOutsideBorder(Rectangle proposedRectangle) {
        Rectangle parentRectangle = this.getParentBorder();
        if (parentRectangle.intersects(proposedRectangle)) {
            int y = parentRectangle.y + parentRectangle.height + 6;
            int x = parentRectangle.x + (parentRectangle.width - proposedRectangle.width) / 2;
            return new Point(x, y);
        }
        return proposedRectangle.getLocation();
    }
}

