/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.draw2d.decoration;

import java.util.List;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.uml2.diagram.common.draw2d.decoration.ComposableRotatableDecoration;

public class CompositeDecoration
extends Figure
implements RotatableDecoration {
    private static final Locator NULL_LOCATOR = new LocatorStub();

    public CompositeDecoration() {
        this.setLayoutManager((LayoutManager)new DelegatingLayout());
    }

    public Rectangle getBounds() {
        Rectangle result = super.getBounds();
        for (IFigure iFigure : this.getChildrenImpl()) {
            result = result.union(iFigure.getBounds());
        }
        return result;
    }

    public void addDecoration(ComposableRotatableDecoration figure) {
        if (!this.getChildren().contains(figure)) {
            super.add((IFigure)figure, (Object)NULL_LOCATOR);
        }
    }

    public void removeDecoration(ComposableRotatableDecoration figure) {
        if (this.getChildren().contains(figure)) {
            this.remove((IFigure)figure);
        }
    }

    public void setReferencePoint(Point p) {
        for (Object child : this.getChildren()) {
            if (!(child instanceof RotatableDecoration)) continue;
            ((RotatableDecoration)child).setReferencePoint(p);
        }
    }

    public void setLocation(Point p) {
        super.setLocation(p);
        ComposableRotatableDecoration prev = null;
        for (ComposableRotatableDecoration next : this.getChildrenImpl()) {
            if (prev == null) {
                next.setLocation(p);
            } else {
                Point endPoint = prev.getBoundPoint();
                next.setLocation(endPoint);
            }
            prev = next;
        }
    }

    private List<ComposableRotatableDecoration> getChildrenImpl() {
        return this.getChildren();
    }

    private static class LocatorStub
    implements Locator {
        private LocatorStub() {
        }

        public void relocate(IFigure target) {
        }
    }
}

