/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.editpolicies;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.uml2.diagram.common.editpolicies.AbstractVisualEffectEditPolicy;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.UMLPackage;

public class PortVisualEffectEditPolicy
extends AbstractVisualEffectEditPolicy {
    protected boolean shouldHandleNotificationEvent(Notification event) {
        return UMLPackage.eINSTANCE.getTypedElement_Type() == event.getFeature();
    }

    @Override
    protected void installVisualEffect() {
        this.ensureHasStyle(NotationPackage.eINSTANCE.getLineStyle());
    }

    @Override
    protected void refreshVisualEffect() {
        boolean isMarkedInvalid;
        EObject semanticHost = this.getSemanticHost();
        if (!(semanticHost instanceof Port)) {
            return;
        }
        Port port = (Port)semanticHost;
        IGraphicalEditPart editPart = this.getHostImpl();
        View view = editPart.getNotationView();
        LineStyle lineStyle = (LineStyle)view.getStyle(NotationPackage.eINSTANCE.getLineStyle());
        boolean hasType = port.getType() != null;
        IPreferenceStore store = (IPreferenceStore)editPart.getDiagramPreferencesHint().getPreferenceStore();
        int highlightColor = this.getColor(store, "org.eclipse.uml2.diagram.highlight.color");
        boolean bl = isMarkedInvalid = lineStyle.getLineColor() == highlightColor;
        if (hasType && isMarkedInvalid) {
            int usualColor = this.getColor(store, "Appearance.lineColor");
            this.setLineColor(editPart, lineStyle, usualColor);
        } else if (!hasType && !isMarkedInvalid) {
            this.setLineColor(editPart, lineStyle, highlightColor);
        }
    }

    private int getColor(IPreferenceStore store, String name) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)name);
        return FigureUtilities.RGBToInteger((RGB)rgb);
    }

    private void setLineColor(IGraphicalEditPart editPart, LineStyle lineStyle, int color) {
        SetRequest request = new SetRequest(editPart.getEditingDomain(), (EObject)lineStyle, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)color);
        this.executeCommand((Command)new ICommandProxy((ICommand)new SetValueCommand(request)));
    }
}

