/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.internal.draw2d.handles;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.diagram.common.internal.draw2d.handles.ResizeCornerHandle;
import org.eclipse.uml2.diagram.common.internal.draw2d.handles.ResizeFrameSideHandle;
import org.eclipse.uml2.diagram.common.internal.draw2d.handles.U2TMoveHandle;
import org.eclipse.uml2.diagram.common.internal.draw2d.handles.U2TResizeHandle;

public class U2THandleKit {
    public static Color SELECTION_COLOR = new Color((Device)Display.getDefault(), 21, 66, 111);

    private U2THandleKit() {
    }

    public static void addNonResizableHandles(IGraphicalEditPart part, List<Handle> handles) {
        U2THandleKit.addMoveCornerHandles(part, handles);
    }

    public static void addResizableHandles(IGraphicalEditPart part, List<Handle> handles, int directions) {
        U2THandleKit.addResizeCornerHandles(part, handles, directions);
    }

    private static void addResizeCornerHandles(IGraphicalEditPart part, List<Handle> handles, int directions) {
        if (U2THandleKit.checkDirection(directions, 8)) {
            handles.add((Handle)new ResizeFrameSideHandle(part, 8));
            handles.add((Handle)U2THandleKit.createInaccessibleResizeHandle(part, 8));
        }
        if (U2THandleKit.checkDirection(directions, 16)) {
            handles.add((Handle)new ResizeFrameSideHandle(part, 16, 4, -1));
            handles.add((Handle)U2THandleKit.createInaccessibleResizeHandle(part, 16));
        }
        if (U2THandleKit.checkDirection(directions, 1)) {
            handles.add((Handle)new ResizeFrameSideHandle(part, 1));
            handles.add((Handle)U2THandleKit.createInaccessibleResizeHandle(part, 1));
        }
        if (U2THandleKit.checkDirection(directions, 4)) {
            handles.add((Handle)new ResizeFrameSideHandle(part, 4));
            handles.add((Handle)U2THandleKit.createInaccessibleResizeHandle(part, 4));
        }
        if (U2THandleKit.checkDirection(directions, 20)) {
            handles.add(U2THandleKit.createResizeCornerHandle(part, 20));
        }
        if (U2THandleKit.checkDirection(directions, 12)) {
            handles.add(U2THandleKit.createResizeCornerHandle(part, 12));
        }
        if (U2THandleKit.checkDirection(directions, 9)) {
            handles.add(U2THandleKit.createResizeCornerHandle(part, 9));
        }
        if (U2THandleKit.checkDirection(directions, 17)) {
            handles.add(U2THandleKit.createResizeCornerHandle(part, 17));
        }
    }

    public static Handle createResizeCornerHandle(IGraphicalEditPart owner, int direction) {
        U2TResizeHandle handle;
        if (direction == 9 || direction == 17 || direction == 12 || direction == 20) {
            handle = new ResizeCornerHandle((GraphicalEditPart)owner, direction);
            handle.setForegroundColor(SELECTION_COLOR);
        } else {
            handle = new U2TResizeHandle((GraphicalEditPart)owner, direction);
        }
        handle.setDragTracker((DragTracker)new ResizeTracker((GraphicalEditPart)owner, direction));
        return handle;
    }

    private static U2TResizeHandle createInaccessibleResizeHandle(IGraphicalEditPart owner, int direction) {
        U2TResizeHandle handle = new U2TResizeHandle((GraphicalEditPart)owner, direction);
        handle.setDragTracker((DragTracker)new ResizeTracker((GraphicalEditPart)owner, direction));
        handle.setAccessible(false);
        return handle;
    }

    public static Handle createMoveHandle(IGraphicalEditPart part) {
        return new U2TMoveHandle(part, new Insets(3));
    }

    public static void addMoveCornerHandles(IGraphicalEditPart part, List<Handle> handles) {
        handles.add(U2THandleKit.createMoveCornerHandle(part, 20));
        handles.add(U2THandleKit.createMoveCornerHandle(part, 12));
        handles.add(U2THandleKit.createMoveCornerHandle(part, 9));
        handles.add(U2THandleKit.createMoveCornerHandle(part, 17));
    }

    public static Handle createMoveCornerHandle(IGraphicalEditPart owner, int direction) {
        U2TResizeHandle handle = new U2TResizeHandle((GraphicalEditPart)owner, direction);
        handle.setCursor(SharedCursors.SIZEALL);
        return handle;
    }

    private static boolean checkDirection(int direction, int desired) {
        return (direction & desired) == desired;
    }

    public static IFigure createFeedbackFigure(IFigure original) {
        RectangleFigure r = new RectangleFigure(){

            protected void outlineShape(Graphics graphics) {
                if (this.getBounds().width > 0 && this.getBounds().height > 0) {
                    super.outlineShape(graphics);
                }
            }
        };
        r.setFill(false);
        r.setForegroundColor(ColorConstants.black);
        r.setLineStyle(3);
        r.setLineWidth(1);
        return r;
    }
}

